/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.s3.impl;

import akka.http.scaladsl.marshallers.xml.ScalaXmlSupport$;
import akka.http.scaladsl.marshalling.Marshal$;
import akka.http.scaladsl.model.ContentType;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.IllegalUriException;
import akka.http.scaladsl.model.IllegalUriException$;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.Uri;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.ByteRange;
import akka.http.scaladsl.model.headers.Host$;
import akka.http.scaladsl.model.headers.RawHeader;
import akka.stream.alpakka.s3.Proxy;
import akka.stream.alpakka.s3.S3Settings;
import akka.stream.alpakka.s3.impl.ApiVersion;
import akka.stream.alpakka.s3.impl.CopyPartition;
import akka.stream.alpakka.s3.impl.HttpRequests$;
import akka.stream.alpakka.s3.impl.ListBucketVersion1$;
import akka.stream.alpakka.s3.impl.ListBucketVersion2$;
import akka.stream.alpakka.s3.impl.MultipartCopy;
import akka.stream.alpakka.s3.impl.MultipartUpload;
import akka.stream.alpakka.s3.impl.S3Headers;
import akka.stream.alpakka.s3.impl.S3Headers$;
import akka.stream.alpakka.s3.impl.S3Location;
import akka.stream.scaladsl.Source;
import akka.util.ByteString;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;

public final class HttpRequests$ {
    public static final HttpRequests$ MODULE$;

    static {
        new HttpRequests$();
    }

    public HttpRequest listBucket(String bucket, Option<String> prefix, Option<String> continuationToken, S3Settings conf) {
        ApiVersion apiVersion;
        block6: {
            Tuple2 tuple2;
            block5: {
                block4: {
                    apiVersion = conf.listBucketApiVersion();
                    if (!ListBucketVersion1$.MODULE$.equals(apiVersion)) break block4;
                    tuple2 = new Tuple2((Object)None$.MODULE$, (Object)"marker");
                    break block5;
                }
                if (!ListBucketVersion2$.MODULE$.equals(apiVersion)) break block6;
                tuple2 = new Tuple2((Object)new Some((Object)"2"), (Object)"continuation-token");
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 != null) {
                Tuple2 tuple23;
                Option listType = (Option)tuple22._1();
                String continuationTokenName = (String)tuple22._2();
                Tuple2 tuple24 = tuple23 = new Tuple2((Object)listType, (Object)continuationTokenName);
                Option listType2 = (Option)tuple24._1();
                String continuationTokenName2 = (String)tuple24._2();
                Uri.Query query = Uri.Query$.MODULE$.apply(((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"list-type"), (Object)listType2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prefix"), prefix), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)continuationTokenName2), continuationToken)}))).collect((PartialFunction)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Tuple2<String, Option<String>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (A1 != null) {
                            String k = (String)A1._1();
                            Option option = (Option)A1._2();
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                String v = (String)some.x();
                                object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
                                return (B1)object;
                            }
                        }
                        object = function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Tuple2<String, Option<String>> x1) {
                        Option option;
                        Tuple2<String, Option<String>> tuple2 = x1;
                        boolean bl = tuple2 != null && (option = (Option)tuple2._2()) instanceof Some;
                        return bl;
                    }
                }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
                return ((HttpRequest)HttpRequest$.MODULE$.apply(HttpMethods$.MODULE$.GET(), HttpRequest$.MODULE$.apply$default$2(), HttpRequest$.MODULE$.apply$default$3(), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5()).withHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HttpHeader[]{Host$.MODULE$.apply(this.requestAuthority(bucket, conf.s3RegionProvider().getRegion(), conf))}))).withUri(this.requestUri(bucket, (Option<String>)None$.MODULE$, conf).withQuery(query));
            }
            throw new MatchError((Object)tuple22);
        }
        throw new MatchError((Object)apiVersion);
    }

    public Option<String> listBucket$default$2() {
        return None$.MODULE$;
    }

    public Option<String> listBucket$default$3() {
        return None$.MODULE$;
    }

    public HttpRequest getDownloadRequest(S3Location s3Location, HttpMethod method, S3Headers s3Headers, Option<String> versionId2, S3Settings conf) {
        Uri.Query query = (Uri.Query)versionId2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Uri.Query apply(String vId) {
                return Uri.Query$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"versionId"), (Object)URLDecoder.decode(vId, StandardCharsets.UTF_8.toString()))}));
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Uri.Query apply() {
                return Uri.Query$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        });
        return (HttpRequest)this.akka$stream$alpakka$s3$impl$HttpRequests$$s3Request(s3Location, method, (Function1<Uri, Uri>)new Serializable(query){
            public static final long serialVersionUID = 0L;
            private final Uri.Query query$1;

            public final Uri apply(Uri x$2) {
                return x$2.withQuery(this.query$1);
            }
            {
                this.query$1 = query$1;
            }
        }, conf).withDefaultHeaders(s3Headers.headers());
    }

    public HttpMethod getDownloadRequest$default$2() {
        return HttpMethods$.MODULE$.GET();
    }

    public S3Headers getDownloadRequest$default$3() {
        return S3Headers$.MODULE$.empty();
    }

    public Option<String> getDownloadRequest$default$4() {
        return None$.MODULE$;
    }

    public HttpRequest uploadRequest(S3Location s3Location, Source<ByteString, ?> payload, long contentLength2, ContentType contentType2, S3Headers s3Headers, S3Settings conf) {
        return ((HttpRequest)this.akka$stream$alpakka$s3$impl$HttpRequests$$s3Request(s3Location, HttpMethods$.MODULE$.PUT(), this.s3Request$default$3(), conf).withDefaultHeaders(s3Headers.headers())).withEntity((RequestEntity)HttpEntity$.MODULE$.apply(contentType2, contentLength2, payload));
    }

    public HttpRequest initiateMultipartUploadRequest(S3Location s3Location, ContentType contentType2, S3Headers s3Headers, S3Settings conf) {
        return ((HttpRequest)this.akka$stream$alpakka$s3$impl$HttpRequests$$s3Request(s3Location, HttpMethods$.MODULE$.POST(), (Function1<Uri, Uri>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Uri apply(Uri x$3) {
                return x$3.withQuery(Uri.Query$.MODULE$.apply("uploads"));
            }
        }, conf).withDefaultHeaders(s3Headers.headers())).withEntity((RequestEntity)HttpEntity$.MODULE$.empty(contentType2));
    }

    public HttpRequest uploadPartRequest(MultipartUpload upload, int partNumber, Source<ByteString, ?> payload, int payloadSize, S3Headers s3Headers, S3Settings conf) {
        return ((HttpRequest)this.akka$stream$alpakka$s3$impl$HttpRequests$$s3Request(upload.s3Location(), HttpMethods$.MODULE$.PUT(), (Function1<Uri, Uri>)new Serializable(upload, partNumber){
            public static final long serialVersionUID = 0L;
            private final MultipartUpload upload$1;
            private final int partNumber$1;

            public final Uri apply(Uri x$4) {
                return x$4.withQuery(Uri.Query$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partNumber"), (Object)((Object)BoxesRunTime.boxToInteger((int)this.partNumber$1)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"uploadId"), (Object)this.upload$1.uploadId())})));
            }
            {
                this.upload$1 = upload$1;
                this.partNumber$1 = partNumber$1;
            }
        }, conf).withDefaultHeaders(s3Headers.headers())).withEntity((RequestEntity)HttpEntity$.MODULE$.apply((ContentType)ContentTypes$.MODULE$.application$divoctet$minusstream(), (long)payloadSize, payload));
    }

    public S3Headers uploadPartRequest$default$5() {
        return S3Headers$.MODULE$.empty();
    }

    public Future<HttpRequest> completeMultipartUploadRequest(MultipartUpload upload, scala.collection.immutable.Seq<Tuple2<Object, String>> parts, ExecutionContext ec, S3Settings conf) {
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n                    "));
        $buf.$amp$plus(parts.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Elem apply(Tuple2<Object, String> x0$1) {
                Tuple2<Object, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    int partNumber = tuple2._1$mcI$sp();
                    String etag = (String)tuple2._2();
                    NodeBuffer $buf = new NodeBuffer();
                    NodeBuffer $buf2 = new NodeBuffer();
                    $buf2.$amp$plus((Object)BoxesRunTime.boxToInteger((int)partNumber));
                    $buf.$amp$plus((Object)new Elem(null, "PartNumber", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
                    NodeBuffer $buf3 = new NodeBuffer();
                    $buf3.$amp$plus((Object)etag);
                    $buf.$amp$plus((Object)new Elem(null, "ETag", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
                    Elem elem = new Elem(null, "Part", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                    return elem;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom()));
        $buf.$amp$plus((Object)new Text("\n                  "));
        Elem payload = new Elem(null, "CompleteMultipartUpload", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        return Marshal$.MODULE$.apply((Object)payload).to(ScalaXmlSupport$.MODULE$.defaultNodeSeqMarshaller(), ec).map((Function1)new Serializable(upload, conf){
            public static final long serialVersionUID = 0L;
            public final MultipartUpload upload$2;
            private final S3Settings conf$1;

            public final HttpRequest apply(RequestEntity entity) {
                return HttpRequests$.MODULE$.akka$stream$alpakka$s3$impl$HttpRequests$$s3Request(this.upload$2.s3Location(), HttpMethods$.MODULE$.POST(), (Function1<Uri, Uri>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.completeMultipartUploadRequest.1 $outer;

                    public final Uri apply(Uri x$5) {
                        return x$5.withQuery(Uri.Query$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"uploadId"), (Object)this.$outer.upload$2.uploadId())})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, this.conf$1).withEntity(entity);
            }
            {
                this.upload$2 = upload$2;
                this.conf$1 = conf$1;
            }
        }, ec);
    }

    public HttpRequest uploadCopyPartRequest(MultipartCopy multipartCopy2, Option<String> sourceVersionId, S3Headers s3Headers, S3Settings conf) {
        MultipartUpload upload = multipartCopy2.multipartUpload();
        CopyPartition copyPartition = multipartCopy2.copyPartition();
        Option<ByteRange.Slice> range = copyPartition.range();
        S3Location source = copyPartition.sourceLocation();
        String sourceHeaderValuePrefix = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{source.bucket(), source.key()}));
        String sourceHeaderValue = (String)sourceVersionId.map((Function1)new Serializable(sourceHeaderValuePrefix){
            public static final long serialVersionUID = 0L;
            private final String sourceHeaderValuePrefix$1;

            public final String apply(String versionId2) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "?versionId=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sourceHeaderValuePrefix$1, versionId2}));
            }
            {
                this.sourceHeaderValuePrefix$1 = sourceHeaderValuePrefix$1;
            }
        }).getOrElse((Function0)new Serializable(sourceHeaderValuePrefix){
            public static final long serialVersionUID = 0L;
            private final String sourceHeaderValuePrefix$1;

            public final String apply() {
                return this.sourceHeaderValuePrefix$1;
            }
            {
                this.sourceHeaderValuePrefix$1 = sourceHeaderValuePrefix$1;
            }
        });
        RawHeader sourceHeader = new RawHeader("x-amz-copy-source", sourceHeaderValue);
        scala.collection.immutable.Seq copyHeaders = (scala.collection.immutable.Seq)range.map((Function1)new Serializable(sourceHeader){
            public static final long serialVersionUID = 0L;
            private final RawHeader sourceHeader$1;

            public final scala.collection.immutable.Seq<RawHeader> apply(ByteRange.Slice br) {
                return (scala.collection.immutable.Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RawHeader[]{this.sourceHeader$1, new RawHeader("x-amz-copy-source-range", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bytes=", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)br.first()), BoxesRunTime.boxToLong((long)(br.last() - 1L))})))}));
            }
            {
                this.sourceHeader$1 = sourceHeader$1;
            }
        }).getOrElse((Function0)new Serializable(sourceHeader){
            public static final long serialVersionUID = 0L;
            private final RawHeader sourceHeader$1;

            public final scala.collection.immutable.Seq<RawHeader> apply() {
                return (scala.collection.immutable.Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RawHeader[]{this.sourceHeader$1}));
            }
            {
                this.sourceHeader$1 = sourceHeader$1;
            }
        });
        Seq allHeaders = (Seq)s3Headers.headers().$plus$plus((GenTraversableOnce)copyHeaders, scala.collection.Seq$.MODULE$.canBuildFrom());
        return (HttpRequest)this.akka$stream$alpakka$s3$impl$HttpRequests$$s3Request(upload.s3Location(), HttpMethods$.MODULE$.PUT(), (Function1<Uri, Uri>)new Serializable(upload, copyPartition){
            public static final long serialVersionUID = 0L;
            private final MultipartUpload upload$3;
            private final CopyPartition copyPartition$1;

            public final Uri apply(Uri x$6) {
                return x$6.withQuery(Uri.Query$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partNumber"), (Object)((Object)BoxesRunTime.boxToInteger((int)this.copyPartition$1.partNumber())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"uploadId"), (Object)this.upload$3.uploadId())})));
            }
            {
                this.upload$3 = upload$3;
                this.copyPartition$1 = copyPartition$1;
            }
        }, conf).withDefaultHeaders(allHeaders);
    }

    public Option<String> uploadCopyPartRequest$default$2() {
        return None$.MODULE$;
    }

    public S3Headers uploadCopyPartRequest$default$3() {
        return S3Headers$.MODULE$.empty();
    }

    public HttpRequest akka$stream$alpakka$s3$impl$HttpRequests$$s3Request(S3Location s3Location, HttpMethod method, Function1<Uri, Uri> uriFn, S3Settings conf) {
        return ((HttpRequest)HttpRequest$.MODULE$.apply(method, HttpRequest$.MODULE$.apply$default$2(), HttpRequest$.MODULE$.apply$default$3(), HttpRequest$.MODULE$.apply$default$4(), HttpRequest$.MODULE$.apply$default$5()).withHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new HttpHeader[]{Host$.MODULE$.apply(this.requestAuthority(s3Location.bucket(), conf.s3RegionProvider().getRegion(), conf))}))).withUri((Uri)uriFn.apply((Object)this.requestUri(s3Location.bucket(), (Option<String>)new Some((Object)s3Location.key()), conf)));
    }

    private Function1<Uri, Uri> s3Request$default$3() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Uri apply(Uri x) {
                return (Uri)Predef$.MODULE$.identity((Object)x);
            }
        };
    }

    private Uri.Authority requestAuthority(String bucket, String region, S3Settings conf) throws IllegalUriException {
        Option<Proxy> option;
        block10: {
            Uri.Authority authority;
            block9: {
                block6: {
                    Option option2;
                    block8: {
                        Uri.Authority authority2;
                        Option option3;
                        Tuple2 tuple2;
                        block7: {
                            option = conf.proxy();
                            if (!None$.MODULE$.equals(option)) break block6;
                            if (conf.pathStyleAccess()) break block7;
                            Regex bucketRegex = new StringOps(Predef$.MODULE$.augmentString("[^a-z0-9\\-\\.]{1,255}|[\\.]{2,}")).r();
                            option2 = bucketRegex.findFirstIn((CharSequence)bucket);
                            if (option2 instanceof Some) {
                                Some some = (Some)option2;
                                String illegalCharacter = (String)some.x();
                                throw IllegalUriException$.MODULE$.apply("Bucket name contains non-LDH characters", new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The following character is not allowed: ", "\n                   | This may be solved by setting akka.stream.alpakka.s3.path-style-access to true in the configuration.\n                 "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{illegalCharacter})))).stripMargin());
                            }
                            if (!None$.MODULE$.equals(option2)) break block8;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        if ((tuple2 = new Tuple2((Object)region, conf.endpointUrl())) != null && (option3 = (Option)tuple2._2()) instanceof Some) {
                            Some some = (Some)option3;
                            String endpointUrl = (String)some.x();
                            authority2 = Uri$.MODULE$.apply(endpointUrl).authority();
                        } else {
                            String string;
                            authority2 = tuple2 != null && "us-east-1".equals(string = (String)tuple2._1()) ? (conf.pathStyleAccess() ? new Uri.Authority(Uri.Host$.MODULE$.apply("s3.amazonaws.com", Uri.Host$.MODULE$.apply$default$2(), Uri.Host$.MODULE$.apply$default$3()), Uri.Authority$.MODULE$.apply$default$2(), Uri.Authority$.MODULE$.apply$default$3()) : new Uri.Authority(Uri.Host$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".s3.amazonaws.com"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket})), Uri.Host$.MODULE$.apply$default$2(), Uri.Host$.MODULE$.apply$default$3()), Uri.Authority$.MODULE$.apply$default$2(), Uri.Authority$.MODULE$.apply$default$3())) : (conf.pathStyleAccess() ? new Uri.Authority(Uri.Host$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"s3-", ".amazonaws.com"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{region})), Uri.Host$.MODULE$.apply$default$2(), Uri.Host$.MODULE$.apply$default$3()), Uri.Authority$.MODULE$.apply$default$2(), Uri.Authority$.MODULE$.apply$default$3()) : new Uri.Authority(Uri.Host$.MODULE$.apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".s3-", ".amazonaws.com"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bucket, region})), Uri.Host$.MODULE$.apply$default$2(), Uri.Host$.MODULE$.apply$default$3()), Uri.Authority$.MODULE$.apply$default$2(), Uri.Authority$.MODULE$.apply$default$3()));
                        }
                        authority = authority2;
                        break block9;
                    }
                    throw new MatchError((Object)option2);
                }
                if (!(option instanceof Some)) break block10;
                Some some = (Some)option;
                Proxy proxy = (Proxy)some.x();
                authority = new Uri.Authority(Uri.Host$.MODULE$.apply(proxy.host(), Uri.Host$.MODULE$.apply$default$2(), Uri.Host$.MODULE$.apply$default$3()), Uri.Authority$.MODULE$.apply$default$2(), Uri.Authority$.MODULE$.apply$default$3());
            }
            return authority;
        }
        throw new MatchError(option);
    }

    private Uri requestUri(String bucket, Option<String> key, S3Settings conf) {
        Tuple2 tuple2;
        block5: {
            Uri uri;
            block3: {
                Option option;
                Uri uri2;
                block4: {
                    Option option2;
                    block2: {
                        Option option3;
                        Uri.Path path;
                        Uri.Path$.Empty$ basePath = conf.pathStyleAccess() ? Uri.Path$.MODULE$.$div(bucket) : Uri.Path$.Empty$.MODULE$;
                        Uri.Path x$7 = path = (Uri.Path)key.fold((Function0)new Serializable((Uri.Path)basePath){
                            public static final long serialVersionUID = 0L;
                            private final Uri.Path basePath$1;

                            public final Uri.Path apply() {
                                return this.basePath$1;
                            }
                            {
                                this.basePath$1 = basePath$1;
                            }
                        }, (Function1)new Serializable((Uri.Path)basePath){
                            public static final long serialVersionUID = 0L;
                            private final Uri.Path basePath$1;

                            public final Uri.Path apply(String someKey) {
                                return (Uri.Path)Predef$.MODULE$.refArrayOps((Object[])someKey.split("/")).foldLeft((Object)this.basePath$1, (Function2)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Uri.Path apply(Uri.Path acc, String p) {
                                        return acc.$div(p);
                                    }
                                });
                            }
                            {
                                this.basePath$1 = basePath$1;
                            }
                        });
                        Uri.Authority x$8 = this.requestAuthority(bucket, conf.s3RegionProvider().getRegion(), conf);
                        String x$9 = Uri$.MODULE$.apply$default$1();
                        Option x$10 = Uri$.MODULE$.apply$default$4();
                        Option x$11 = Uri$.MODULE$.apply$default$5();
                        uri2 = Uri$.MODULE$.apply(x$9, x$8, x$7, x$10, x$11);
                        tuple2 = new Tuple2(conf.proxy(), conf.endpointUrl());
                        if (tuple2 == null || !((option3 = (Option)tuple2._2()) instanceof Some)) break block2;
                        Some some = (Some)option3;
                        String endpointUri = (String)some.x();
                        uri = uri2.withScheme(Uri$.MODULE$.apply(endpointUri).scheme()).withHost(this.requestAuthority(bucket, conf.s3RegionProvider().getRegion(), conf).host());
                        break block3;
                    }
                    if (tuple2 == null || !None$.MODULE$.equals(option2 = (Option)tuple2._1())) break block4;
                    uri = uri2.withScheme("https").withHost(this.requestAuthority(bucket, conf.s3RegionProvider().getRegion(), conf).host());
                    break block3;
                }
                if (tuple2 == null || !((option = (Option)tuple2._1()) instanceof Some)) break block5;
                Some some = (Some)option;
                Proxy proxy = (Proxy)some.x();
                uri = uri2.withPort(proxy.port()).withScheme(proxy.scheme()).withHost(proxy.host());
            }
            return uri;
        }
        throw new MatchError((Object)tuple2);
    }

    private HttpRequests$() {
        MODULE$ = this;
    }
}

