/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.s3.auth;

import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.headers.RawHeader;
import akka.stream.Materializer;
import akka.stream.alpakka.s3.auth.CanonicalRequest;
import akka.stream.alpakka.s3.auth.CanonicalRequest$;
import akka.stream.alpakka.s3.auth.SigningKey;
import akka.stream.alpakka.s3.auth.package$;
import akka.util.ByteString;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import java.security.MessageDigest;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;

public final class Signer$ {
    public static final Signer$ MODULE$;
    private final DateTimeFormatter akka$stream$alpakka$s3$auth$Signer$$dateFormatter;

    static {
        new Signer$();
    }

    public DateTimeFormatter akka$stream$alpakka$s3$auth$Signer$$dateFormatter() {
        return this.akka$stream$alpakka$s3$auth$Signer$$dateFormatter;
    }

    public Future<HttpRequest> signedRequest(HttpRequest request2, SigningKey key, ZonedDateTime date, Materializer mat) {
        Future hashedBody = ((Future)request2.entity().dataBytes().runWith(package$.MODULE$.digest(package$.MODULE$.digest$default$1()), mat)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ByteString hash) {
                return package$.MODULE$.encodeHex((byte[])hash.toArray(ClassTag$.MODULE$.Byte()));
            }
        }, (ExecutionContext)mat.executionContext());
        return hashedBody.map((Function1)new Serializable(request2, key, date){
            public static final long serialVersionUID = 0L;
            private final HttpRequest request$1;
            private final SigningKey key$1;
            private final ZonedDateTime date$1;

            public final HttpRequest apply(String hb) {
                Vector headersToAdd = (Vector)((Vector)scala.package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RawHeader[]{new RawHeader("x-amz-date", this.date$1.format(Signer$.MODULE$.akka$stream$alpakka$s3$auth$Signer$$dateFormatter())), new RawHeader("x-amz-content-sha256", hb)}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(Signer$.MODULE$.akka$stream$alpakka$s3$auth$Signer$$sessionHeader(this.key$1.credProvider())), Vector$.MODULE$.canBuildFrom());
                HttpRequest reqWithHeaders = this.request$1.withHeaders((scala.collection.immutable.Seq)this.request$1.headers().$plus$plus((GenTraversableOnce)headersToAdd, Seq$.MODULE$.canBuildFrom()));
                CanonicalRequest cr = CanonicalRequest$.MODULE$.from(reqWithHeaders);
                HttpHeader authHeader = Signer$.MODULE$.akka$stream$alpakka$s3$auth$Signer$$authorizationHeader("AWS4-HMAC-SHA256", this.key$1, this.date$1, cr);
                return reqWithHeaders.withHeaders((scala.collection.immutable.Seq)reqWithHeaders.headers().$colon$plus((Object)authHeader, Seq$.MODULE$.canBuildFrom()));
            }
            {
                this.request$1 = request$1;
                this.key$1 = key$1;
                this.date$1 = date$1;
            }
        }, (ExecutionContext)mat.executionContext());
    }

    public ZonedDateTime signedRequest$default$3() {
        return ZonedDateTime.now(ZoneOffset.UTC);
    }

    public Option<HttpHeader> akka$stream$alpakka$s3$auth$Signer$$sessionHeader(AWSCredentialsProvider creds) {
        None$ none$;
        AWSCredentials aWSCredentials = creds.getCredentials();
        if (aWSCredentials instanceof AWSSessionCredentials) {
            AWSSessionCredentials aWSSessionCredentials = (AWSSessionCredentials)aWSCredentials;
            none$ = new Some((Object)new RawHeader("X-Amz-Security-Token", aWSSessionCredentials.getSessionToken()));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public HttpHeader akka$stream$alpakka$s3$auth$Signer$$authorizationHeader(String algorithm, SigningKey key, ZonedDateTime requestDate, CanonicalRequest canonicalRequest) {
        return new RawHeader("Authorization", this.authorizationString(algorithm, key, requestDate, canonicalRequest));
    }

    private String authorizationString(String algorithm, SigningKey key, ZonedDateTime requestDate, CanonicalRequest canonicalRequest) {
        String sign = key.hexEncodedSignature(this.stringToSign(algorithm, key, requestDate, canonicalRequest).getBytes());
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " Credential=", ", SignedHeaders=", ", Signature=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{algorithm, key.credentialString(), canonicalRequest.signedHeaders(), sign}));
    }

    public String stringToSign(String algorithm, SigningKey signingKey, ZonedDateTime requestDate, CanonicalRequest canonicalRequest) {
        MessageDigest digest2 = MessageDigest.getInstance("SHA-256");
        String hashedRequest = package$.MODULE$.encodeHex(digest2.digest(canonicalRequest.canonicalString().getBytes()));
        String date = requestDate.format(this.akka$stream$alpakka$s3$auth$Signer$$dateFormatter());
        String scope = signingKey.scope().scopeString();
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\n", "\\n", "\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{algorithm, date, scope, hashedRequest}));
    }

    private Signer$() {
        MODULE$ = this;
        this.akka$stream$alpakka$s3$auth$Signer$$dateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmssX");
    }
}

