/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.s3;

import akka.actor.ActorSystem;
import akka.http.scaladsl.model.Uri$;
import akka.stream.alpakka.s3.BufferType;
import akka.stream.alpakka.s3.DiskBufferType;
import akka.stream.alpakka.s3.MemoryBufferType$;
import akka.stream.alpakka.s3.Proxy;
import akka.stream.alpakka.s3.S3Settings;
import akka.stream.alpakka.s3.S3Settings$;
import akka.stream.alpakka.s3.impl.ApiVersion;
import akka.stream.alpakka.s3.impl.ListBucketVersion1$;
import akka.stream.alpakka.s3.impl.ListBucketVersion2$;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.AwsRegionProvider;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.typesafe.config.Config;
import java.nio.file.Paths;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple7;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class S3Settings$
implements Serializable {
    public static final S3Settings$ MODULE$;

    static {
        new S3Settings$();
    }

    public S3Settings apply(ActorSystem system) {
        return this.apply(system.settings().config(), this.apply$default$2());
    }

    public S3Settings apply(String configurationPrefix, ActorSystem system) {
        return this.apply(system.settings().config(), configurationPrefix);
    }

    public S3Settings apply(Config config, String configurationPrefix) {
        String string;
        block13: {
            Object object;
            Object object2;
            BufferType bufferType;
            Config s3Config;
            block12: {
                block11: {
                    s3Config = config.getConfig(configurationPrefix);
                    string = s3Config.getString("buffer");
                    if (!"memory".equals(string)) break block11;
                    bufferType = MemoryBufferType$.MODULE$;
                    break block12;
                }
                if (!"disk".equals(string)) break block13;
                String diskBufferPath = s3Config.getString("disk-buffer-path");
                bufferType = new DiskBufferType(Paths.get(diskBufferPath, new String[0]));
            }
            MemoryBufferType$ bufferType2 = bufferType;
            Option maybeProxy = Try$.MODULE$.apply((Function0)new Serializable(s3Config){
                public static final long serialVersionUID = 0L;
                private final Config s3Config$1;

                public final String apply() {
                    return this.s3Config$1.getString("proxy.host");
                }
                {
                    this.s3Config$1 = s3Config$1;
                }
            }).toOption().withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String host) {
                    return new StringOps(Predef$.MODULE$.augmentString(host)).nonEmpty();
                }
            }).map((Function1)new Serializable(s3Config){
                public static final long serialVersionUID = 0L;
                private final Config s3Config$1;

                public final Proxy apply(String host) {
                    return new Proxy(host, this.s3Config$1.getInt("proxy.port"), Uri$.MODULE$.httpScheme(this.s3Config$1.getBoolean("proxy.secure")));
                }
                {
                    this.s3Config$1 = s3Config$1;
                }
            });
            boolean pathStyleAccess = s3Config.getBoolean("path-style-access");
            None$ endpointUrl = s3Config.hasPath("endpoint-url") ? Option$.MODULE$.apply((Object)s3Config.getString("endpoint-url")) : None$.MODULE$;
            String regionProviderPath = "aws.region.provider";
            AwsRegionProvider staticRegionProvider = new AwsRegionProvider(s3Config){
                private String getRegion;
                private final Config s3Config$1;
                private volatile boolean bitmap$0;

                private String getRegion$lzycompute() {
                    anon.1 var1_1 = this;
                    synchronized (var1_1) {
                        if (!this.bitmap$0) {
                            this.getRegion = this.s3Config$1.getString("aws.region.default-region");
                            this.bitmap$0 = true;
                        }
                        // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var1_1
                        this.s3Config$1 = null;
                        return this.getRegion;
                    }
                }

                public String getRegion() {
                    return this.bitmap$0 ? this.getRegion : this.getRegion$lzycompute();
                }
                {
                    this.s3Config$1 = s3Config$1;
                }
            };
            if (s3Config.hasPath(regionProviderPath)) {
                String string2 = s3Config.getString(regionProviderPath);
                Object object3 = "static".equals(string2) ? staticRegionProvider : new DefaultAwsRegionProviderChain();
                object2 = object3;
            } else {
                object2 = new DefaultAwsRegionProviderChain();
            }
            DefaultAwsRegionProviderChain regionProvider = object2;
            String credProviderPath = "aws.credentials.provider";
            if (s3Config.hasPath(credProviderPath)) {
                Object object4;
                String string3 = s3Config.getString(credProviderPath);
                if ("default".equals(string3)) {
                    object4 = DefaultAWSCredentialsProviderChain.getInstance();
                } else if ("static".equals(string3)) {
                    String aki = s3Config.getString("aws.credentials.access-key-id");
                    String sak = s3Config.getString("aws.credentials.secret-access-key");
                    String tokenPath = "aws.credentials.token";
                    BasicSessionCredentials creds = s3Config.hasPath(tokenPath) ? new BasicSessionCredentials(aki, sak, s3Config.getString(tokenPath)) : new BasicAWSCredentials(aki, sak);
                    object4 = new AWSStaticCredentialsProvider((AWSCredentials)creds);
                } else {
                    object4 = "anon".equals(string3) ? new AWSStaticCredentialsProvider((AWSCredentials)new AnonymousAWSCredentials()) : DefaultAWSCredentialsProviderChain.getInstance();
                }
                object = object4;
            } else {
                String deprecatedAccessKeyPath = "aws.access-key-id";
                String deprecatedSecretKeyPath = "aws.secret-access-key";
                boolean hasOldCredentials = s3Config.hasPath(deprecatedAccessKeyPath) && s3Config.hasPath(deprecatedSecretKeyPath);
                object = hasOldCredentials ? new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(s3Config.getString(deprecatedAccessKeyPath), s3Config.getString(deprecatedSecretKeyPath))) : DefaultAWSCredentialsProviderChain.getInstance();
            }
            DefaultAWSCredentialsProviderChain credentialsProvider = object;
            Product apiVersion = (Product)Try$.MODULE$.apply((Function0)new Serializable(s3Config){
                public static final long serialVersionUID = 0L;
                private final Config s3Config$1;

                public final Product apply() {
                    Product product;
                    int n = this.s3Config$1.getInt("list-bucket-api-version");
                    switch (n) {
                        default: {
                            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                        }
                        case 2: {
                            product = ListBucketVersion2$.MODULE$;
                            break;
                        }
                        case 1: {
                            product = ListBucketVersion1$.MODULE$;
                        }
                    }
                    return product;
                }
                {
                    this.s3Config$1 = s3Config$1;
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final ListBucketVersion2$ apply() {
                    return ListBucketVersion2$.MODULE$;
                }
            });
            return new S3Settings(bufferType2, (Option<Proxy>)maybeProxy, (AWSCredentialsProvider)credentialsProvider, (AwsRegionProvider)regionProvider, pathStyleAccess, (Option<String>)endpointUrl, (ApiVersion)apiVersion);
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Buffer type must be 'memory' or 'disk'. Got: [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    public String apply$default$2() {
        return "akka.stream.alpakka.s3";
    }

    public S3Settings create(ActorSystem system) {
        return this.apply(system);
    }

    public S3Settings create(Config config) {
        return this.apply(config, this.apply$default$2());
    }

    public S3Settings apply(BufferType bufferType, Option<Proxy> proxy, AWSCredentialsProvider credentialsProvider, AwsRegionProvider s3RegionProvider, boolean pathStyleAccess, Option<String> endpointUrl, ApiVersion listBucketApiVersion) {
        return new S3Settings(bufferType, proxy, credentialsProvider, s3RegionProvider, pathStyleAccess, endpointUrl, listBucketApiVersion);
    }

    public Option<Tuple7<BufferType, Option<Proxy>, AWSCredentialsProvider, AwsRegionProvider, Object, Option<String>, ApiVersion>> unapply(S3Settings x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple7((Object)x$0.bufferType(), x$0.proxy(), (Object)x$0.credentialsProvider(), (Object)x$0.s3RegionProvider(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.pathStyleAccess()), x$0.endpointUrl(), (Object)x$0.listBucketApiVersion()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private S3Settings$() {
        MODULE$ = this;
    }
}

