/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.alpakka.cassandra.scaladsl;

import akka.NotUsed;
import akka.NotUsed$;
import akka.dispatch.ExecutionContexts;
import akka.stream.alpakka.cassandra.CassandraWriteSettings;
import akka.stream.alpakka.cassandra.scaladsl.CassandraSession;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.FlowWithContext;
import akka.stream.scaladsl.FlowWithContext$;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

public final class CassandraFlow$ {
    public static final CassandraFlow$ MODULE$ = new CassandraFlow$();

    public <T> Flow<T, T, NotUsed> create(CassandraWriteSettings writeSettings, String cqlStatement, Function2<T, PreparedStatement, BoundStatement> statementBinder, CassandraSession session) {
        return Flow$.MODULE$.lazyInitAsync((Function0 & Serializable)() -> {
            Future<PreparedStatement> prepare = session.prepare(cqlStatement);
            return prepare.map((Function1 & Serializable)preparedStatement -> (Flow)Flow$.MODULE$.apply().mapAsync(writeSettings.parallelism(), (Function1 & Serializable)element -> session.executeWrite((Statement)statementBinder.apply(element, preparedStatement)).map((Function1 & Serializable)x$1 -> element, (ExecutionContext)ExecutionContexts.sameThreadExecutionContext$.MODULE$)), session.ec());
        }).mapMaterializedValue((Function1 & Serializable)x$2 -> NotUsed$.MODULE$);
    }

    public <T, Ctx> FlowWithContext<T, Ctx, T, Ctx, NotUsed> withContext(CassandraWriteSettings writeSettings, String cqlStatement, Function2<T, PreparedStatement, BoundStatement> statementBinder, CassandraSession session) {
        return FlowWithContext$.MODULE$.fromTuples(Flow$.MODULE$.lazyInitAsync((Function0 & Serializable)() -> {
            Future<PreparedStatement> prepare = session.prepare(cqlStatement);
            return prepare.map((Function1 & Serializable)preparedStatement -> (Flow)Flow$.MODULE$.apply().mapAsync(writeSettings.parallelism(), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object element = tuple2._1();
                Future future = session.executeWrite((Statement)statementBinder.apply(element, preparedStatement)).map((Function1 & Serializable)x$3 -> tuple2, (ExecutionContext)ExecutionContexts.sameThreadExecutionContext$.MODULE$);
                return future;
            }), session.ec());
        }).mapMaterializedValue((Function1 & Serializable)x$4 -> NotUsed$.MODULE$));
    }

    public <T, K> Flow<T, T, NotUsed> createBatch(CassandraWriteSettings writeSettings, String cqlStatement, Function2<T, PreparedStatement, BoundStatement> statementBinder, Function1<T, K> groupingKey, CassandraSession session) {
        return Flow$.MODULE$.lazyInitAsync((Function0 & Serializable)() -> {
            Future<PreparedStatement> prepareStatement = session.prepare(cqlStatement);
            return prepareStatement.map((Function1 & Serializable)preparedStatement -> (Flow)Flow$.MODULE$.apply().groupedWithin(writeSettings.maxBatchSize(), writeSettings.maxBatchWait()).map((Function1 & Serializable)x$5 -> x$5.groupBy(groupingKey).values().toList()).mapConcat((Function1 & Serializable)x -> (List)Predef$.MODULE$.identity(x)).mapAsyncUnordered(writeSettings.parallelism(), (Function1 & Serializable)list -> {
                scala.collection.immutable.Seq boundStatements = (scala.collection.immutable.Seq)list.map((Function1 & Serializable)t -> (BoundStatement)statementBinder.apply(t, preparedStatement));
                BatchStatement batchStatement = BatchStatement.newInstance((BatchType)writeSettings.batchType()).addAll((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)boundStatements).asJava());
                return session.executeWriteBatch(batchStatement).map((Function1 & Serializable)x$6 -> list, (ExecutionContext)ExecutionContexts.sameThreadExecutionContext$.MODULE$);
            }).mapConcat((Function1 & Serializable)x$7 -> x$7.toList()), session.ec());
        }).mapMaterializedValue((Function1 & Serializable)x$8 -> NotUsed$.MODULE$);
    }

    private CassandraFlow$() {
    }
}

