/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.jdbc.config;

import akka.persistence.jdbc.config.EventJournalTableConfiguration;
import akka.persistence.jdbc.config.EventTagTableConfiguration;
import akka.persistence.jdbc.config.JournalSequenceRetrievalConfig;
import akka.persistence.jdbc.config.JournalSequenceRetrievalConfig$;
import akka.persistence.jdbc.config.LegacyJournalTableConfiguration;
import akka.persistence.jdbc.config.ReadJournalPluginConfig;
import akka.persistence.jdbc.util.ConfigOps$;
import akka.persistence.jdbc.util.ConfigOps$ConfigOperations$;
import com.typesafe.config.Config;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u4AAF\f\u0001A!A\u0001\u0004\u0001B\u0001B\u0003%q\u0005C\u00031\u0001\u0011\u0005\u0011\u0007C\u00046\u0001\t\u0007I\u0011\u0001\u001c\t\ri\u0002\u0001\u0015!\u00038\u0011\u001dY\u0004A1A\u0005\u0002qBa\u0001\u0011\u0001!\u0002\u0013i\u0004bB!\u0001\u0005\u0004%\tA\u0011\u0005\u0007\r\u0002\u0001\u000b\u0011B\"\t\u000f\u001d\u0003!\u0019!C\u0001\u0011\"1A\n\u0001Q\u0001\n%Cq!\u0014\u0001C\u0002\u0013\u0005a\n\u0003\u0004S\u0001\u0001\u0006Ia\u0014\u0005\b'\u0002\u0011\r\u0011\"\u0001U\u0011\u0019i\u0006\u0001)A\u0005+\"9a\f\u0001b\u0001\n\u0003y\u0006BB2\u0001A\u0003%\u0001\rC\u0004e\u0001\t\u0007I\u0011A3\t\r%\u0004\u0001\u0015!\u0003g\u0011\u001dQ\u0007A1A\u0005\u0002-Daa\u001c\u0001!\u0002\u0013a\u0007\"\u00029\u0001\t\u0003\n(!\u0005*fC\u0012Tu.\u001e:oC2\u001cuN\u001c4jO*\u0011\u0001$G\u0001\u0007G>tg-[4\u000b\u0005iY\u0012\u0001\u00026eE\u000eT!\u0001H\u000f\u0002\u0017A,'o]5ti\u0016t7-\u001a\u0006\u0002=\u0005!\u0011m[6b\u0007\u0001\u0019\"\u0001A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g!\tAc&D\u0001*\u0015\tA\"F\u0003\u0002,Y\u0005AA/\u001f9fg\u00064WMC\u0001.\u0003\r\u0019w.\\\u0005\u0003_%\u0012aaQ8oM&<\u0017A\u0002\u001fj]&$h\b\u0006\u00023iA\u00111\u0007A\u0007\u0002/!)\u0001D\u0001a\u0001O\u0005I\"n\\;s]\u0006dG+\u00192mK\u000e{gNZ5hkJ\fG/[8o+\u00059\u0004CA\u001a9\u0013\tItCA\u0010MK\u001e\f7-\u001f&pkJt\u0017\r\u001c+bE2,7i\u001c8gS\u001e,(/\u0019;j_:\f!D[8ve:\fG\u000eV1cY\u0016\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0002\na$\u001a<f]RTu.\u001e:oC2$\u0016M\u00197f\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0016\u0003u\u0002\"a\r \n\u0005}:\"AH#wK:$(j\\;s]\u0006dG+\u00192mK\u000e{gNZ5hkJ\fG/[8o\u0003})g/\u001a8u\u0015>,(O\\1m)\u0006\u0014G.Z\"p]\u001aLw-\u001e:bi&|g\u000eI\u0001\u001bKZ,g\u000e\u001e+bOR\u000b'\r\\3D_:4\u0017nZ;sCRLwN\\\u000b\u0002\u0007B\u00111\u0007R\u0005\u0003\u000b^\u0011!$\u0012<f]R$\u0016m\u001a+bE2,7i\u001c8gS\u001e,(/\u0019;j_:\f1$\u001a<f]R$\u0016m\u001a+bE2,7i\u001c8gS\u001e,(/\u0019;j_:\u0004\u0013!\n6pkJt\u0017\r\\*fcV,gnY3SKR\u0014\u0018.\u001a<bY\u000e{gNZ5hkJ\fG/[8o+\u0005I\u0005CA\u001aK\u0013\tYuC\u0001\u0010K_V\u0014h.\u00197TKF,XM\\2f%\u0016$(/[3wC2\u001cuN\u001c4jO\u00061#n\\;s]\u0006d7+Z9vK:\u001cWMU3ue&,g/\u00197D_:4\u0017nZ;sCRLwN\u001c\u0011\u0002\u0019AdWoZ5o\u0007>tg-[4\u0016\u0003=\u0003\"a\r)\n\u0005E;\"a\u0006*fC\u0012Tu.\u001e:oC2\u0004F.^4j]\u000e{gNZ5h\u00035\u0001H.^4j]\u000e{gNZ5hA\u0005y!/\u001a4sKND\u0017J\u001c;feZ\fG.F\u0001V!\t16,D\u0001X\u0015\tA\u0016,\u0001\u0005ekJ\fG/[8o\u0015\tQ6%\u0001\u0006d_:\u001cWO\u001d:f]RL!\u0001X,\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006\u0001\"/\u001a4sKND\u0017J\u001c;feZ\fG\u000eI\u0001\u000e[\u0006D()\u001e4gKJ\u001c\u0016N_3\u0016\u0003\u0001\u0004\"AI1\n\u0005\t\u001c#aA%oi\u0006qQ.\u0019=Ck\u001a4WM]*ju\u0016\u0004\u0013AH3wK:$8OQ=UC\u001e\u0014UO\u001a4feNK'0Z:QKJ\fV/\u001a:z+\u00051\u0007C\u0001\u0012h\u0013\tA7E\u0001\u0003M_:<\u0017aH3wK:$8OQ=UC\u001e\u0014UO\u001a4feNK'0Z:QKJ\fV/\u001a:zA\u0005y\u0011\r\u001a3TQV$Hm\\<o\u0011>|7.F\u0001m!\t\u0011S.\u0003\u0002oG\t9!i\\8mK\u0006t\u0017\u0001E1eINCW\u000f\u001e3po:Dun\\6!\u0003!!xn\u0015;sS:<G#\u0001:\u0011\u0005MThB\u0001;y!\t)8%D\u0001w\u0015\t9x$\u0001\u0004=e>|GOP\u0005\u0003s\u000e\na\u0001\u0015:fI\u00164\u0017BA>}\u0005\u0019\u0019FO]5oO*\u0011\u0011p\t")
public class ReadJournalConfig {
    private final LegacyJournalTableConfiguration journalTableConfiguration;
    private final EventJournalTableConfiguration eventJournalTableConfiguration;
    private final EventTagTableConfiguration eventTagTableConfiguration;
    private final JournalSequenceRetrievalConfig journalSequenceRetrievalConfiguration;
    private final ReadJournalPluginConfig pluginConfig;
    private final FiniteDuration refreshInterval;
    private final int maxBufferSize;
    private final long eventsByTagBufferSizesPerQuery;
    private final boolean addShutdownHook;

    public LegacyJournalTableConfiguration journalTableConfiguration() {
        return this.journalTableConfiguration;
    }

    public EventJournalTableConfiguration eventJournalTableConfiguration() {
        return this.eventJournalTableConfiguration;
    }

    public EventTagTableConfiguration eventTagTableConfiguration() {
        return this.eventTagTableConfiguration;
    }

    public JournalSequenceRetrievalConfig journalSequenceRetrievalConfiguration() {
        return this.journalSequenceRetrievalConfiguration;
    }

    public ReadJournalPluginConfig pluginConfig() {
        return this.pluginConfig;
    }

    public FiniteDuration refreshInterval() {
        return this.refreshInterval;
    }

    public int maxBufferSize() {
        return this.maxBufferSize;
    }

    public long eventsByTagBufferSizesPerQuery() {
        return this.eventsByTagBufferSizesPerQuery;
    }

    public boolean addShutdownHook() {
        return this.addShutdownHook;
    }

    public String toString() {
        return new StringBuilder(23).append("ReadJournalConfig(").append(this.journalTableConfiguration()).append(",").append(this.pluginConfig()).append(",").append(this.refreshInterval()).append(",").append(this.maxBufferSize()).append(",").append(this.addShutdownHook()).append(")").toString();
    }

    public ReadJournalConfig(Config config) {
        this.journalTableConfiguration = new LegacyJournalTableConfiguration(config);
        this.eventJournalTableConfiguration = new EventJournalTableConfiguration(config);
        this.eventTagTableConfiguration = new EventTagTableConfiguration(config);
        this.journalSequenceRetrievalConfiguration = JournalSequenceRetrievalConfig$.MODULE$.apply(config);
        this.pluginConfig = new ReadJournalPluginConfig(config);
        this.refreshInterval = ConfigOps$ConfigOperations$.MODULE$.asFiniteDuration$extension(ConfigOps$.MODULE$.ConfigOperations(config), "refresh-interval");
        this.maxBufferSize = config.getInt("max-buffer-size");
        this.eventsByTagBufferSizesPerQuery = config.getLong("events-by-tag-buffer-sizes-per-query");
        Predef$.MODULE$.require(this.eventsByTagBufferSizesPerQuery() >= 0L, (Function0 & java.io.Serializable & Serializable)() -> "events-by-tag-buffer-sizes-per-query must not be negative");
        this.addShutdownHook = config.getBoolean("add-shutdown-hook");
    }
}

