/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.cob2xsd.antlr;

import com.legstar.cob2xsd.antlr.CleanerException;
import com.legstar.cob2xsd.antlr.RecognizerErrorHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractCobolSourceCleaner {
    public static final char COBOL_DELIMITER = '.';
    public static final Pattern DATA_DESCRIPTION_START = Pattern.compile("(^|\\s|\\.)\\d(\\d)?(\\s|\\.|$)");
    public static final Pattern DATA_DESCRIPTION_END = Pattern.compile("(\\.$)|(\\.\\s)");
    public static final Pattern ALPHANUM_LITERAL_START = Pattern.compile("(^|\\s)[\\\"']");
    public static final Pattern PROCEDURE_DIVISION = Pattern.compile("^(\\s)*PROCEDURE DIVISION", 2);
    public static final Pattern IDENTIFICATION_DIVISION = Pattern.compile("^(\\s)*ID(ENTIFICATION)? DIVISION", 2);
    public static final Pattern DATA_DIVISION = Pattern.compile("^(\\s)*DATA DIVISION", 2);
    public static final List<String> COMPILER_DIRECTIVES = Arrays.asList("EJECT", "SKIP", "SKIP1", "SKIP2", "SKIP3");
    private RecognizerErrorHandler _errorHandler;

    public AbstractCobolSourceCleaner(RecognizerErrorHandler errorHandler) {
        this._errorHandler = errorHandler;
    }

    public String clean(Reader cobolReader) throws CleanerException {
        if (cobolReader == null) {
            throw new CleanerException("COBOL source was null");
        }
        BufferedReader reader = new BufferedReader(cobolReader);
        StringBuilder cleanedSource = new StringBuilder();
        CleaningContext context = new CleaningContext();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (this.isLineOfCode(line) && this.isDataDivision(line, context)) {
                    cleanedSource.append(this.removeExtraneousCharacters(this.cleanLine(line), context));
                }
                cleanedSource.append("\n");
            }
            if (cleanedSource.length() <= "\n".length()) {
                throw new CleanerException("No data descriptions found. Are you sure this is COBOL source?");
            }
            return cleanedSource.toString();
        }
        catch (IOException e) {
            throw new CleanerException(e);
        }
    }

    public boolean isLineOfCode(String line) {
        if (line.length() < this.getIndicatorAreaPos() + 1) {
            return false;
        }
        if (line.trim().length() == 0) {
            return false;
        }
        if (this.isComment(line)) {
            return false;
        }
        String[] tokens = line.trim().split("[\\s\\.]+");
        return tokens.length != 1 || !COMPILER_DIRECTIVES.contains(tokens[0].toUpperCase(Locale.getDefault()));
    }

    public String cleanLine(String line) {
        String cleanedLine = this.extendedCleanLine(line);
        cleanedLine = ("a" + cleanedLine).trim().substring(1);
        return cleanedLine;
    }

    public abstract boolean isComment(String var1);

    public String extendedCleanLine(String line) {
        return line;
    }

    protected String replaceLongSeparators(String str) {
        return str.replace(", ", "  ").replace("; ", "  ");
    }

    public boolean isDataDivision(String line, CleaningContext context) {
        if (context.isDataDivision()) {
            Matcher matcher = IDENTIFICATION_DIVISION.matcher(line);
            if (matcher.find()) {
                context.setDataDivision(false);
                this.emitErrorMessage("Found identification division in [" + line.trim() + "]. Lines ignored till data division.");
            }
            if ((matcher = PROCEDURE_DIVISION.matcher(line)).find()) {
                context.setDataDivision(false);
                this.emitErrorMessage("Found procedure division in [" + line.trim() + "]. Remaining lines ignored.");
            }
        } else {
            Matcher matcher = DATA_DIVISION.matcher(line);
            if (matcher.find()) {
                context.setDataDivision(true);
                this.emitErrorMessage("Found data division in [" + line.trim() + "]. Started looking for data items.");
            }
        }
        return context.isDataDivision();
    }

    public abstract int getIndicatorAreaPos();

    public String removeExtraneousCharacters(String fragment, CleaningContext context) {
        if (fragment == null || fragment.length() == 0) {
            return fragment;
        }
        StringBuilder cleanedLine = new StringBuilder();
        if (context.isLookingForLevel()) {
            Matcher matcher = DATA_DESCRIPTION_START.matcher(fragment);
            if (matcher.find()) {
                int start;
                int endClean = start = matcher.start() > 0 ? matcher.start() + 1 : matcher.start();
                if (start > 0) {
                    String extraneous;
                    if (this.isArgument(fragment.substring(0, start))) {
                        endClean = matcher.end() - 1;
                    }
                    if ((extraneous = fragment.substring(0, endClean).trim()).length() > 0) {
                        this.emitErrorMessage("Extraneous characters ignored: " + extraneous);
                    }
                }
                for (int i = 0; i < endClean; ++i) {
                    cleanedLine.append(' ');
                }
                if (endClean == start) {
                    cleanedLine.append(fragment.substring(start, matcher.end() - 1));
                    context.setLookingForLevel(false);
                }
                cleanedLine.append(this.removeExtraneousCharacters(fragment.substring(matcher.end() - 1), context));
            } else if (fragment.trim().length() > 0) {
                this.emitErrorMessage("Extraneous characters ignored: " + fragment);
            }
        } else if (context.isAlphanumStarted()) {
            Pattern alphanumLiteralEnd = Pattern.compile("\\" + context.getAlphanumDelimiter() + "($|\\s|,|;|\\" + '.' + ")");
            Matcher alphanumLiteralMatcher = alphanumLiteralEnd.matcher(fragment);
            if (alphanumLiteralMatcher.find()) {
                cleanedLine.append(fragment.substring(0, alphanumLiteralMatcher.end() - 1));
                context.setAlphanumStarted(false);
                cleanedLine.append(this.removeExtraneousCharacters(fragment.substring(alphanumLiteralMatcher.end() - 1), context));
            } else {
                cleanedLine.append(fragment);
            }
        } else {
            Matcher alphanumLiteralMatcher = ALPHANUM_LITERAL_START.matcher(fragment);
            Matcher matcher = DATA_DESCRIPTION_END.matcher(fragment);
            if (alphanumLiteralMatcher.find()) {
                if (matcher.find()) {
                    if (matcher.end() < alphanumLiteralMatcher.end()) {
                        cleanedLine.append(this.replaceLongSeparators(fragment.substring(0, matcher.end())));
                        context.setLookingForLevel(true);
                        cleanedLine.append(this.removeExtraneousCharacters(fragment.substring(matcher.end()), context));
                    } else {
                        cleanedLine.append(this.replaceLongSeparators(fragment.substring(0, alphanumLiteralMatcher.end())));
                        context.setAlphanumDelimiter(fragment.substring(alphanumLiteralMatcher.end() - 1).charAt(0));
                        context.setAlphanumStarted(true);
                        cleanedLine.append(this.removeExtraneousCharacters(fragment.substring(alphanumLiteralMatcher.end()), context));
                    }
                } else {
                    cleanedLine.append(this.replaceLongSeparators(fragment.substring(0, alphanumLiteralMatcher.end())));
                    context.setAlphanumDelimiter(fragment.substring(alphanumLiteralMatcher.end() - 1).charAt(0));
                    context.setAlphanumStarted(true);
                    cleanedLine.append(this.removeExtraneousCharacters(fragment.substring(alphanumLiteralMatcher.end()), context));
                }
            } else if (matcher.find()) {
                cleanedLine.append(this.replaceLongSeparators(fragment.substring(0, matcher.end())));
                context.setLookingForLevel(true);
                cleanedLine.append(this.removeExtraneousCharacters(fragment.substring(matcher.end()), context));
            } else {
                cleanedLine.append(fragment);
            }
        }
        return cleanedLine.toString();
    }

    protected boolean isArgument(String fragment) {
        String s = fragment.trim();
        if (s.length() > 0) {
            return s.charAt(s.length() - 1) != '.';
        }
        return false;
    }

    public void emitErrorMessage(String msg) {
        this.getErrorHandler().addMessageToHistory(msg);
    }

    public RecognizerErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    public static class CleaningContext {
        private boolean _lookingForLevel = true;
        private boolean _inDataDivision = true;
        private boolean _alphanumStarted;
        private char _alphanumDelimiter;

        public boolean isLookingForLevel() {
            return this._lookingForLevel;
        }

        public void setLookingForLevel(boolean isLookingForLevel) {
            this._lookingForLevel = isLookingForLevel;
        }

        public boolean isDataDivision() {
            return this._inDataDivision;
        }

        public void setDataDivision(boolean dataDivision) {
            this._inDataDivision = dataDivision;
        }

        public boolean isAlphanumStarted() {
            return this._alphanumStarted;
        }

        public void setAlphanumStarted(boolean alphanumStarted) {
            this._alphanumStarted = alphanumStarted;
        }

        public char getAlphanumDelimiter() {
            return this._alphanumDelimiter;
        }

        public void setAlphanumDelimiter(char alphanumDelimiter) {
            this._alphanumDelimiter = alphanumDelimiter;
        }
    }
}

