/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.cob2xsd;

import com.legstar.cob2xsd.Cob2Xsd;
import com.legstar.cob2xsd.Cob2XsdConfig;
import com.legstar.cob2xsd.XsdGenerationException;
import com.legstar.cob2xsd.antlr.RecognizerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.legstar.apache.commons.io.FileUtils;
import org.legstar.apache.commons.io.FilenameUtils;
import org.legstar.slf4j.Logger;
import org.legstar.slf4j.LoggerFactory;

public class Cob2XsdIO
extends Cob2Xsd {
    private static final Logger _log = LoggerFactory.getLogger(Cob2XsdIO.class);

    public Cob2XsdIO(Cob2XsdConfig config) {
        super(config);
    }

    public File translate(File cobolFile, String cobolFileEncoding, File target, String targetNamespacePrefix, String xsltFileName) throws RecognizerException, XsdGenerationException {
        try {
            if (_log.isDebugEnabled()) {
                _log.debug("Translating COBOL file: " + cobolFile);
            }
            this.checkCobolSourceFile(cobolFile);
            this.checkTarget(target);
            String baseName = FilenameUtils.getBaseName(cobolFile.getAbsolutePath()).toLowerCase();
            InputStreamReader cobolReader = cobolFileEncoding == null ? new InputStreamReader(new FileInputStream(cobolFile)) : new InputStreamReader((InputStream)new FileInputStream(cobolFile), cobolFileEncoding);
            String xsdString = this.translate(cobolReader, this.getUniqueTargetNamespace(targetNamespacePrefix, baseName), xsltFileName);
            File xsdFile = null;
            if (target.isDirectory()) {
                String xsdFileName = cobolFile.getName() + ".xsd";
                xsdFile = new File(target, xsdFileName);
            } else {
                xsdFile = target;
            }
            FileUtils.writeStringToFile(xsdFile, xsdString, this.getConfig().getXsdEncoding());
            if (_log.isDebugEnabled()) {
                _log.debug("Created XML schema file: " + xsdFile);
            }
            return xsdFile;
        }
        catch (IOException e) {
            throw new XsdGenerationException(e);
        }
    }

    protected void checkCobolSourceFile(File cobolSourceFile) throws IOException {
        if (cobolSourceFile == null) {
            throw new IOException("You must provide a COBOL source file");
        }
        if (!cobolSourceFile.exists()) {
            throw new IOException("COBOL source  file " + cobolSourceFile + " not found");
        }
    }

    protected void checkTarget(File target) throws IOException {
        String extension;
        if (target == null) {
            throw new IOException("You must provide a target directory or file");
        }
        if (!target.exists() && (extension = FilenameUtils.getExtension(target.getName())).length() == 0) {
            throw new IOException("Target folder " + target + " not found");
        }
    }

    protected String getUniqueTargetNamespace(String targetNamespacePrefix, String baseName) throws IOException {
        if (targetNamespacePrefix == null || targetNamespacePrefix.length() == 0) {
            return null;
        }
        if (baseName == null || baseName.length() == 0) {
            throw new IOException("No target basename was provided");
        }
        if (targetNamespacePrefix.charAt(targetNamespacePrefix.length() - 1) == '/') {
            return targetNamespacePrefix + baseName;
        }
        return targetNamespacePrefix + '/' + baseName;
    }
}

