/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.cob2xsd;

import com.legstar.cob2xsd.Cob2XsdConfig;
import com.legstar.cob2xsd.XsdDataItem;
import com.legstar.cobol.model.CobolTypes;
import com.legstar.cobol.utils.ValueUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.legstar.apache.ws.commons.schema.XmlSchema;
import org.legstar.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.legstar.apache.ws.commons.schema.XmlSchemaAppInfo;
import org.legstar.apache.ws.commons.schema.utils.NamespaceMap;
import org.legstar.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.legstar.slf4j.Logger;
import org.legstar.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XsdAnnotationEmitter {
    private static final String ANNOTATIONS_FILE_NAME = "annotations.properties";
    private XmlSchema _xsd;
    private Properties _annotations = new Properties();
    private DocumentBuilder _docBuilder;
    private boolean _initialized = false;
    private Cob2XsdConfig _config;
    private static final Logger _log = LoggerFactory.getLogger(XsdAnnotationEmitter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XsdAnnotationEmitter(XmlSchema xsd, Cob2XsdConfig config) {
        InputStream is = null;
        try {
            this._xsd = xsd;
            this._config = config;
            is = XsdAnnotationEmitter.class.getResourceAsStream(ANNOTATIONS_FILE_NAME);
            if (is == null) {
                _log.error("Was unable to locate file annotations.properties from the classpath");
            } else {
                this._annotations.load(is);
                DocumentBuilderFactory docFac = DocumentBuilderFactory.newInstance();
                docFac.setNamespaceAware(true);
                this._docBuilder = docFac.newDocumentBuilder();
                this.addNamespaceContext();
                this._initialized = true;
            }
        }
        catch (IOException e) {
            _log.error("Unable to load file annotations.properties", e);
        }
        catch (ParserConfigurationException e) {
            _log.error("Unable to get DOM document builder ", e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    _log.error("Unable to close input stream ", e);
                }
            }
        }
    }

    public XmlSchemaAnnotation createLegStarAnnotation(XsdDataItem xsdDataItem) {
        Document doc = this._docBuilder.newDocument();
        Element el = doc.createElementNS(this.getCOXBNamespace(), this.getCOXBElements());
        Element elc = doc.createElementNS(this.getCOXBNamespace(), this.getCOXBElement());
        elc.setAttribute("levelNumber", Integer.toString(xsdDataItem.getLevelNumber()));
        elc.setAttribute("cobolName", xsdDataItem.getCobolName());
        elc.setAttribute("type", xsdDataItem.getCobolType().toString());
        if (xsdDataItem.getCobolType() != CobolTypes.GROUP_ITEM) {
            if (xsdDataItem.getPicture() != null) {
                elc.setAttribute("picture", xsdDataItem.getPicture());
            }
            if (xsdDataItem.getUsage() != null) {
                elc.setAttribute("usage", xsdDataItem.getUsageForCobol());
            }
            if (xsdDataItem.isJustifiedRight()) {
                elc.setAttribute("justifiedRight", "true");
            }
            if (xsdDataItem.getTotalDigits() > 0) {
                elc.setAttribute("signed", xsdDataItem.isSigned() ? "true" : "false");
                elc.setAttribute("totalDigits", Integer.toString(xsdDataItem.getTotalDigits()));
                if (xsdDataItem.getFractionDigits() > 0) {
                    elc.setAttribute("fractionDigits", Integer.toString(xsdDataItem.getFractionDigits()));
                }
                if (xsdDataItem.isSignLeading()) {
                    elc.setAttribute("signLeading", "true");
                }
                if (xsdDataItem.isSignSeparate()) {
                    elc.setAttribute("signSeparate", "true");
                }
            }
        }
        if (xsdDataItem.getCobolMaxOccurs() > 0) {
            elc.setAttribute("maxOccurs", Integer.toString(xsdDataItem.getCobolMaxOccurs()));
            if (xsdDataItem.getDependingOn() == null) {
                elc.setAttribute("minOccurs", Integer.toString(xsdDataItem.getCobolMaxOccurs()));
            } else {
                elc.setAttribute("dependingOn", xsdDataItem.getDependingOn());
                elc.setAttribute("minOccurs", Integer.toString(xsdDataItem.getCobolMinOccurs()));
            }
        }
        if (xsdDataItem.isODOObject()) {
            elc.setAttribute("isODOObject", "true");
        }
        if (xsdDataItem.getRedefines() != null) {
            elc.setAttribute("redefines", xsdDataItem.getRedefines());
        }
        if (xsdDataItem.isRedefined()) {
            elc.setAttribute("isRedefined", "true");
            elc.setAttribute("unmarshalChoiceStrategyClassName", "");
        }
        if (xsdDataItem.getValue() != null && xsdDataItem.getValue().length() > 0) {
            elc.setAttribute("value", ValueUtil.resolveFigurative(xsdDataItem.getValue(), xsdDataItem.getMaxStorageLength(), this.getConfig().quoteIsQuote()));
        }
        if (xsdDataItem.getSrceLine() > 0) {
            elc.setAttribute("srceLine", Integer.toString(xsdDataItem.getSrceLine()));
        }
        el.appendChild(elc);
        XmlSchemaAppInfo appInfo = new XmlSchemaAppInfo();
        appInfo.setMarkup(el.getChildNodes());
        XmlSchemaAnnotation annotation = new XmlSchemaAnnotation();
        annotation.getItems().add(appInfo);
        return annotation;
    }

    protected void addNamespaceContext() {
        NamespaceMap prefixmap = new NamespaceMap();
        NamespacePrefixList npl = this.getXsd().getNamespaceContext();
        if (npl == null) {
            prefixmap.add("", "http://www.w3.org/2001/XMLSchema");
        } else {
            for (int i = 0; i < npl.getDeclaredPrefixes().length; ++i) {
                prefixmap.add(npl.getDeclaredPrefixes()[i], npl.getNamespaceURI(npl.getDeclaredPrefixes()[i]));
            }
        }
        prefixmap.add(this.getCOXBNamespacePrefix(), this.getCOXBNamespace());
        this.getXsd().setNamespaceContext(prefixmap);
    }

    public String getCOXBNamespace() {
        return this._annotations.getProperty("coxb-namespace");
    }

    public String getCOXBNamespacePrefix() {
        return this._annotations.getProperty("coxb-ns-prefix");
    }

    public String getCOXBElements() {
        return this.getCOXBNamespacePrefix() + ':' + this._annotations.getProperty("coxb-elements");
    }

    public String getCOXBElement() {
        return this.getCOXBNamespacePrefix() + ':' + this._annotations.getProperty("coxb-element");
    }

    public boolean initialized() {
        return this._initialized;
    }

    public XmlSchema getXsd() {
        return this._xsd;
    }

    public Cob2XsdConfig getConfig() {
        return this._config;
    }
}

