/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.cob2xsd;

import com.legstar.cob2xsd.Cob2XsdConfig;
import com.legstar.cob2xsd.Cob2XsdIO;
import com.legstar.cob2xsd.XsdGenerationException;
import com.legstar.cob2xsd.antlr.RecognizerException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.legstar.apache.commons.cli.CommandLine;
import org.legstar.apache.commons.cli.DefaultParser;
import org.legstar.apache.commons.cli.HelpFormatter;
import org.legstar.apache.commons.cli.Option;
import org.legstar.apache.commons.cli.Options;
import org.legstar.apache.commons.io.FileUtils;
import org.legstar.apache.commons.io.FilenameUtils;
import org.legstar.slf4j.Logger;
import org.legstar.slf4j.LoggerFactory;

public class Cob2XsdMain {
    private static final String VERSION_FILE_NAME = "/com/legstar/cob2xsd/version.properties";
    private static final String DEFAULT_INPUT_FOLDER = "cobol";
    private static final String DEFAULT_OUTPUT_FOLDER = "schema";
    private File _configFile;
    private File _input;
    private String _inputEncoding;
    private File _output;
    private String _targetNamespacePrefix;
    private String _xsltFileName;
    private Cob2XsdConfig _config;
    public static final String LS = System.getProperty("line.separator");
    private static final Logger _log = LoggerFactory.getLogger(Cob2XsdIO.class);

    public static void main(String[] args) {
        Cob2XsdMain main = new Cob2XsdMain();
        main.execute(args);
    }

    public void execute(String[] args) {
        try {
            Options options = this.createOptions();
            if (this.collectOptions(options, args)) {
                this.setDefaults();
                this.loadConfig();
                this.execute(this.getInput(), this.getInputEncoding(), this.getOutput(), this.getTargetNamespacePrefix(), this.getXsltFileName());
            }
        }
        catch (Exception e) {
            _log.error("COBOL to Xsd translation failure", e);
            throw new RuntimeException(e);
        }
    }

    protected boolean collectOptions(Options options, String[] args) throws Exception {
        if (args != null && args.length > 0) {
            DefaultParser parser = new DefaultParser();
            CommandLine line = parser.parse(options, args);
            return this.processLine(line, options);
        }
        return true;
    }

    protected void setDefaults() {
        if (this.getInput() == null) {
            this.setInput(DEFAULT_INPUT_FOLDER);
        }
        if (this.getOutput() == null) {
            this.setOutput(DEFAULT_OUTPUT_FOLDER);
        }
    }

    protected void loadConfig() throws IOException {
        this._config = new Cob2XsdConfig(this.getConfigFile());
    }

    protected void produceHelp(Options options) throws Exception {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Options available:", options);
    }

    protected Options createOptions() {
        Options options = new Options();
        Option version = new Option("v", "version", false, "print the version information and exit");
        options.addOption(version);
        Option help = new Option("h", "help", false, "print the options available");
        options.addOption(help);
        Option configFile = new Option("c", "config", true, "path to configuration file");
        options.addOption(configFile);
        Option input = new Option("i", "input", true, "file or folder holding the COBOL code to translate. Name is relative or absolute");
        options.addOption(input);
        Option inputEncoding = new Option("enc", "inputEncoding", true, "character set used for COBOL files encoding");
        options.addOption(inputEncoding);
        Option output = new Option("o", "output", true, "folder or file receiving the translated XML schema");
        options.addOption(output);
        Option targetNamespacePrefix = new Option("n", "targetNamespacePrefix", true, "target namespace prefix for translated XML schema");
        options.addOption(targetNamespacePrefix);
        Option xsltFileName = new Option("x", "xsltFileName", true, "an xslt to apply on the XML Schema before it is returned");
        options.addOption(xsltFileName);
        return options;
    }

    protected boolean processLine(CommandLine line, Options options) throws Exception {
        if (line.hasOption("version")) {
            System.out.println("version " + this.getVersion());
            return false;
        }
        if (line.hasOption("help")) {
            this.produceHelp(options);
            return false;
        }
        if (line.hasOption("config")) {
            this.setConfigFile(line.getOptionValue("config").trim());
        }
        if (line.hasOption("input")) {
            this.setInput(line.getOptionValue("input").trim());
        }
        if (line.hasOption("inputEncoding")) {
            this.setInputEncoding(line.getOptionValue("inputEncoding").trim());
        }
        if (line.hasOption("output")) {
            this.setOutput(line.getOptionValue("output").trim());
        }
        if (line.hasOption("targetNamespacePrefix")) {
            this.setTargetNamespacePrefix(line.getOptionValue("targetNamespacePrefix").trim());
        }
        if (line.hasOption("xsltFileName")) {
            this.setXsltFileName(line.getOptionValue("xsltFileName").trim());
        }
        return true;
    }

    protected void execute(File input, String cobolFileEncoding, File target, String targetNamespacePrefix, String xsltFileName) throws XsdGenerationException {
        try {
            _log.info("Started translation from COBOL to XML Schema");
            _log.info("Taking COBOL from           : " + input);
            _log.info("COBOL encoding              : " + cobolFileEncoding == null ? "default" : cobolFileEncoding);
            _log.info("Output XML Schema to        : " + target);
            _log.info("XML Schema namespace prefix : " + targetNamespacePrefix);
            _log.info("XSLT transform to apply     : " + xsltFileName);
            _log.info("Options in effect           : " + this.getConfig().toString());
            if (input.isFile()) {
                if (FilenameUtils.getExtension(target.getPath()).length() == 0) {
                    FileUtils.forceMkdir(target);
                }
                this.translate(input, cobolFileEncoding, target, targetNamespacePrefix, xsltFileName);
            } else {
                FileUtils.forceMkdir(target);
                for (File cobolFile : input.listFiles()) {
                    if (!cobolFile.isFile()) continue;
                    this.translate(cobolFile, cobolFileEncoding, target, targetNamespacePrefix, xsltFileName);
                }
            }
            _log.info("Finished translation");
        }
        catch (IOException e) {
            throw new XsdGenerationException(e);
        }
    }

    protected void translate(File cobolFile, String cobolFileEncoding, File target, String targetNamespacePrefix, String xsltFileName) throws XsdGenerationException {
        try {
            Cob2XsdIO cob2XsdIO = new Cob2XsdIO(this.getConfig());
            cob2XsdIO.translate(cobolFile, cobolFileEncoding, target, targetNamespacePrefix, xsltFileName);
        }
        catch (RecognizerException e) {
            throw new XsdGenerationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getVersion() throws IOException {
        try (InputStream stream = null;){
            Properties version = new Properties();
            stream = Cob2XsdMain.class.getResourceAsStream(VERSION_FILE_NAME);
            version.load(stream);
            String string = version.getProperty("version");
            return string;
        }
    }

    public File getConfigFile() {
        return this._configFile;
    }

    public void setConfigFile(String config) {
        if (config == null) {
            throw new IllegalArgumentException("Configuration file parameter is null");
        }
        File file = new File(config);
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IllegalArgumentException("Folder " + config + " is not a configuration file");
            }
        } else {
            throw new IllegalArgumentException("Configuration file " + config + " not found");
        }
        this.setConfigFile(file);
    }

    public void setConfigFile(File configFile) {
        this._configFile = configFile;
    }

    public void setInput(String input) {
        if (input == null) {
            throw new IllegalArgumentException("You must provide a COBOL source folder or file");
        }
        File file = new File(input);
        if (file.exists()) {
            if (file.isDirectory() && file.list().length == 0) {
                throw new IllegalArgumentException("Folder " + input + " is empty");
            }
        } else {
            throw new IllegalArgumentException("Input file or folder " + input + " not found");
        }
        this._input = file;
    }

    public String getInputEncoding() {
        return this._inputEncoding;
    }

    public void setInputEncoding(String inputEncoding) {
        this._inputEncoding = inputEncoding;
    }

    public void setOutput(String output) {
        if (output == null) {
            throw new IllegalArgumentException("You must provide a target directory or file");
        }
        this._output = new File(output);
    }

    public void setTargetNamespacePrefix(String targetNamespacePrefix) {
        this._targetNamespacePrefix = targetNamespacePrefix;
    }

    public void setXsltFileName(String xsltFileName) {
        this._xsltFileName = xsltFileName;
    }

    public Cob2XsdConfig getConfig() {
        return this._config;
    }

    public File getInput() {
        return this._input;
    }

    public File getOutput() {
        return this._output;
    }

    public String getTargetNamespacePrefix() {
        return this._targetNamespacePrefix;
    }

    public String getXsltFileName() {
        return this._xsltFileName;
    }
}

