/*
 * Decompiled with CFR 0.152.
 */
package org.legstar.stringtemplate.v4.gui;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.legstar.antlr.runtime.tree.CommonTree;
import org.legstar.stringtemplate.v4.InstanceScope;
import org.legstar.stringtemplate.v4.Interpreter;
import org.legstar.stringtemplate.v4.ST;
import org.legstar.stringtemplate.v4.StringRenderer;
import org.legstar.stringtemplate.v4.debug.AddAttributeEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTreeScopeStackModel
implements TreeModel {
    CommonTree root = new StringTree("Scope stack:");

    public JTreeScopeStackModel(InstanceScope scope) {
        HashSet<String> names = new HashSet<String>();
        List<InstanceScope> stack = Interpreter.getScopeStack(scope, false);
        for (InstanceScope s : stack) {
            StringTree templateNode = new StringTree(s.st.getName());
            this.root.insertChild(0, templateNode);
            this.addAttributeDescriptions(s.st, templateNode, names);
        }
    }

    public void addAttributeDescriptions(ST st, StringTree node, Set<String> names) {
        Map<String, Object> attrs = st.getAttributes();
        if (attrs == null) {
            return;
        }
        for (String a : attrs.keySet()) {
            String descr = null;
            if (st.debugState != null && st.debugState.addAttrEvents != null) {
                List events = (List)st.debugState.addAttrEvents.get(a);
                StringBuilder locations = new StringBuilder();
                int i = 0;
                if (events != null) {
                    for (AddAttributeEvent ae : events) {
                        if (i > 0) {
                            locations.append(", ");
                        }
                        locations.append(ae.getFileName() + ":" + ae.getLine());
                        ++i;
                    }
                }
                descr = locations.length() > 0 ? a + " = " + attrs.get(a) + " @ " + locations.toString() : a + " = " + attrs.get(a);
            } else {
                descr = a + " = " + attrs.get(a);
            }
            if (!names.add(a)) {
                StringBuilder builder = new StringBuilder();
                builder.append("<html><font color=\"gray\">");
                builder.append(StringRenderer.escapeHTML(descr));
                builder.append("</font></html>");
                descr = builder.toString();
            }
            node.addChild(new StringTree(descr));
        }
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int i) {
        StringTree t = (StringTree)parent;
        return t.getChild(i);
    }

    @Override
    public int getChildCount(Object parent) {
        StringTree t = (StringTree)parent;
        return t.getChildCount();
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        StringTree c = (StringTree)child;
        return c.getChildIndex();
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object o) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
    }

    public static class StringTree
    extends CommonTree {
        String text;

        public StringTree(String text) {
            this.text = text;
        }

        public boolean isNil() {
            return this.text == null;
        }

        public String toString() {
            if (!this.isNil()) {
                return this.text.toString();
            }
            return "nil";
        }
    }
}

