/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.cob2xsd.antlr;

import com.legstar.cob2xsd.antlr.AbstractCobolSourceCleaner;
import com.legstar.cob2xsd.antlr.RecognizerErrorHandler;

public class CobolFixedFormatSourceCleaner
extends AbstractCobolSourceCleaner {
    private final int _startColumn;
    private final int _endColumn;

    public CobolFixedFormatSourceCleaner(RecognizerErrorHandler errorHandler, int startColumn, int endColumn) {
        super(errorHandler);
        this._startColumn = startColumn;
        this._endColumn = endColumn;
    }

    @Override
    public String extendedCleanLine(String line) {
        return this.cleanFixedLine(line);
    }

    @Override
    public int getIndicatorAreaPos() {
        return this._startColumn - 1;
    }

    public String cleanFixedLine(String line) {
        StringBuilder cleanedLine = new StringBuilder();
        int length = line.length();
        for (int i = 0; i < this._startColumn - 1; ++i) {
            cleanedLine.append(" ");
        }
        if (length > this._startColumn - 1) {
            String areaA = line.substring(this._startColumn - 1, length > this._endColumn ? this._endColumn : length);
            cleanedLine.append(areaA);
        }
        return cleanedLine.toString();
    }

    @Override
    public boolean isComment(String line) {
        char indicatorArea = line.charAt(this.getIndicatorAreaPos());
        return indicatorArea == '*' || indicatorArea == '/' || indicatorArea == '$';
    }
}

