/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.cob2xsd;

import com.legstar.cob2xsd.Cob2XsdConfig;
import com.legstar.cob2xsd.XsdAnnotationEmitter;
import com.legstar.cob2xsd.XsdDataItem;
import com.legstar.cobol.model.CobolDataItem;
import com.legstar.cobol.model.CobolTypes;
import com.legstar.cobol.utils.ValueUtil;
import javax.xml.namespace.QName;
import org.legstar.apache.ws.commons.schema.XmlSchema;
import org.legstar.apache.ws.commons.schema.XmlSchemaChoice;
import org.legstar.apache.ws.commons.schema.XmlSchemaComplexType;
import org.legstar.apache.ws.commons.schema.XmlSchemaElement;
import org.legstar.apache.ws.commons.schema.XmlSchemaEnumerationFacet;
import org.legstar.apache.ws.commons.schema.XmlSchemaFractionDigitsFacet;
import org.legstar.apache.ws.commons.schema.XmlSchemaMaxInclusiveFacet;
import org.legstar.apache.ws.commons.schema.XmlSchemaMaxLengthFacet;
import org.legstar.apache.ws.commons.schema.XmlSchemaMinInclusiveFacet;
import org.legstar.apache.ws.commons.schema.XmlSchemaPatternFacet;
import org.legstar.apache.ws.commons.schema.XmlSchemaSequence;
import org.legstar.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.legstar.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.legstar.apache.ws.commons.schema.XmlSchemaTotalDigitsFacet;
import org.legstar.apache.ws.commons.schema.XmlSchemaType;
import org.legstar.slf4j.Logger;
import org.legstar.slf4j.LoggerFactory;

public class XsdEmitter {
    private XmlSchema _xsd;
    private Cob2XsdConfig _config;
    private XsdAnnotationEmitter _annotationEmitter;
    private static final Logger _log = LoggerFactory.getLogger(XsdEmitter.class);

    public XsdEmitter(XmlSchema xsd, Cob2XsdConfig model) {
        this._xsd = xsd;
        this._config = model;
        if (this._config.addLegStarAnnotations()) {
            this._annotationEmitter = new XsdAnnotationEmitter(xsd, model);
        }
    }

    public XmlSchemaType createXmlSchemaType(XsdDataItem xsdDataItem) {
        if (xsdDataItem.getXsdType() == null) {
            return null;
        }
        switch (xsdDataItem.getXsdType()) {
            case COMPLEX: {
                return this.createXmlSchemaComplexType(xsdDataItem);
            }
            case STRING: {
                return this.createAlphaXmlSchemaSimpleType(xsdDataItem, "string");
            }
            case HEXBINARY: {
                return this.createAlphaXmlSchemaSimpleType(xsdDataItem, "hexBinary");
            }
            case SHORT: {
                return this.createNumericXmlSchemaSimpleType(xsdDataItem, "short");
            }
            case USHORT: {
                return this.createNumericXmlSchemaSimpleType(xsdDataItem, "unsignedShort");
            }
            case INT: {
                return this.createNumericXmlSchemaSimpleType(xsdDataItem, "int");
            }
            case UINT: {
                return this.createNumericXmlSchemaSimpleType(xsdDataItem, "unsignedInt");
            }
            case LONG: {
                return this.createNumericXmlSchemaSimpleType(xsdDataItem, "long");
            }
            case ULONG: {
                return this.createNumericXmlSchemaSimpleType(xsdDataItem, "unsignedLong");
            }
            case INTEGER: {
                return this.createNumericXmlSchemaSimpleType(xsdDataItem, "integer");
            }
            case DECIMAL: {
                return this.createNumericXmlSchemaSimpleType(xsdDataItem, "decimal");
            }
            case FLOAT: {
                return this.createNumericXmlSchemaSimpleType(xsdDataItem, "float");
            }
            case DOUBLE: {
                return this.createNumericXmlSchemaSimpleType(xsdDataItem, "double");
            }
        }
        return null;
    }

    public XmlSchemaComplexType createXmlSchemaComplexType(XsdDataItem xsdDataItem) {
        XmlSchemaComplexType xmlSchemaComplexType = new XmlSchemaComplexType(this.getXsd(), true);
        XmlSchemaChoice xmlSchemaChoice = null;
        XmlSchemaSequence xmlSchemaSequence = new XmlSchemaSequence();
        for (XsdDataItem child : xsdDataItem.getChildren()) {
            XmlSchemaElement xmlSchemaElement = this.createXmlSchemaElement(child);
            if (xmlSchemaElement == null) continue;
            if (child.isRedefined()) {
                xmlSchemaChoice = new XmlSchemaChoice();
                xmlSchemaSequence.getItems().add(xmlSchemaChoice);
                xmlSchemaChoice.getItems().add(xmlSchemaElement);
                continue;
            }
            if (child.getRedefines() != null) {
                if (xmlSchemaChoice == null) {
                    _log.warn("Item " + child.getCobolName() + " REDEFINES " + child.getRedefines() + " but redefined item is not a sibling");
                    xmlSchemaSequence.getItems().add(xmlSchemaElement);
                    continue;
                }
                xmlSchemaChoice.getItems().add(xmlSchemaElement);
                continue;
            }
            xmlSchemaSequence.getItems().add(xmlSchemaElement);
        }
        xmlSchemaComplexType.setParticle(xmlSchemaSequence);
        xmlSchemaComplexType.setName(xsdDataItem.getXsdTypeName());
        return xmlSchemaComplexType;
    }

    public XmlSchemaElement createXmlSchemaElement(XsdDataItem xsdDataItem) {
        XmlSchemaType xmlSchemaType;
        XmlSchemaElement element = new XmlSchemaElement(this.getXsd(), false);
        element.setName(xsdDataItem.getXsdElementName());
        if (xsdDataItem.getMaxOccurs() != 1) {
            element.setMaxOccurs(xsdDataItem.getMaxOccurs());
        }
        if (xsdDataItem.getMinOccurs() != 1) {
            element.setMinOccurs(xsdDataItem.getMinOccurs());
        }
        if ((xmlSchemaType = this.createXmlSchemaType(xsdDataItem)) == null) {
            return null;
        }
        if (xmlSchemaType instanceof XmlSchemaSimpleType) {
            element.setSchemaType(xmlSchemaType);
        } else {
            element.setSchemaTypeName(xmlSchemaType.getQName());
        }
        if (this.getConfig().addLegStarAnnotations()) {
            element.setAnnotation(this._annotationEmitter.createLegStarAnnotation(xsdDataItem));
        }
        return element;
    }

    protected XmlSchemaSimpleType createAlphaXmlSchemaSimpleType(XsdDataItem xsdDataItem, String xsdTypeName) {
        XmlSchemaSimpleTypeRestriction restriction = this.createRestriction(xsdTypeName);
        if (xsdDataItem.getLength() > -1) {
            restriction.getFacets().add(this.createMaxLengthFacet(xsdDataItem.getLength()));
        }
        if (xsdDataItem.getPattern() != null) {
            restriction.getFacets().add(this.createPatternFacet(xsdDataItem.getPattern()));
        }
        this.addEnumerationFacets(xsdDataItem, restriction);
        return this.createXmlSchemaSimpleType(restriction);
    }

    protected XmlSchemaSimpleType createNumericXmlSchemaSimpleType(XsdDataItem xsdDataItem, String xsdTypeName) {
        XmlSchemaSimpleTypeRestriction restriction = this.createRestriction(xsdTypeName);
        if (xsdDataItem.getCobolType() != CobolTypes.NATIVE_BINARY_ITEM && xsdDataItem.getTotalDigits() > -1) {
            if (xsdDataItem.getXsdType() == XsdDataItem.XsdType.ULONG) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < xsdDataItem.getTotalDigits(); ++i) {
                    sb.append("9");
                }
                restriction.getFacets().add(this.createMaxInclusiveFacet(sb.toString()));
            } else {
                restriction.getFacets().add(this.createTotalDigitsFacet(xsdDataItem.getTotalDigits()));
            }
        }
        if (xsdDataItem.getFractionDigits() > 0) {
            restriction.getFacets().add(this.createFractionDigitsFacet(xsdDataItem.getFractionDigits()));
        }
        if (!(xsdDataItem.getXsdType() != XsdDataItem.XsdType.INTEGER && xsdDataItem.getXsdType() != XsdDataItem.XsdType.DECIMAL || xsdDataItem.isSigned())) {
            restriction.getFacets().add(this.createMinInclusiveFacet("0"));
        }
        this.addEnumerationFacets(xsdDataItem, restriction);
        return this.createXmlSchemaSimpleType(restriction);
    }

    protected void addEnumerationFacets(XsdDataItem xsdDataItem, XmlSchemaSimpleTypeRestriction restriction) {
        if (this.getConfig().mapConditionsToFacets()) {
            boolean hasValueThru = false;
            block0: for (XsdDataItem child : xsdDataItem.getChildren()) {
                if (child.getDataEntryType() != CobolDataItem.DataEntryType.CONDITION) continue;
                for (String conditionValue : child.getConditionLiterals()) {
                    restriction.getFacets().add(this.createEnumerationFacet(ValueUtil.resolveFigurative(conditionValue, xsdDataItem.getMaxStorageLength(), this.getConfig().quoteIsQuote())));
                }
                for (CobolDataItem.Range conditionRange : child.getConditionRanges()) {
                    if (hasValueThru) {
                        _log.warn(xsdDataItem.getCobolName() + " has several VALUE THRU statements. Cannot translate to XSD. Only the first one will be converted. Ignoring: " + conditionRange.toString());
                        continue block0;
                    }
                    restriction.getFacets().add(this.createMinInclusiveFacet(ValueUtil.resolveFigurative(conditionRange.getFrom(), xsdDataItem.getMaxStorageLength(), this.getConfig().quoteIsQuote())));
                    restriction.getFacets().add(this.createMaxInclusiveFacet(ValueUtil.resolveFigurative(conditionRange.getTo(), xsdDataItem.getMaxStorageLength(), this.getConfig().quoteIsQuote())));
                    hasValueThru = true;
                }
            }
        }
    }

    protected XmlSchemaSimpleType createXmlSchemaSimpleType(XmlSchemaSimpleTypeRestriction restriction) {
        XmlSchemaSimpleType xmlSchemaSimpleType = new XmlSchemaSimpleType(this.getXsd(), false);
        xmlSchemaSimpleType.setContent(restriction);
        return xmlSchemaSimpleType;
    }

    protected XmlSchemaSimpleTypeRestriction createRestriction(String xsdTypeName) {
        XmlSchemaSimpleTypeRestriction restriction = new XmlSchemaSimpleTypeRestriction();
        restriction.setBaseTypeName(new QName("http://www.w3.org/2001/XMLSchema", xsdTypeName));
        return restriction;
    }

    protected XmlSchemaMaxLengthFacet createMaxLengthFacet(int length) {
        XmlSchemaMaxLengthFacet xmlSchemaMaxLengthFacet = new XmlSchemaMaxLengthFacet();
        xmlSchemaMaxLengthFacet.setValue(length);
        return xmlSchemaMaxLengthFacet;
    }

    protected XmlSchemaPatternFacet createPatternFacet(String pattern) {
        XmlSchemaPatternFacet xmlSchemaPatternFacet = new XmlSchemaPatternFacet();
        xmlSchemaPatternFacet.setValue(pattern);
        return xmlSchemaPatternFacet;
    }

    protected XmlSchemaEnumerationFacet createEnumerationFacet(String conditionValue) {
        XmlSchemaEnumerationFacet xmlSchemaEnumerationFacet = new XmlSchemaEnumerationFacet();
        xmlSchemaEnumerationFacet.setValue(conditionValue);
        return xmlSchemaEnumerationFacet;
    }

    protected XmlSchemaTotalDigitsFacet createTotalDigitsFacet(int totalDigits) {
        XmlSchemaTotalDigitsFacet xmlSchemaTotalDigitsFacet = new XmlSchemaTotalDigitsFacet();
        xmlSchemaTotalDigitsFacet.setValue(totalDigits);
        return xmlSchemaTotalDigitsFacet;
    }

    protected XmlSchemaFractionDigitsFacet createFractionDigitsFacet(int fractionDigits) {
        XmlSchemaFractionDigitsFacet xmlSchemaFractionDigitsFacet = new XmlSchemaFractionDigitsFacet();
        xmlSchemaFractionDigitsFacet.setValue(fractionDigits);
        return xmlSchemaFractionDigitsFacet;
    }

    protected XmlSchemaMinInclusiveFacet createMinInclusiveFacet(String minInclusive) {
        XmlSchemaMinInclusiveFacet xmlSchemaMinInclusiveFacet = new XmlSchemaMinInclusiveFacet();
        xmlSchemaMinInclusiveFacet.setValue(minInclusive);
        return xmlSchemaMinInclusiveFacet;
    }

    protected XmlSchemaMaxInclusiveFacet createMaxInclusiveFacet(String maxInclusive) {
        XmlSchemaMaxInclusiveFacet xmlSchemaMaxInclusiveFacet = new XmlSchemaMaxInclusiveFacet();
        xmlSchemaMaxInclusiveFacet.setValue(maxInclusive);
        return xmlSchemaMaxInclusiveFacet;
    }

    public XmlSchema getXsd() {
        return this._xsd;
    }

    public Cob2XsdConfig getConfig() {
        return this._config;
    }
}

