/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.migrations;

import com.launchdarkly.sdk.server.migrations.MigrationExecutionMode;
import com.launchdarkly.sdk.server.migrations.MigrationSerialOrder;
import com.launchdarkly.shaded.org.jetbrains.annotations.NotNull;
import com.launchdarkly.shaded.org.jetbrains.annotations.Nullable;
import java.util.Optional;

public class MigrationExecution {
    private final MigrationExecutionMode mode;
    private final MigrationSerialOrder order;

    private MigrationExecution(@NotNull MigrationExecutionMode mode, @Nullable MigrationSerialOrder order) {
        this.mode = mode;
        this.order = order;
    }

    public static MigrationExecution Serial(@NotNull MigrationSerialOrder order) {
        return new MigrationExecution(MigrationExecutionMode.SERIAL, order);
    }

    public static MigrationExecution Parallel() {
        return new MigrationExecution(MigrationExecutionMode.PARALLEL, null);
    }

    public MigrationExecutionMode getMode() {
        return this.mode;
    }

    public Optional<MigrationSerialOrder> getOrder() {
        return Optional.ofNullable(this.order);
    }

    public String toString() {
        String strValue = "";
        strValue = strValue + this.mode.toString();
        if (this.order != null) {
            strValue = strValue + "-";
            strValue = strValue + this.order.toString();
        }
        return strValue;
    }
}

