/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.server.SimpleLRUCache;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.EventContextDeduplicator;
import java.time.Duration;

final class ServerSideEventContextDeduplicator
implements EventContextDeduplicator {
    private final SimpleLRUCache<String, String> contextKeys;
    private final Duration flushInterval;

    public ServerSideEventContextDeduplicator(int capacity, Duration flushInterval) {
        this.contextKeys = new SimpleLRUCache(capacity);
        this.flushInterval = flushInterval;
    }

    @Override
    public Long getFlushInterval() {
        return this.flushInterval.toMillis();
    }

    @Override
    public boolean processContext(LDContext context) {
        String key = context.getFullyQualifiedKey();
        if (key == null || key.isEmpty()) {
            return false;
        }
        String previousValue = this.contextKeys.put(key, key);
        return previousValue == null;
    }

    @Override
    public void flush() {
        this.contextKeys.clear();
    }
}

