/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogAdapter;
import com.launchdarkly.logging.LDLogLevel;
import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.LDSLF4J;
import com.launchdarkly.logging.Logs;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.ClientContextImpl;
import com.launchdarkly.sdk.server.DefaultEventProcessorWrapper;
import com.launchdarkly.sdk.server.DefaultFeatureRequestor;
import com.launchdarkly.sdk.server.InMemoryDataStore;
import com.launchdarkly.sdk.server.Loggers;
import com.launchdarkly.sdk.server.NoOpEventProcessor;
import com.launchdarkly.sdk.server.PersistentDataStoreWrapper;
import com.launchdarkly.sdk.server.PollingProcessor;
import com.launchdarkly.sdk.server.ServerSideEventContextDeduplicator;
import com.launchdarkly.sdk.server.StandardEndpoints;
import com.launchdarkly.sdk.server.StreamProcessor;
import com.launchdarkly.sdk.server.Util;
import com.launchdarkly.sdk.server.integrations.EventProcessorBuilder;
import com.launchdarkly.sdk.server.integrations.HooksConfigurationBuilder;
import com.launchdarkly.sdk.server.integrations.HttpConfigurationBuilder;
import com.launchdarkly.sdk.server.integrations.LoggingConfigurationBuilder;
import com.launchdarkly.sdk.server.integrations.PersistentDataStoreBuilder;
import com.launchdarkly.sdk.server.integrations.PollingDataSourceBuilder;
import com.launchdarkly.sdk.server.integrations.ServiceEndpointsBuilder;
import com.launchdarkly.sdk.server.integrations.StreamingDataSourceBuilder;
import com.launchdarkly.sdk.server.integrations.WrapperInfoBuilder;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.HttpAuthentication;
import com.launchdarkly.sdk.server.interfaces.ServiceEndpoints;
import com.launchdarkly.sdk.server.interfaces.WrapperInfo;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.DataSource;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.DiagnosticDescription;
import com.launchdarkly.sdk.server.subsystems.EventProcessor;
import com.launchdarkly.sdk.server.subsystems.EventSender;
import com.launchdarkly.sdk.server.subsystems.HookConfiguration;
import com.launchdarkly.sdk.server.subsystems.HttpConfiguration;
import com.launchdarkly.sdk.server.subsystems.LoggingConfiguration;
import com.launchdarkly.sdk.server.subsystems.PersistentDataStore;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableMap;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.DefaultEventSender;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.DiagnosticConfigProperty;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.EventSender;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.EventsConfiguration;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.http.HttpProperties;
import com.launchdarkly.shaded.okhttp3.Authenticator;
import com.launchdarkly.shaded.okhttp3.Credentials;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;

abstract class ComponentsImpl {
    static final EventProcessor NOOP_EVENT_PROCESSOR = new NoOpEventProcessor();
    static final ComponentConfigurer<EventProcessor> NOOP_EVENT_PROCESSOR_FACTORY = context -> NOOP_EVENT_PROCESSOR;

    private ComponentsImpl() {
    }

    static HttpProperties toHttpProperties(HttpConfiguration httpConfig) {
        Authenticator proxyAuth = null;
        if (httpConfig.getProxyAuthentication() != null) {
            proxyAuth = Util.okhttpAuthenticatorFromHttpAuthStrategy(httpConfig.getProxyAuthentication());
        }
        return new HttpProperties(httpConfig.getConnectTimeout().toMillis(), ImmutableMap.copyOf(httpConfig.getDefaultHeaders()), null, httpConfig.getProxy(), proxyAuth, httpConfig.getSocketFactory(), httpConfig.getSocketTimeout().toMillis(), httpConfig.getSslSocketFactory(), httpConfig.getTrustManager());
    }

    static final class WrapperInfoBuilderImpl
    extends WrapperInfoBuilder {
        public WrapperInfoBuilderImpl() {
            this(null, null);
        }

        public WrapperInfoBuilderImpl(String wrapperName, String wrapperVersion) {
            this.wrapperName = wrapperName;
            this.wrapperVersion = wrapperVersion;
        }

        @Override
        public WrapperInfo build() {
            return new WrapperInfo(this.wrapperName, this.wrapperVersion);
        }

        public static WrapperInfoBuilderImpl fromInfo(WrapperInfo info) {
            return new WrapperInfoBuilderImpl(info.getWrapperName(), info.getWrapperVersion());
        }
    }

    static final class HooksConfigurationBuilderImpl
    extends HooksConfigurationBuilder {
        HooksConfigurationBuilderImpl() {
        }

        public static HooksConfigurationBuilderImpl fromHooksConfiguration(HookConfiguration hooksConfiguration) {
            HooksConfigurationBuilderImpl builder = new HooksConfigurationBuilderImpl();
            builder.setHooks(hooksConfiguration.getHooks());
            return builder;
        }

        @Override
        public HookConfiguration build() {
            return new HookConfiguration(this.hooks);
        }
    }

    static final class ServiceEndpointsBuilderImpl
    extends ServiceEndpointsBuilder {
        ServiceEndpointsBuilderImpl() {
        }

        @Override
        public ServiceEndpoints createServiceEndpoints() {
            if (this.streamingBaseUri == null && this.pollingBaseUri == null && this.eventsBaseUri == null) {
                return new ServiceEndpoints(StandardEndpoints.DEFAULT_STREAMING_BASE_URI, StandardEndpoints.DEFAULT_POLLING_BASE_URI, StandardEndpoints.DEFAULT_EVENTS_BASE_URI);
            }
            return new ServiceEndpoints(this.streamingBaseUri, this.pollingBaseUri, this.eventsBaseUri);
        }

        public static ServiceEndpointsBuilderImpl fromServiceEndpoints(ServiceEndpoints endpoints) {
            ServiceEndpointsBuilderImpl newBuilder = new ServiceEndpointsBuilderImpl();
            newBuilder.eventsBaseUri = endpoints.getEventsBaseUri();
            newBuilder.pollingBaseUri = endpoints.getPollingBaseUri();
            newBuilder.streamingBaseUri = endpoints.getStreamingBaseUri();
            return newBuilder;
        }
    }

    static final class LoggingConfigurationBuilderImpl
    extends LoggingConfigurationBuilder {
        LoggingConfigurationBuilderImpl() {
        }

        @Override
        public LoggingConfiguration build(ClientContext clientContext) {
            LDLogAdapter adapter = this.logAdapter == null ? LoggingConfigurationBuilderImpl.getDefaultLogAdapter() : this.logAdapter;
            LDLogAdapter filteredAdapter = Logs.level(adapter, this.minimumLevel == null ? LDLogLevel.INFO : this.minimumLevel);
            String name = this.baseName == null ? Loggers.BASE_LOGGER_NAME : this.baseName;
            return new LoggingConfiguration(name, filteredAdapter, this.logDataSourceOutageAsErrorAfter);
        }

        private static LDLogAdapter getDefaultLogAdapter() {
            try {
                Class.forName("org.slf4j.LoggerFactory");
                return LDSLF4J.adapter();
            }
            catch (ClassNotFoundException e) {
                return Logs.toConsole();
            }
        }
    }

    static final class PersistentDataStoreBuilderImpl
    extends PersistentDataStoreBuilder
    implements DiagnosticDescription {
        public PersistentDataStoreBuilderImpl(ComponentConfigurer<PersistentDataStore> storeConfigurer) {
            super(storeConfigurer);
        }

        @Override
        public LDValue describeConfiguration(ClientContext clientContext) {
            if (this.persistentDataStoreConfigurer instanceof DiagnosticDescription) {
                return ((DiagnosticDescription)((Object)this.persistentDataStoreConfigurer)).describeConfiguration(clientContext);
            }
            return LDValue.of("custom");
        }

        @Override
        public DataStore build(ClientContext context) {
            PersistentDataStore core = (PersistentDataStore)this.persistentDataStoreConfigurer.build(context);
            return new PersistentDataStoreWrapper(core, this.cacheTime, this.staleValuesPolicy, this.recordCacheStats, context.getDataStoreUpdateSink(), ClientContextImpl.get((ClientContext)context).sharedExecutor, context.getBaseLogger().subLogger("DataStore"));
        }
    }

    static final class HttpBasicAuthentication
    implements HttpAuthentication {
        private final String username;
        private final String password;

        HttpBasicAuthentication(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public String provideAuthorization(Iterable<HttpAuthentication.Challenge> challenges) {
            return Credentials.basic(this.username, this.password);
        }
    }

    static final class HttpConfigurationBuilderImpl
    extends HttpConfigurationBuilder {
        HttpConfigurationBuilderImpl() {
        }

        @Override
        public HttpConfiguration build(ClientContext clientContext) {
            String tagHeader;
            LDLogger logger = clientContext.getBaseLogger();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", clientContext.getSdkKey());
            headers.put("User-Agent", "JavaClient/7.9.1");
            if (clientContext.getApplicationInfo() != null && !(tagHeader = Util.applicationTagHeader(clientContext.getApplicationInfo(), logger)).isEmpty()) {
                headers.put("X-LaunchDarkly-Tags", tagHeader);
            }
            String wrapperNameToUse = null;
            String wrapperVersionToUse = null;
            WrapperInfo wrapperInfo = clientContext.getWrapperInfo();
            if (wrapperInfo != null) {
                wrapperNameToUse = wrapperInfo.getWrapperName();
                wrapperVersionToUse = wrapperInfo.getWrapperVersion();
            } else if (this.wrapperName != null) {
                wrapperNameToUse = this.wrapperName;
                wrapperVersionToUse = this.wrapperVersion;
            }
            if (wrapperNameToUse != null) {
                String wrapperId = wrapperVersionToUse == null ? wrapperNameToUse : wrapperNameToUse + "/" + wrapperVersionToUse;
                headers.put("X-LaunchDarkly-Wrapper", wrapperId);
            }
            if (!this.customHeaders.isEmpty()) {
                headers.putAll(this.customHeaders);
            }
            Proxy proxy = this.proxyHost == null ? null : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort));
            return new HttpConfiguration(this.connectTimeout, headers, proxy, this.proxyAuth, this.socketFactory, this.socketTimeout, this.sslSocketFactory, this.trustManager);
        }
    }

    static final class EventProcessorBuilderImpl
    extends EventProcessorBuilder
    implements DiagnosticDescription {
        EventProcessorBuilderImpl() {
        }

        @Override
        public EventProcessor build(ClientContext context) {
            com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.EventSender eventSender = this.eventSenderConfigurer == null ? new DefaultEventSender(ComponentsImpl.toHttpProperties(context.getHttp()), null, null, 0L, this.enableGzipCompression, context.getBaseLogger().subLogger("Events")) : new EventSenderWrapper((EventSender)this.eventSenderConfigurer.build(context));
            URI eventsUri = StandardEndpoints.selectBaseUri(context.getServiceEndpoints().getEventsBaseUri(), StandardEndpoints.DEFAULT_EVENTS_BASE_URI, "events", context.getBaseLogger());
            EventsConfiguration eventsConfig = new EventsConfiguration(this.allAttributesPrivate, this.capacity, new ServerSideEventContextDeduplicator(this.userKeysCapacity, this.userKeysFlushInterval), this.diagnosticRecordingInterval.toMillis(), ClientContextImpl.get((ClientContext)context).diagnosticStore, eventSender, 5, eventsUri, this.flushInterval.toMillis(), false, false, this.privateAttributes);
            return new DefaultEventProcessorWrapper(context, eventsConfig);
        }

        @Override
        public LDValue describeConfiguration(ClientContext clientContext) {
            return LDValue.buildObject().put(DiagnosticConfigProperty.ALL_ATTRIBUTES_PRIVATE.name, this.allAttributesPrivate).put(DiagnosticConfigProperty.CUSTOM_EVENTS_URI.name, StandardEndpoints.isCustomBaseUri(clientContext.getServiceEndpoints().getEventsBaseUri(), StandardEndpoints.DEFAULT_EVENTS_BASE_URI)).put(DiagnosticConfigProperty.DIAGNOSTIC_RECORDING_INTERVAL_MILLIS.name, this.diagnosticRecordingInterval.toMillis()).put(DiagnosticConfigProperty.EVENTS_CAPACITY.name, this.capacity).put(DiagnosticConfigProperty.EVENTS_FLUSH_INTERVAL_MILLIS.name, this.flushInterval.toMillis()).put(DiagnosticConfigProperty.SAMPLING_INTERVAL.name, 0).put(DiagnosticConfigProperty.USER_KEYS_CAPACITY.name, this.userKeysCapacity).put(DiagnosticConfigProperty.USER_KEYS_FLUSH_INTERVAL_MILLIS.name, this.userKeysFlushInterval.toMillis()).build();
        }

        static final class EventSenderWrapper
        implements com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.EventSender {
            private final EventSender wrappedSender;

            EventSenderWrapper(EventSender wrappedSender) {
                this.wrappedSender = wrappedSender;
            }

            @Override
            public void close() throws IOException {
                this.wrappedSender.close();
            }

            @Override
            public EventSender.Result sendAnalyticsEvents(byte[] data, int eventCount, URI eventsBaseUri) {
                return this.transformResult(this.wrappedSender.sendAnalyticsEvents(data, eventCount, eventsBaseUri));
            }

            @Override
            public EventSender.Result sendDiagnosticEvent(byte[] data, URI eventsBaseUri) {
                return this.transformResult(this.wrappedSender.sendDiagnosticEvent(data, eventsBaseUri));
            }

            private EventSender.Result transformResult(EventSender.Result result) {
                switch (result) {
                    case FAILURE: {
                        return new EventSender.Result(false, false, null);
                    }
                    case STOP: {
                        return new EventSender.Result(false, true, null);
                    }
                }
                return new EventSender.Result(true, false, null);
            }
        }
    }

    static final class PollingDataSourceBuilderImpl
    extends PollingDataSourceBuilder
    implements DiagnosticDescription {
        PollingDataSourceBuilderImpl() {
        }

        PollingDataSourceBuilderImpl pollIntervalWithNoMinimum(Duration pollInterval) {
            this.pollInterval = pollInterval;
            return this;
        }

        @Override
        public DataSource build(ClientContext context) {
            LDLogger baseLogger = context.getBaseLogger();
            LDLogger logger = baseLogger.subLogger("DataSource");
            logger.info("Disabling streaming API");
            logger.warn("You should only disable the streaming API if instructed to do so by LaunchDarkly support");
            URI pollUri = StandardEndpoints.selectBaseUri(context.getServiceEndpoints().getPollingBaseUri(), StandardEndpoints.DEFAULT_POLLING_BASE_URI, "polling", baseLogger);
            DefaultFeatureRequestor requestor = new DefaultFeatureRequestor(ComponentsImpl.toHttpProperties(context.getHttp()), pollUri, this.payloadFilter, logger);
            return new PollingProcessor(requestor, context.getDataSourceUpdateSink(), ClientContextImpl.get((ClientContext)context).sharedExecutor, this.pollInterval, logger);
        }

        @Override
        public LDValue describeConfiguration(ClientContext clientContext) {
            return LDValue.buildObject().put(DiagnosticConfigProperty.STREAMING_DISABLED.name, true).put(DiagnosticConfigProperty.CUSTOM_BASE_URI.name, StandardEndpoints.isCustomBaseUri(clientContext.getServiceEndpoints().getPollingBaseUri(), StandardEndpoints.DEFAULT_POLLING_BASE_URI)).put(DiagnosticConfigProperty.CUSTOM_STREAM_URI.name, false).put(DiagnosticConfigProperty.POLLING_INTERVAL_MILLIS.name, this.pollInterval.toMillis()).put(DiagnosticConfigProperty.USING_RELAY_DAEMON.name, false).build();
        }
    }

    static final class StreamingDataSourceBuilderImpl
    extends StreamingDataSourceBuilder
    implements DiagnosticDescription {
        StreamingDataSourceBuilderImpl() {
        }

        @Override
        public DataSource build(ClientContext context) {
            LDLogger baseLogger = context.getBaseLogger();
            LDLogger logger = baseLogger.subLogger("DataSource");
            logger.info("Enabling streaming API");
            URI streamUri = StandardEndpoints.selectBaseUri(context.getServiceEndpoints().getStreamingBaseUri(), StandardEndpoints.DEFAULT_STREAMING_BASE_URI, "streaming", baseLogger);
            return new StreamProcessor(ComponentsImpl.toHttpProperties(context.getHttp()), context.getDataSourceUpdateSink(), context.getThreadPriority(), ClientContextImpl.get((ClientContext)context).diagnosticStore, streamUri, this.payloadFilter, this.initialReconnectDelay, logger);
        }

        @Override
        public LDValue describeConfiguration(ClientContext clientContext) {
            return LDValue.buildObject().put(DiagnosticConfigProperty.STREAMING_DISABLED.name, false).put(DiagnosticConfigProperty.CUSTOM_BASE_URI.name, false).put(DiagnosticConfigProperty.CUSTOM_STREAM_URI.name, StandardEndpoints.isCustomBaseUri(clientContext.getServiceEndpoints().getStreamingBaseUri(), StandardEndpoints.DEFAULT_STREAMING_BASE_URI)).put(DiagnosticConfigProperty.RECONNECT_TIME_MILLIS.name, this.initialReconnectDelay.toMillis()).put(DiagnosticConfigProperty.USING_RELAY_DAEMON.name, false).build();
        }
    }

    static final class NullDataSource
    implements DataSource {
        static final DataSource INSTANCE = new NullDataSource();

        NullDataSource() {
        }

        @Override
        public Future<Void> start() {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public boolean isInitialized() {
            return true;
        }

        @Override
        public void close() throws IOException {
        }
    }

    static final class NullDataSourceFactory
    implements ComponentConfigurer<DataSource>,
    DiagnosticDescription {
        static final NullDataSourceFactory INSTANCE = new NullDataSourceFactory();

        NullDataSourceFactory() {
        }

        @Override
        public DataSource build(ClientContext context) {
            LDLogger logger = context.getBaseLogger();
            if (context.isOffline()) {
                logger.info("Starting LaunchDarkly client in offline mode");
            } else {
                logger.info("LaunchDarkly client will not connect to Launchdarkly for feature flag data");
            }
            context.getDataSourceUpdateSink().updateStatus(DataSourceStatusProvider.State.VALID, null);
            return NullDataSource.INSTANCE;
        }

        @Override
        public LDValue describeConfiguration(ClientContext clientContext) {
            return LDValue.buildObject().put(DiagnosticConfigProperty.CUSTOM_BASE_URI.name, false).put(DiagnosticConfigProperty.CUSTOM_STREAM_URI.name, false).put(DiagnosticConfigProperty.STREAMING_DISABLED.name, false).put(DiagnosticConfigProperty.USING_RELAY_DAEMON.name, true).build();
        }
    }

    static final class InMemoryDataStoreFactory
    implements ComponentConfigurer<DataStore>,
    DiagnosticDescription {
        static final InMemoryDataStoreFactory INSTANCE = new InMemoryDataStoreFactory();

        InMemoryDataStoreFactory() {
        }

        @Override
        public DataStore build(ClientContext context) {
            return new InMemoryDataStore();
        }

        @Override
        public LDValue describeConfiguration(ClientContext clientContext) {
            return LDValue.of("memory");
        }
    }
}

