/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.EvaluationDetail;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.DataModelPreprocessing;
import com.launchdarkly.sdk.server.EvalResult;
import com.launchdarkly.sdk.server.EvaluatorOperators;
import java.util.Collection;
import java.util.List;
import java.util.Set;

abstract class EvaluatorHelpers {
    EvaluatorHelpers() {
    }

    static EvalResult offResult(DataModel.FeatureFlag flag) {
        if (flag.preprocessed != null) {
            return flag.preprocessed.offResult;
        }
        return EvalResult.of(EvaluatorHelpers.evaluationDetailForOffVariation(flag, EvaluationReason.off()));
    }

    static EvalResult targetMatchResult(DataModel.FeatureFlag flag, DataModel.Target target) {
        if (target.preprocessed != null) {
            return target.preprocessed.targetMatchResult;
        }
        return EvalResult.of(EvaluatorHelpers.evaluationDetailForVariation(flag, target.getVariation(), EvaluationReason.targetMatch()));
    }

    static EvalResult prerequisiteFailedResult(DataModel.FeatureFlag flag, DataModel.Prerequisite prereq) {
        if (prereq.preprocessed != null) {
            return prereq.preprocessed.prerequisiteFailedResult;
        }
        return EvalResult.of(EvaluatorHelpers.evaluationDetailForOffVariation(flag, EvaluationReason.prerequisiteFailed(prereq.getKey())));
    }

    static EvaluationDetail<LDValue> evaluationDetailForOffVariation(DataModel.FeatureFlag flag, EvaluationReason reason) {
        Integer offVariation = flag.getOffVariation();
        if (offVariation == null) {
            return EvaluationDetail.fromValue(LDValue.ofNull(), -1, reason);
        }
        return EvaluatorHelpers.evaluationDetailForVariation(flag, offVariation, reason);
    }

    static EvaluationDetail<LDValue> evaluationDetailForVariation(DataModel.FeatureFlag flag, int variation, EvaluationReason reason) {
        if (variation < 0 || variation >= flag.getVariations().size()) {
            return EvaluationDetail.fromValue(LDValue.ofNull(), -1, EvaluationReason.error(EvaluationReason.ErrorKind.MALFORMED_FLAG));
        }
        return EvaluationDetail.fromValue(LDValue.normalize(flag.getVariations().get(variation)), variation, reason);
    }

    static boolean maybeNegate(DataModel.Clause clause, boolean b) {
        return clause.isNegate() ? !b : b;
    }

    static boolean matchClauseWithoutSegments(DataModel.Clause clause, LDValue contextValue) {
        DataModel.Operator op = clause.getOp();
        if (op != null) {
            DataModelPreprocessing.ClausePreprocessed preprocessed = clause.preprocessed;
            if (op == DataModel.Operator.in) {
                Set<LDValue> vs;
                Set<LDValue> set = vs = preprocessed == null ? null : preprocessed.valuesSet;
                if (vs != null) {
                    return vs.contains(contextValue);
                }
            }
            List<LDValue> values2 = clause.getValues();
            List<DataModelPreprocessing.ClausePreprocessed.ValueData> preprocessedValues = preprocessed == null ? null : preprocessed.valuesExtra;
            int n = values2.size();
            for (int i = 0; i < n; ++i) {
                DataModelPreprocessing.ClausePreprocessed.ValueData p = preprocessedValues == null ? null : preprocessedValues.get(i);
                LDValue v = values2.get(i);
                if (!EvaluatorOperators.apply(op, contextValue, v, p)) continue;
                return true;
            }
        }
        return false;
    }

    static boolean matchClauseByKind(DataModel.Clause clause, LDContext context) {
        for (int i = 0; i < context.getIndividualContextCount(); ++i) {
            if (!EvaluatorHelpers.matchClauseWithoutSegments(clause, LDValue.of(context.getIndividualContext(i).getKind().toString()))) continue;
            return true;
        }
        return false;
    }

    static boolean contextKeyIsInTargetList(LDContext context, ContextKind contextKind, Collection<String> keys2) {
        if (keys2.isEmpty()) {
            return false;
        }
        LDContext matchContext = context.getIndividualContext(contextKind);
        return matchContext != null && keys2.contains(matchContext.getKey());
    }

    static boolean contextKeyIsInTargetLists(LDContext context, List<DataModel.SegmentTarget> targets) {
        int nTargets = targets.size();
        for (int i = 0; i < nTargets; ++i) {
            DataModel.SegmentTarget t2 = targets.get(i);
            if (!EvaluatorHelpers.contextKeyIsInTargetList(context, t2.getContextKind(), t2.getValues())) continue;
            return true;
        }
        return false;
    }
}

