/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.sdk.internal.http;

import com.launchdarkly.shaded.okhttp3.HttpUrl;
import java.net.URI;
import java.util.List;

public abstract class HttpHelpers {
    private HttpHelpers() {
    }

    public static URI concatenateUriPath(URI uri, String path) {
        HttpUrl.Builder concatBuilder = HttpUrl.get(uri).newBuilder();
        HttpUrl concatted = concatBuilder.addPathSegments(path).build();
        List<String> segments = concatted.pathSegments();
        HttpUrl.Builder sanitizedBuilder = concatted.newBuilder();
        for (int i = segments.size() - 1; i >= 0; --i) {
            if (!segments.get(i).isEmpty()) continue;
            sanitizedBuilder.removePathSegment(i);
        }
        return sanitizedBuilder.build().uri();
    }

    public static URI addQueryParam(URI uri, String name, String value) {
        return HttpUrl.get(uri.toString()).newBuilder().addQueryParameter(name, value).build().uri();
    }

    public static boolean isAsciiHeaderValue(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch >= ' ' && ch <= '~' || ch == '\t') continue;
            return false;
        }
        return true;
    }
}

