/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.sources;

import com.launchdarkly.sdk.json.SerializationException;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.payloads.DeleteObject;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.payloads.Error;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.payloads.FDv2Event;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.payloads.Goodbye;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.payloads.PayloadTransferred;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.payloads.PutObject;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.payloads.ServerIntent;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.sources.FDv2ChangeSet;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.sources.Selector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class FDv2ProtocolHandler {
    private final List<FDv2ChangeSet.FDv2Change> changes = new ArrayList<FDv2ChangeSet.FDv2Change>();
    private FDv2ProtocolState state = FDv2ProtocolState.INACTIVE;
    private static final List<String> HANDLED_EVENT_TYPES;

    private IFDv2ProtocolAction serverIntent(ServerIntent intent) {
        ServerIntent.ServerIntentPayload payload;
        List<ServerIntent.ServerIntentPayload> payloads = intent.getPayloads();
        ServerIntent.ServerIntentPayload serverIntentPayload = payload = payloads == null || payloads.isEmpty() ? null : payloads.get(0);
        if (payload == null) {
            return new FDv2ActionInternalError("No payload present in server-intent", FDv2ProtocolErrorType.MISSING_PAYLOAD);
        }
        switch (payload.getIntentCode()) {
            case NONE: {
                this.state = FDv2ProtocolState.CHANGES;
                this.changes.clear();
                return new FDv2ActionChangeset(FDv2ChangeSet.NONE);
            }
            case TRANSFER_FULL: {
                this.state = FDv2ProtocolState.FULL;
                break;
            }
            case TRANSFER_CHANGES: {
                this.state = FDv2ProtocolState.CHANGES;
                break;
            }
            default: {
                return new FDv2ActionInternalError("Unhandled event code: " + (Object)((Object)payload.getIntentCode()), FDv2ProtocolErrorType.IMPLEMENTATION_ERROR);
            }
        }
        this.changes.clear();
        return FDv2ActionNone.getInstance();
    }

    private void putObject(PutObject put) {
        this.changes.add(new FDv2ChangeSet.FDv2Change(FDv2ChangeSet.FDv2ChangeType.PUT, put.getKind(), put.getKey(), put.getVersion(), put.getObject()));
    }

    private void deleteObject(DeleteObject delete) {
        this.changes.add(new FDv2ChangeSet.FDv2Change(FDv2ChangeSet.FDv2ChangeType.DELETE, delete.getKind(), delete.getKey(), delete.getVersion(), null));
    }

    private IFDv2ProtocolAction payloadTransferred(PayloadTransferred payload) {
        FDv2ChangeSet.FDv2ChangeSetType changeSetType;
        switch (this.state) {
            case INACTIVE: {
                return new FDv2ActionInternalError("A payload transferred has been received without an intent having been established.", FDv2ProtocolErrorType.PROTOCOL_ERROR);
            }
            case CHANGES: {
                changeSetType = FDv2ChangeSet.FDv2ChangeSetType.PARTIAL;
                break;
            }
            case FULL: {
                changeSetType = FDv2ChangeSet.FDv2ChangeSetType.FULL;
                break;
            }
            default: {
                return new FDv2ActionInternalError("Unhandled protocol state: " + (Object)((Object)this.state), FDv2ProtocolErrorType.IMPLEMENTATION_ERROR);
            }
        }
        FDv2ChangeSet changeset = new FDv2ChangeSet(changeSetType, new ArrayList<FDv2ChangeSet.FDv2Change>(this.changes), Selector.make(payload.getVersion(), payload.getState()));
        this.state = FDv2ProtocolState.CHANGES;
        this.changes.clear();
        return new FDv2ActionChangeset(changeset);
    }

    private IFDv2ProtocolAction error(Error error) {
        this.changes.clear();
        return new FDv2ActionError(error.getId(), error.getReason());
    }

    private IFDv2ProtocolAction goodbye(Goodbye intent) {
        return new FDv2ActionGoodbye(intent.getReason());
    }

    public IFDv2ProtocolAction handleEvent(FDv2Event evt) {
        try {
            switch (evt.getEventType()) {
                case "server-intent": {
                    return this.serverIntent(evt.asServerIntent());
                }
                case "delete-object": {
                    this.deleteObject(evt.asDeleteObject());
                    break;
                }
                case "put-object": {
                    this.putObject(evt.asPutObject());
                    break;
                }
                case "error": {
                    return this.error(evt.asError());
                }
                case "goodbye": {
                    return this.goodbye(evt.asGoodbye());
                }
                case "payload-transferred": {
                    return this.payloadTransferred(evt.asPayloadTransferred());
                }
                case "heartbeat": {
                    break;
                }
                default: {
                    return new FDv2ActionInternalError("Received an unknown event of type " + evt.getEventType(), FDv2ProtocolErrorType.UNKNOWN_EVENT);
                }
            }
            return FDv2ActionNone.getInstance();
        }
        catch (FDv2Event.FDv2EventTypeMismatchException ex) {
            return new FDv2ActionInternalError("Event type mismatch: " + ex.getMessage(), FDv2ProtocolErrorType.IMPLEMENTATION_ERROR);
        }
        catch (SerializationException ex) {
            return new FDv2ActionInternalError("Failed to deserialize " + evt.getEventType() + " event: " + ex.getMessage(), FDv2ProtocolErrorType.JSON_ERROR);
        }
    }

    public static List<String> getHandledEventTypes() {
        return HANDLED_EVENT_TYPES;
    }

    public void reset() {
        this.changes.clear();
        this.state = FDv2ProtocolState.INACTIVE;
    }

    static {
        ArrayList<String> types = new ArrayList<String>();
        types.add("server-intent");
        types.add("delete-object");
        types.add("put-object");
        types.add("error");
        types.add("goodbye");
        types.add("payload-transferred");
        types.add("heartbeat");
        HANDLED_EVENT_TYPES = Collections.unmodifiableList(types);
    }

    public static final class FDv2ActionNone
    implements IFDv2ProtocolAction {
        private static final FDv2ActionNone INSTANCE = new FDv2ActionNone();

        private FDv2ActionNone() {
        }

        public static FDv2ActionNone getInstance() {
            return INSTANCE;
        }

        @Override
        public FDv2ProtocolActionType getAction() {
            return FDv2ProtocolActionType.NONE;
        }
    }

    public static final class FDv2ActionInternalError
    implements IFDv2ProtocolAction {
        private final String message;
        private final FDv2ProtocolErrorType errorType;

        public FDv2ActionInternalError(String message, FDv2ProtocolErrorType errorType) {
            this.message = message;
            this.errorType = errorType;
        }

        @Override
        public FDv2ProtocolActionType getAction() {
            return FDv2ProtocolActionType.INTERNAL_ERROR;
        }

        public String getMessage() {
            return this.message;
        }

        public FDv2ProtocolErrorType getErrorType() {
            return this.errorType;
        }
    }

    public static final class FDv2ActionGoodbye
    implements IFDv2ProtocolAction {
        private final String reason;

        public FDv2ActionGoodbye(String reason) {
            this.reason = reason;
        }

        @Override
        public FDv2ProtocolActionType getAction() {
            return FDv2ProtocolActionType.GOODBYE;
        }

        public String getReason() {
            return this.reason;
        }
    }

    public static final class FDv2ActionError
    implements IFDv2ProtocolAction {
        private final String id;
        private final String reason;

        public FDv2ActionError(String id, String reason) {
            this.id = id;
            this.reason = reason;
        }

        @Override
        public FDv2ProtocolActionType getAction() {
            return FDv2ProtocolActionType.ERROR;
        }

        public String getId() {
            return this.id;
        }

        public String getReason() {
            return this.reason;
        }
    }

    public static final class FDv2ActionChangeset
    implements IFDv2ProtocolAction {
        private final FDv2ChangeSet changeset;

        public FDv2ActionChangeset(FDv2ChangeSet changeset) {
            this.changeset = Objects.requireNonNull(changeset, "changeset");
        }

        @Override
        public FDv2ProtocolActionType getAction() {
            return FDv2ProtocolActionType.CHANGESET;
        }

        public FDv2ChangeSet getChangeset() {
            return this.changeset;
        }
    }

    public static interface IFDv2ProtocolAction {
        public FDv2ProtocolActionType getAction();
    }

    public static enum FDv2ProtocolErrorType {
        UNKNOWN_EVENT,
        MISSING_PAYLOAD,
        JSON_ERROR,
        IMPLEMENTATION_ERROR,
        PROTOCOL_ERROR;

    }

    public static enum FDv2ProtocolActionType {
        CHANGESET,
        ERROR,
        GOODBYE,
        NONE,
        INTERNAL_ERROR;

    }

    private static enum FDv2ProtocolState {
        INACTIVE,
        CHANGES,
        FULL;

    }
}

