/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.sources;

import com.launchdarkly.shaded.com.google.gson.JsonElement;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.sources.Selector;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class FDv2ChangeSet {
    private final FDv2ChangeSetType type;
    private final List<FDv2Change> changes;
    private final Selector selector;
    public static final FDv2ChangeSet NONE = new FDv2ChangeSet(FDv2ChangeSetType.NONE, Collections.emptyList(), Selector.EMPTY);

    public FDv2ChangeSet(FDv2ChangeSetType type, List<FDv2Change> changes, Selector selector) {
        this.type = Objects.requireNonNull(type, "type");
        this.changes = Collections.unmodifiableList(Objects.requireNonNull(changes, "changes"));
        this.selector = selector;
    }

    public FDv2ChangeSetType getType() {
        return this.type;
    }

    public List<FDv2Change> getChanges() {
        return this.changes;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public static final class FDv2Change {
        private final FDv2ChangeType type;
        private final String kind;
        private final String key;
        private final int version;
        private final JsonElement object;

        public FDv2Change(FDv2ChangeType type, String kind, String key, int version, JsonElement object) {
            this.type = Objects.requireNonNull(type, "type");
            this.kind = Objects.requireNonNull(kind, "kind");
            this.key = Objects.requireNonNull(key, "key");
            this.version = version;
            this.object = object;
        }

        public FDv2ChangeType getType() {
            return this.type;
        }

        public String getKind() {
            return this.kind;
        }

        public String getKey() {
            return this.key;
        }

        public int getVersion() {
            return this.version;
        }

        public JsonElement getObject() {
            return this.object;
        }
    }

    public static enum FDv2ChangeSetType {
        FULL,
        PARTIAL,
        NONE;

    }

    public static enum FDv2ChangeType {
        PUT,
        DELETE;

    }
}

