/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.payloads;

import com.launchdarkly.sdk.json.SerializationException;
import com.launchdarkly.shaded.com.google.gson.JsonArray;
import com.launchdarkly.shaded.com.google.gson.JsonElement;
import com.launchdarkly.shaded.com.google.gson.stream.JsonReader;
import com.launchdarkly.shaded.com.google.gson.stream.JsonToken;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.GsonHelpers;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.payloads.IntentCode;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class ServerIntent {
    private final List<ServerIntentPayload> payloads;

    public ServerIntent(List<ServerIntentPayload> payloads) {
        this.payloads = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(payloads, "payloads")));
    }

    public List<ServerIntentPayload> getPayloads() {
        return this.payloads;
    }

    public static ServerIntent parse(JsonReader reader) throws SerializationException {
        ArrayList<ServerIntentPayload> payloads = null;
        try {
            if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                throw new SerializationException("expected object");
            }
            reader.beginObject();
            block8: while (reader.peek() != JsonToken.END_OBJECT) {
                String name;
                switch (name = reader.nextName()) {
                    case "payloads": {
                        JsonArray payloadArray = (JsonArray)GsonHelpers.gsonInstance().fromJson(reader, (Type)((Object)JsonArray.class));
                        payloads = new ArrayList<ServerIntentPayload>(payloadArray.size());
                        int index = 0;
                        for (JsonElement payloadElement : payloadArray) {
                            if (payloadElement == null || payloadElement.isJsonNull()) {
                                throw new SerializationException("server-intent contains null payload at index " + index);
                            }
                            payloads.add(ServerIntentPayload.parse(payloadElement));
                            ++index;
                        }
                        continue block8;
                    }
                    default: {
                        reader.skipValue();
                    }
                }
            }
            reader.endObject();
            if (payloads == null) {
                throw new SerializationException("server-intent missing required property 'payloads'");
            }
            return new ServerIntent(payloads);
        }
        catch (IOException | RuntimeException e) {
            throw new SerializationException(e);
        }
    }

    public static final class ServerIntentPayload {
        private final String id;
        private final int target;
        private final IntentCode intentCode;
        private final String reason;

        public ServerIntentPayload(String id, int target, IntentCode intentCode, String reason) {
            this.id = Objects.requireNonNull(id, "id");
            this.target = target;
            this.intentCode = Objects.requireNonNull(intentCode, "intentCode");
            this.reason = Objects.requireNonNull(reason, "reason");
        }

        public String getId() {
            return this.id;
        }

        public int getTarget() {
            return this.target;
        }

        public IntentCode getIntentCode() {
            return this.intentCode;
        }

        public String getReason() {
            return this.reason;
        }

        static ServerIntentPayload parse(JsonElement element) throws SerializationException {
            String id = null;
            Integer target = null;
            IntentCode intentCode = null;
            String reason = null;
            if (!element.isJsonObject()) {
                throw new SerializationException("expected payload object");
            }
            for (Map.Entry<String, JsonElement> entry : element.getAsJsonObject().entrySet()) {
                String name = entry.getKey();
                JsonElement value = entry.getValue();
                switch (name) {
                    case "id": {
                        id = value.isJsonNull() ? null : value.getAsString();
                        break;
                    }
                    case "target": {
                        if (value.isJsonNull()) break;
                        target = value.getAsInt();
                        break;
                    }
                    case "intentCode": {
                        if (value.isJsonNull()) break;
                        intentCode = IntentCode.parse(value.getAsString());
                        break;
                    }
                    case "reason": {
                        reason = value.isJsonNull() ? null : value.getAsString();
                        break;
                    }
                }
            }
            if (id == null) {
                throw new SerializationException("server-intent payload missing required property 'id'");
            }
            if (target == null) {
                throw new SerializationException("server-intent payload missing required property 'target'");
            }
            if (intentCode == null) {
                throw new SerializationException("server-intent payload missing required property 'intentCode'");
            }
            if (reason == null) {
                throw new SerializationException("server-intent payload missing required property 'reason'");
            }
            return new ServerIntentPayload(id, target, intentCode, reason);
        }
    }
}

