/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.payloads;

import com.launchdarkly.sdk.json.SerializationException;
import com.launchdarkly.shaded.com.google.gson.JsonElement;
import com.launchdarkly.shaded.com.google.gson.stream.JsonReader;
import com.launchdarkly.shaded.com.google.gson.stream.JsonToken;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.GsonHelpers;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Objects;

public final class PutObject {
    private final int version;
    private final String kind;
    private final String key;
    private final JsonElement object;

    public PutObject(int version, String kind, String key, JsonElement object) {
        this.version = version;
        this.kind = Objects.requireNonNull(kind, "kind");
        this.key = Objects.requireNonNull(key, "key");
        this.object = Objects.requireNonNull(object, "object");
    }

    public int getVersion() {
        return this.version;
    }

    public String getKind() {
        return this.kind;
    }

    public String getKey() {
        return this.key;
    }

    public JsonElement getObject() {
        return this.object;
    }

    public static PutObject parse(JsonReader reader) throws SerializationException {
        Integer version = null;
        String kind = null;
        String key = null;
        JsonElement object = null;
        try {
            if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                throw new SerializationException("expected object");
            }
            reader.beginObject();
            block14: while (reader.peek() != JsonToken.END_OBJECT) {
                String name;
                switch (name = reader.nextName()) {
                    case "version": {
                        version = reader.nextInt();
                        continue block14;
                    }
                    case "kind": {
                        kind = reader.nextString();
                        continue block14;
                    }
                    case "key": {
                        key = reader.nextString();
                        continue block14;
                    }
                    case "object": {
                        object = (JsonElement)GsonHelpers.gsonInstance().fromJson(reader, (Type)((Object)JsonElement.class));
                        continue block14;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            if (version == null) {
                throw new SerializationException("put object missing required property 'version'");
            }
            if (kind == null) {
                throw new SerializationException("put object missing required property 'kind'");
            }
            if (key == null) {
                throw new SerializationException("put object missing required property 'key'");
            }
            if (object == null) {
                throw new SerializationException("put object missing required property 'object'");
            }
            return new PutObject(version, kind, key, object);
        }
        catch (IOException | RuntimeException e) {
            throw new SerializationException(e);
        }
    }
}

