/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.payloads;

import com.launchdarkly.sdk.json.SerializationException;
import com.launchdarkly.shaded.com.google.gson.TypeAdapter;
import com.launchdarkly.shaded.com.google.gson.stream.JsonReader;
import com.launchdarkly.shaded.com.google.gson.stream.JsonWriter;
import java.io.IOException;

public enum IntentCode {
    NONE("none"),
    TRANSFER_FULL("xfer-full"),
    TRANSFER_CHANGES("xfer-changes");

    private final String stringValue;

    private IntentCode(String stringValue) {
        this.stringValue = stringValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public static IntentCode parse(String value) throws SerializationException {
        if (value == null) {
            throw new SerializationException("intentCode missing required value");
        }
        switch (value) {
            case "none": {
                return NONE;
            }
            case "xfer-full": {
                return TRANSFER_FULL;
            }
            case "xfer-changes": {
                return TRANSFER_CHANGES;
            }
        }
        throw new SerializationException("unknown intent code: " + value);
    }

    public String toString() {
        return this.stringValue;
    }

    public static final class IntentCodeTypeAdapter
    extends TypeAdapter<IntentCode> {
        @Override
        public void write(JsonWriter out, IntentCode value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(value.getStringValue());
            }
        }

        @Override
        public IntentCode read(JsonReader in) throws IOException {
            String value = in.nextString();
            try {
                return IntentCode.parse(value);
            }
            catch (SerializationException e) {
                throw new IOException(e);
            }
        }
    }
}

