/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.payloads;

import com.launchdarkly.sdk.json.SerializationException;
import com.launchdarkly.shaded.com.google.gson.JsonArray;
import com.launchdarkly.shaded.com.google.gson.JsonElement;
import com.launchdarkly.shaded.com.google.gson.JsonObject;
import com.launchdarkly.shaded.com.google.gson.stream.JsonReader;
import com.launchdarkly.shaded.com.google.gson.stream.JsonToken;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.GsonHelpers;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.payloads.DeleteObject;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.payloads.Error;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.payloads.Goodbye;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.payloads.PayloadTransferred;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.payloads.PutObject;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.payloads.ServerIntent;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class FDv2Event {
    private static final String EVENT_SERVER_INTENT = "server-intent";
    private static final String EVENT_PUT_OBJECT = "put-object";
    private static final String EVENT_DELETE_OBJECT = "delete-object";
    private static final String EVENT_PAYLOAD_TRANSFERRED = "payload-transferred";
    private static final String EVENT_ERROR = "error";
    private static final String EVENT_GOODBYE = "goodbye";
    private final String eventType;
    private final JsonElement data;

    public FDv2Event(String eventType, JsonElement data) {
        this.eventType = Objects.requireNonNull(eventType, "eventType");
        this.data = Objects.requireNonNull(data, "data");
    }

    public String getEventType() {
        return this.eventType;
    }

    public JsonElement getData() {
        return this.data;
    }

    public static FDv2Event parse(JsonReader reader) throws SerializationException {
        String eventType = null;
        JsonElement data = null;
        try {
            if (reader.peek() != JsonToken.BEGIN_OBJECT) {
                throw new SerializationException("expected object");
            }
            reader.beginObject();
            block10: while (reader.peek() != JsonToken.END_OBJECT) {
                String name;
                switch (name = reader.nextName()) {
                    case "event": {
                        eventType = reader.nextString();
                        continue block10;
                    }
                    case "data": {
                        data = (JsonElement)GsonHelpers.gsonInstance().fromJson(reader, (Type)((Object)JsonElement.class));
                        continue block10;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            if (eventType == null) {
                throw new SerializationException("event missing required property 'event'");
            }
            if (data == null) {
                throw new SerializationException("event missing required property 'data'");
            }
            return new FDv2Event(eventType, data);
        }
        catch (IOException | RuntimeException e) {
            throw new SerializationException(e);
        }
    }

    public ServerIntent asServerIntent() throws SerializationException {
        return this.deserializeAs(EVENT_SERVER_INTENT, ServerIntent::parse);
    }

    public PutObject asPutObject() throws SerializationException {
        return this.deserializeAs(EVENT_PUT_OBJECT, PutObject::parse);
    }

    public DeleteObject asDeleteObject() throws SerializationException {
        return this.deserializeAs(EVENT_DELETE_OBJECT, DeleteObject::parse);
    }

    public PayloadTransferred asPayloadTransferred() throws SerializationException {
        return this.deserializeAs(EVENT_PAYLOAD_TRANSFERRED, PayloadTransferred::parse);
    }

    public Error asError() throws SerializationException {
        return this.deserializeAs(EVENT_ERROR, Error::parse);
    }

    public Goodbye asGoodbye() throws SerializationException {
        return this.deserializeAs(EVENT_GOODBYE, Goodbye::parse);
    }

    public static List<FDv2Event> parseEventsArray(String jsonString) throws SerializationException {
        JsonObject root;
        try {
            root = GsonHelpers.gsonInstance().fromJson(jsonString, JsonObject.class);
        }
        catch (RuntimeException e) {
            throw new SerializationException(e);
        }
        if (root == null || !root.has("events")) {
            throw new SerializationException("FDv2 polling response missing 'events' property");
        }
        JsonElement eventsElement = root.get("events");
        if (!eventsElement.isJsonArray()) {
            throw new SerializationException("FDv2 polling response 'events' is not an array");
        }
        JsonArray eventsArray = eventsElement.getAsJsonArray();
        ArrayList<FDv2Event> events = new ArrayList<FDv2Event>(eventsArray.size());
        int index = 0;
        for (JsonElement eventElement : eventsArray) {
            if (eventElement == null || eventElement.isJsonNull()) {
                throw new SerializationException("FDv2 polling response contains null event at index " + index);
            }
            events.add(FDv2Event.parseEventElement(eventElement, index));
            ++index;
        }
        return events;
    }

    private static FDv2Event parseEventElement(JsonElement element, int index) throws SerializationException {
        if (!element.isJsonObject()) {
            throw new SerializationException("FDv2 polling response event at index " + index + " is not an object");
        }
        JsonObject obj = element.getAsJsonObject();
        JsonElement eventTypeElement = obj.get("event");
        JsonElement dataElement = obj.get("data");
        if (eventTypeElement == null || eventTypeElement.isJsonNull()) {
            throw new SerializationException("event at index " + index + " missing required property 'event'");
        }
        if (dataElement == null || dataElement.isJsonNull()) {
            throw new SerializationException("event at index " + index + " missing required property 'data'");
        }
        return new FDv2Event(eventTypeElement.getAsString(), dataElement);
    }

    private <T> T deserializeAs(String expectedEventType, Parser<T> parser) throws SerializationException {
        if (!expectedEventType.equals(this.eventType)) {
            throw new FDv2EventTypeMismatchException(this.eventType, expectedEventType);
        }
        try {
            JsonReader reader = new JsonReader(new StringReader(this.data.toString()));
            return parser.parse(reader);
        }
        catch (SerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SerializationException(e);
        }
    }

    private static interface Parser<T> {
        public T parse(JsonReader var1) throws Exception;
    }

    public static final class FDv2EventTypeMismatchException
    extends SerializationException {
        private static final long serialVersionUID = 1L;
        private final String actualEventType;
        private final String expectedEventType;

        public FDv2EventTypeMismatchException(String actualEventType, String expectedEventType) {
            super(String.format("Cannot deserialize event type '%s' as '%s'.", actualEventType, expectedEventType));
            this.actualEventType = actualEventType;
            this.expectedEventType = expectedEventType;
        }

        public String getActualEventType() {
            return this.actualEventType;
        }

        public String getExpectedEventType() {
            return this.expectedEventType;
        }
    }
}

