/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.eventsource;

import com.launchdarkly.shaded.com.launchdarkly.eventsource.ResponseHeaders;
import com.launchdarkly.shaded.okhttp3.Headers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class ResponseHeadersImpl
implements ResponseHeaders {
    private static final ResponseHeaders EMPTY = new ResponseHeadersImpl(Collections.emptyList());
    private final List<ResponseHeaders.Header> headers;

    private ResponseHeadersImpl(List<ResponseHeaders.Header> headers) {
        this.headers = headers;
    }

    static ResponseHeaders fromOkHttpHeaders(Headers headers) {
        if (headers == null || headers.size() == 0) {
            return EMPTY;
        }
        ArrayList<ResponseHeaders.Header> headerList = new ArrayList<ResponseHeaders.Header>(headers.size());
        for (int i = 0; i < headers.size(); ++i) {
            headerList.add(new ResponseHeaders.Header(headers.name(i), headers.value(i)));
        }
        return new ResponseHeadersImpl(Collections.unmodifiableList(headerList));
    }

    static ResponseHeaders empty() {
        return EMPTY;
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public ResponseHeaders.Header get(int index) {
        return this.headers.get(index);
    }

    @Override
    public String value(String name) {
        if (name == null) {
            return null;
        }
        for (ResponseHeaders.Header header : this.headers) {
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return header.getValue();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public String toString() {
        return "ResponseHeaders(" + this.headers.size() + " headers)";
    }
}

