/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.eventsource;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.BufferedLineParser;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.CommentEvent;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.Helpers;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.MessageEvent;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.ResponseHeaders;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.SetRetryDelayEvent;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.StreamClosedByServerException;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.StreamClosedWithIncompleteMessageException;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.StreamEvent;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.StreamException;
import com.launchdarkly.shaded.com.launchdarkly.eventsource.StreamIOException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;

final class EventParser {
    static final int VALUE_BUFFER_INITIAL_CAPACITY = 1000;
    static final int MIN_READ_BUFFER_SIZE = 200;
    private static final String DATA = "data";
    private static final String EVENT = "event";
    private static final String ID = "id";
    private static final String RETRY = "retry";
    private static final String COMMENT = "";
    private static final Pattern DIGITS_ONLY = Pattern.compile("^[\\d]+$");
    private final boolean streamEventData;
    private Set<String> expectFields;
    private final LDLogger logger;
    private final URI origin;
    private final ResponseHeaders headers;
    private BufferedLineParser lineParser;
    private byte[] chunkData;
    private int chunkOffset;
    private int chunkSize;
    private boolean lineEnded;
    private int currentLineLength;
    private ByteArrayOutputStream dataBuffer;
    private ByteArrayOutputStream valueBuffer;
    private boolean haveData;
    private boolean dataLineEnded;
    private String fieldName;
    private String lastEventId;
    private String eventName;
    private boolean skipRestOfMessage;
    private boolean skipRestOfLine;
    private IncrementalMessageDataInputStream currentMessageDataStream;

    EventParser(InputStream inputStream2, URI origin, int readBufferSize, boolean streamEventData, Set<String> expectFields, LDLogger logger, ResponseHeaders headers) {
        this.lineParser = new BufferedLineParser(inputStream2, readBufferSize);
        this.origin = origin;
        this.streamEventData = streamEventData;
        this.expectFields = expectFields;
        this.logger = logger;
        this.headers = headers;
        this.dataBuffer = new ByteArrayOutputStream(1000);
    }

    public StreamEvent nextEvent() throws StreamException {
        StreamEvent event;
        while ((event = this.tryNextEvent()) == null) {
        }
        return event;
    }

    private StreamEvent tryNextEvent() throws StreamException {
        String fieldValue;
        if (this.currentMessageDataStream != null) {
            IncrementalMessageDataInputStream obsoleteStream = this.currentMessageDataStream;
            this.skipRestOfMessage = true;
            this.currentMessageDataStream = null;
            obsoleteStream.close();
        }
        try {
            this.getNextChunk();
        }
        catch (IOException e) {
            throw new StreamIOException(e);
        }
        if (this.skipRestOfMessage) {
            if (this.lineEnded && this.currentLineLength == 0) {
                this.skipRestOfMessage = false;
                this.resetState();
            }
            return null;
        }
        if (this.skipRestOfLine) {
            this.skipRestOfLine = !this.lineEnded;
            return null;
        }
        if (this.lineEnded && this.currentLineLength == 0) {
            if (!this.haveData) {
                this.resetState();
                return null;
            }
            String dataString = Helpers.utf8ByteArrayOutputStreamToString(this.dataBuffer);
            MessageEvent message = new MessageEvent(this.eventName, dataString, this.lastEventId, this.origin, this.headers);
            this.resetState();
            this.logger.debug("Received message: {}", (Object)message);
            return message;
        }
        if (this.fieldName == null) {
            this.fieldName = this.parseFieldName();
            if (this.fieldName == null) {
                this.skipRestOfLine = !this.lineEnded;
                return null;
            }
        }
        if (this.fieldName.equals(DATA)) {
            if (this.canStreamEventDataNow()) {
                IncrementalMessageDataInputStream messageDataStream;
                this.currentMessageDataStream = messageDataStream = new IncrementalMessageDataInputStream();
                MessageEvent message = new MessageEvent(this.eventName, new InputStreamReader(messageDataStream), this.lastEventId, this.origin, this.headers);
                this.logger.debug("Received message: {}", (Object)message);
                return message;
            }
            if (this.dataLineEnded) {
                this.dataBuffer.write(10);
            }
            if (this.chunkSize != 0) {
                this.dataBuffer.write(this.chunkData, this.chunkOffset, this.chunkSize);
            }
            this.dataLineEnded = this.lineEnded;
            this.haveData = true;
            if (this.lineEnded) {
                this.fieldName = null;
            }
            return null;
        }
        if (!this.lineEnded) {
            if (this.valueBuffer == null) {
                this.valueBuffer = new ByteArrayOutputStream(1000);
            }
            this.valueBuffer.write(this.chunkData, this.chunkOffset, this.chunkSize);
            return null;
        }
        String completedFieldName = this.fieldName;
        this.fieldName = null;
        if (this.valueBuffer == null || this.valueBuffer.size() == 0) {
            fieldValue = this.chunkSize == 0 ? COMMENT : new String(this.chunkData, this.chunkOffset, this.chunkSize, Helpers.UTF8);
        } else {
            this.valueBuffer.write(this.chunkData, this.chunkOffset, this.chunkSize);
            fieldValue = Helpers.utf8ByteArrayOutputStreamToString(this.valueBuffer);
            this.resetValueBuffer();
        }
        switch (completedFieldName) {
            case "": {
                return new CommentEvent(fieldValue);
            }
            case "event": {
                this.eventName = fieldValue;
                break;
            }
            case "id": {
                if (fieldValue.contains("\u0000")) break;
                this.lastEventId = fieldValue;
                break;
            }
            case "retry": {
                if (!DIGITS_ONLY.matcher(fieldValue).matches()) break;
                return new SetRetryDelayEvent(Long.parseLong(fieldValue));
            }
        }
        return null;
    }

    private void getNextChunk() throws IOException, StreamClosedByServerException {
        boolean previousLineEnded = this.lineEnded;
        this.lineEnded = this.lineParser.read();
        this.chunkData = this.lineParser.getBuffer();
        this.chunkOffset = this.lineParser.getChunkOffset();
        this.chunkSize = this.lineParser.getChunkSize();
        if (this.chunkSize == 0 && this.lineParser.isEof()) {
            throw new StreamClosedByServerException();
        }
        this.currentLineLength = previousLineEnded ? this.chunkSize : (this.currentLineLength += this.chunkSize);
    }

    private String parseFieldName() {
        String name;
        int nameLength;
        for (nameLength = 0; nameLength < this.chunkSize && this.chunkData[this.chunkOffset + nameLength] != 58; ++nameLength) {
        }
        this.resetValueBuffer();
        if (nameLength == this.chunkSize && !this.lineEnded) {
            return null;
        }
        String string = name = nameLength == 0 ? COMMENT : new String(this.chunkData, this.chunkOffset, nameLength, Helpers.UTF8);
        if (nameLength < this.chunkSize && ++nameLength < this.chunkSize && this.chunkData[this.chunkOffset + nameLength] == 32) {
            ++nameLength;
        }
        this.chunkOffset += nameLength;
        this.chunkSize -= nameLength;
        return name;
    }

    private boolean canStreamEventDataNow() {
        if (!this.streamEventData) {
            return false;
        }
        if (this.expectFields != null) {
            if (this.expectFields.contains(EVENT) && this.eventName == null) {
                return false;
            }
            if (this.expectFields.contains(ID) && this.lastEventId == null) {
                return false;
            }
        }
        return true;
    }

    private void resetState() {
        this.haveData = false;
        this.dataLineEnded = false;
        this.eventName = null;
        this.fieldName = null;
        this.resetValueBuffer();
        if (this.dataBuffer.size() != 0) {
            if (this.dataBuffer.size() > 1000) {
                this.dataBuffer = new ByteArrayOutputStream(1000);
            } else {
                this.dataBuffer.reset();
            }
        }
        this.currentMessageDataStream = null;
    }

    private void resetValueBuffer() {
        if (this.valueBuffer != null) {
            if (this.valueBuffer.size() > 1000) {
                this.valueBuffer = null;
            } else {
                this.valueBuffer.reset();
            }
        }
    }

    private class IncrementalMessageDataInputStream
    extends InputStream {
        private boolean haveChunk = true;
        private int readOffset = 0;
        private final AtomicBoolean closed = new AtomicBoolean();

        private IncrementalMessageDataInputStream() {
        }

        @Override
        public void close() {
            if (this.closed.getAndSet(true)) {
                return;
            }
            if (EventParser.this.currentMessageDataStream == this) {
                EventParser.this.currentMessageDataStream = null;
                EventParser.this.skipRestOfMessage = true;
            }
        }

        @Override
        public int read() throws IOException {
            int n;
            byte[] b = new byte[]{};
            do {
                if ((n = this.read(b, 0, 1)) >= 0) continue;
                return n;
            } while (n != 1);
            return b[0];
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            while (true) {
                if (len <= 0 || this.closed.get()) {
                    return 0;
                }
                if (this.haveChunk) {
                    if (EventParser.this.skipRestOfLine) {
                        EventParser.this.skipRestOfLine = !EventParser.this.lineEnded;
                        this.haveChunk = false;
                        continue;
                    }
                    int availableSize = EventParser.this.chunkSize - this.readOffset;
                    if (availableSize > len) {
                        System.arraycopy(EventParser.this.chunkData, EventParser.this.chunkOffset + this.readOffset, b, off, len);
                        this.readOffset += len;
                        return len;
                    }
                    System.arraycopy(EventParser.this.chunkData, EventParser.this.chunkOffset + this.readOffset, b, off, availableSize);
                    this.haveChunk = false;
                    this.readOffset = 0;
                    return availableSize;
                }
                if (!EventParser.this.lineEnded) {
                    if (!this.canGetNextChunk()) {
                        throw new StreamClosedWithIncompleteMessageException();
                    }
                    this.haveChunk = true;
                    continue;
                }
                if (!this.canGetNextChunk()) {
                    throw new StreamClosedWithIncompleteMessageException();
                }
                if (EventParser.this.lineEnded && EventParser.this.chunkSize == 0) {
                    this.closed.set(true);
                    EventParser.this.resetState();
                    return -1;
                }
                String fieldName = EventParser.this.parseFieldName();
                if (EventParser.DATA.equals(fieldName)) break;
                EventParser.this.skipRestOfLine = !EventParser.this.lineEnded;
            }
            b[0] = 10;
            this.haveChunk = true;
            return 1;
        }

        private boolean canGetNextChunk() throws IOException {
            try {
                EventParser.this.getNextChunk();
            }
            catch (StreamClosedByServerException e) {
                this.close();
                return false;
            }
            return true;
        }
    }
}

