/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.subsystems;

import com.launchdarkly.sdk.server.datasources.Initializer;
import com.launchdarkly.sdk.server.datasources.Synchronizer;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.DataSource;
import com.launchdarkly.sdk.server.subsystems.DataSourceBuilder;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableList;

public final class DataSystemConfiguration {
    private final ImmutableList<DataSourceBuilder<Initializer>> initializers;
    private final ImmutableList<DataSourceBuilder<Synchronizer>> synchronizers;
    private final ComponentConfigurer<DataSource> fDv1FallbackSynchronizer;
    private final ComponentConfigurer<DataStore> persistentStore;
    private final DataStoreMode persistentDataStoreMode;

    public DataSystemConfiguration(ImmutableList<DataSourceBuilder<Initializer>> initializers, ImmutableList<DataSourceBuilder<Synchronizer>> synchronizers, ComponentConfigurer<DataSource> fDv1FallbackSynchronizer, ComponentConfigurer<DataStore> persistentStore, DataStoreMode persistentDataStoreMode) {
        this.initializers = initializers;
        this.synchronizers = synchronizers;
        this.fDv1FallbackSynchronizer = fDv1FallbackSynchronizer;
        this.persistentStore = persistentStore;
        this.persistentDataStoreMode = persistentDataStoreMode;
    }

    public ImmutableList<DataSourceBuilder<Initializer>> getInitializers() {
        return this.initializers;
    }

    public ImmutableList<DataSourceBuilder<Synchronizer>> getSynchronizers() {
        return this.synchronizers;
    }

    public ComponentConfigurer<DataSource> getFDv1FallbackSynchronizer() {
        return this.fDv1FallbackSynchronizer;
    }

    public ComponentConfigurer<DataStore> getPersistentStore() {
        return this.persistentStore;
    }

    public DataStoreMode getPersistentDataStoreMode() {
        return this.persistentDataStoreMode;
    }

    public static enum DataStoreMode {
        READ_ONLY,
        READ_WRITE;

    }
}

