/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.subsystems;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.interfaces.ApplicationInfo;
import com.launchdarkly.sdk.server.interfaces.ServiceEndpoints;
import com.launchdarkly.sdk.server.interfaces.WrapperInfo;
import com.launchdarkly.sdk.server.subsystems.DataSourceUpdateSink;
import com.launchdarkly.sdk.server.subsystems.DataStoreUpdateSink;
import com.launchdarkly.sdk.server.subsystems.HttpConfiguration;
import com.launchdarkly.sdk.server.subsystems.LoggingConfiguration;

public class ClientContext {
    private final String sdkKey;
    private final ApplicationInfo applicationInfo;
    private final LDLogger baseLogger;
    private final HttpConfiguration http;
    private final LoggingConfiguration logging;
    private final boolean offline;
    private final ServiceEndpoints serviceEndpoints;
    private final int threadPriority;
    private WrapperInfo wrapperInfo;

    public ClientContext(String sdkKey, ApplicationInfo applicationInfo, HttpConfiguration http, LoggingConfiguration logging, boolean offline, ServiceEndpoints serviceEndpoints, int threadPriority, WrapperInfo wrapperInfo) {
        this.sdkKey = sdkKey;
        this.applicationInfo = applicationInfo;
        this.http = http;
        this.logging = logging;
        this.offline = offline;
        this.serviceEndpoints = serviceEndpoints;
        this.threadPriority = threadPriority;
        this.wrapperInfo = wrapperInfo;
        this.baseLogger = logging == null ? LDLogger.none() : LDLogger.withAdapter(logging.getLogAdapter(), logging.getBaseLoggerName());
    }

    protected ClientContext(ClientContext copyFrom) {
        this(copyFrom.sdkKey, copyFrom.applicationInfo, copyFrom.http, copyFrom.logging, copyFrom.offline, copyFrom.serviceEndpoints, copyFrom.threadPriority, copyFrom.wrapperInfo);
    }

    public ClientContext(String sdkKey) {
        this(sdkKey, new ApplicationInfo(null, null), ClientContext.defaultHttp(sdkKey), ClientContext.defaultLogging(), false, Components.serviceEndpoints().createServiceEndpoints(), 1, null);
    }

    private static HttpConfiguration defaultHttp(String sdkKey) {
        ClientContext minimalContext = new ClientContext(sdkKey, null, null, null, false, null, 0, null);
        return (HttpConfiguration)Components.httpConfiguration().build(minimalContext);
    }

    private static LoggingConfiguration defaultLogging() {
        ClientContext minimalContext = new ClientContext("", null, null, null, false, null, 0, null);
        return (LoggingConfiguration)Components.logging().build(minimalContext);
    }

    public String getSdkKey() {
        return this.sdkKey;
    }

    public ApplicationInfo getApplicationInfo() {
        return this.applicationInfo;
    }

    public LDLogger getBaseLogger() {
        return this.baseLogger;
    }

    public DataSourceUpdateSink getDataSourceUpdateSink() {
        return null;
    }

    public DataStoreUpdateSink getDataStoreUpdateSink() {
        return null;
    }

    public HttpConfiguration getHttp() {
        return this.http;
    }

    public LoggingConfiguration getLogging() {
        return this.logging;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public ServiceEndpoints getServiceEndpoints() {
        return this.serviceEndpoints;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public WrapperInfo getWrapperInfo() {
        return this.wrapperInfo;
    }
}

