/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.datasources.FDv2SourceResult;
import com.launchdarkly.sdk.server.datasources.Synchronizer;
import com.launchdarkly.sdk.server.integrations.TestData;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.subsystems.DataSourceBuildInputs;
import com.launchdarkly.sdk.server.subsystems.DataSourceBuilder;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableMap;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.collections.IterableAsyncQueue;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.sources.Selector;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public final class TestDataV2
implements DataSourceBuilder<Synchronizer> {
    private final Object lock = new Object();
    private final Map<String, DataStoreTypes.ItemDescriptor> currentFlags = new HashMap<String, DataStoreTypes.ItemDescriptor>();
    private final Map<String, TestData.FlagBuilder> currentBuilders = new HashMap<String, TestData.FlagBuilder>();
    private final List<TestDataV2SynchronizerImpl> synchronizerInstances = new CopyOnWriteArrayList<TestDataV2SynchronizerImpl>();
    private volatile boolean shouldPersist = true;

    public static TestDataV2 synchronizer() {
        return new TestDataV2();
    }

    private TestDataV2() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestData.FlagBuilder flag(String key) {
        TestData.FlagBuilder existingBuilder;
        Object object = this.lock;
        synchronized (object) {
            existingBuilder = this.currentBuilders.get(key);
        }
        if (existingBuilder != null) {
            return new TestData.FlagBuilder(existingBuilder);
        }
        return new TestData.FlagBuilder(key).booleanFlag();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestDataV2 delete(String key) {
        DataStoreTypes.ItemDescriptor tombstoneItem;
        Object object = this.lock;
        synchronized (object) {
            DataStoreTypes.ItemDescriptor oldItem = this.currentFlags.get(key);
            int oldVersion = oldItem == null ? 0 : oldItem.getVersion();
            tombstoneItem = DataStoreTypes.ItemDescriptor.deletedItem(oldVersion + 1);
            this.currentFlags.put(key, tombstoneItem);
            this.currentBuilders.remove(key);
        }
        this.pushToSynchronizers(FDv2SourceResult.changeSet(this.makePartialChangeSet(key, tombstoneItem), false));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestDataV2 update(TestData.FlagBuilder flagBuilder) {
        String key = flagBuilder.key;
        TestData.FlagBuilder clonedBuilder = new TestData.FlagBuilder(flagBuilder);
        DataStoreTypes.ItemDescriptor newItem = null;
        Object object = this.lock;
        synchronized (object) {
            DataStoreTypes.ItemDescriptor oldItem = this.currentFlags.get(key);
            int oldVersion = oldItem == null ? 0 : oldItem.getVersion();
            newItem = flagBuilder.createFlag(oldVersion + 1);
            this.currentFlags.put(key, newItem);
            this.currentBuilders.put(key, clonedBuilder);
        }
        this.pushToSynchronizers(FDv2SourceResult.changeSet(this.makePartialChangeSet(key, newItem), false));
        return this;
    }

    public TestDataV2 updateStatus(DataSourceStatusProvider.State newState, DataSourceStatusProvider.ErrorInfo newError) {
        FDv2SourceResult statusResult;
        switch (newState) {
            case OFF: {
                statusResult = newError != null ? FDv2SourceResult.terminalError(newError, false) : FDv2SourceResult.shutdown();
                break;
            }
            case INTERRUPTED: {
                statusResult = FDv2SourceResult.interrupted(newError != null ? newError : new DataSourceStatusProvider.ErrorInfo(DataSourceStatusProvider.ErrorKind.UNKNOWN, 0, null, Instant.now()), false);
                break;
            }
            default: {
                statusResult = null;
            }
        }
        if (statusResult != null) {
            this.pushToSynchronizers(statusResult);
        }
        return this;
    }

    public TestDataV2 shouldPersist(boolean shouldPersist) {
        this.shouldPersist = shouldPersist;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Synchronizer build(DataSourceBuildInputs context) {
        TestDataV2SynchronizerImpl synchronizer = new TestDataV2SynchronizerImpl();
        Object object = this.lock;
        synchronized (object) {
            this.synchronizerInstances.add(synchronizer);
        }
        return synchronizer;
    }

    private void pushToSynchronizers(FDv2SourceResult result) {
        for (TestDataV2SynchronizerImpl sync : this.synchronizerInstances) {
            CompletableFuture<Void> completion = new CompletableFuture<Void>();
            FDv2SourceResult wrappedResult = result.withCompletion(v -> {
                completion.complete(null);
                return null;
            });
            sync.put(wrappedResult, completion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> makeFullChangeSet() {
        ImmutableMap<String, DataStoreTypes.ItemDescriptor> copiedData;
        Object object = this.lock;
        synchronized (object) {
            copiedData = ImmutableMap.copyOf(this.currentFlags);
        }
        Set entries = copiedData.entrySet();
        return new DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor>(DataStoreTypes.ChangeSetType.Full, Selector.EMPTY, Collections.singletonList(new AbstractMap.SimpleEntry(DataModel.FEATURES, new DataStoreTypes.KeyedItems(entries))), null, this.shouldPersist);
    }

    private DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> makePartialChangeSet(String key, DataStoreTypes.ItemDescriptor item) {
        return new DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor>(DataStoreTypes.ChangeSetType.Partial, Selector.EMPTY, Collections.singletonList(new AbstractMap.SimpleEntry(DataModel.FEATURES, new DataStoreTypes.KeyedItems(Collections.singletonList(new AbstractMap.SimpleEntry<String, DataStoreTypes.ItemDescriptor>(key, item))))), null, this.shouldPersist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closedSynchronizerInstance(TestDataV2SynchronizerImpl synchronizer) {
        Object object = this.lock;
        synchronized (object) {
            this.synchronizerInstances.remove(synchronizer);
        }
    }

    private final class TestDataV2SynchronizerImpl
    implements Synchronizer {
        private final IterableAsyncQueue<FDv2SourceResult> resultQueue = new IterableAsyncQueue();
        private final CompletableFuture<FDv2SourceResult> shutdownFuture = new CompletableFuture();
        private final AtomicBoolean initialSent = new AtomicBoolean(false);

        private TestDataV2SynchronizerImpl() {
        }

        void put(FDv2SourceResult result, CompletableFuture<Void> completion) {
            this.resultQueue.put(result);
            try {
                CompletableFuture.anyOf(completion, this.shutdownFuture).get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public CompletableFuture<FDv2SourceResult> next() {
            if (!this.initialSent.getAndSet(true)) {
                this.resultQueue.put(FDv2SourceResult.changeSet(TestDataV2.this.makeFullChangeSet(), false));
            }
            return CompletableFuture.anyOf(this.shutdownFuture, this.resultQueue.take()).thenApply(r -> (FDv2SourceResult)r);
        }

        @Override
        public void close() {
            this.shutdownFuture.complete(FDv2SourceResult.shutdown());
            TestDataV2.this.closedSynchronizerInstance(this);
        }
    }
}

