/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.LogValues;
import com.launchdarkly.sdk.server.datasources.FDv2SourceResult;
import com.launchdarkly.sdk.server.datasources.Synchronizer;
import com.launchdarkly.sdk.server.integrations.FileData;
import com.launchdarkly.sdk.server.integrations.FileDataSourceBase;
import com.launchdarkly.sdk.server.integrations.FileDataSourceBuilder;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.collections.IterableAsyncQueue;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

final class FileSynchronizer
extends FileDataSourceBase
implements Synchronizer {
    private final CompletableFuture<FDv2SourceResult> shutdownFuture = new CompletableFuture();
    private final IterableAsyncQueue<FDv2SourceResult> resultQueue = new IterableAsyncQueue();
    private final FileWatcher fileWatcher;
    private AtomicBoolean started = new AtomicBoolean(false);

    FileSynchronizer(List<FileDataSourceBuilder.SourceInfo> sources, boolean autoUpdate, FileData.DuplicateKeysHandling duplicateKeysHandling, LDLogger logger, boolean persist) {
        super(sources, duplicateKeysHandling, logger, persist);
        FileWatcher fw = null;
        if (autoUpdate) {
            try {
                fw = FileWatcher.create(this.getSources(), logger);
            }
            catch (IOException e) {
                logger.error("Unable to watch files for auto-updating: {}", (Object)e.toString());
                logger.debug(e.toString(), (Object)e);
                fw = null;
            }
        }
        this.fileWatcher = fw;
    }

    @Override
    public CompletableFuture<FDv2SourceResult> next() {
        if (!this.started.getAndSet(true)) {
            this.resultQueue.put(this.loadData());
            if (this.fileWatcher != null) {
                this.fileWatcher.start(this::onFileChange);
            }
        }
        return CompletableFuture.anyOf(this.shutdownFuture, this.resultQueue.take()).thenApply(result -> (FDv2SourceResult)result);
    }

    private void onFileChange() {
        this.resultQueue.put(this.loadData());
    }

    @Override
    public void close() {
        this.shutdownFuture.complete(FDv2SourceResult.shutdown());
        if (this.fileWatcher != null) {
            this.fileWatcher.stop();
        }
    }

    private static final class FileWatcher
    implements Runnable {
        private final WatchService watchService;
        private final Set<Path> watchedFilePaths;
        private Runnable fileModifiedAction;
        private final Thread thread;
        private final LDLogger logger;
        private volatile boolean stopped;

        private static FileWatcher create(Iterable<FileDataSourceBuilder.SourceInfo> sources, LDLogger logger) throws IOException {
            HashSet<Path> directoryPaths = new HashSet<Path>();
            HashSet<Path> absoluteFilePaths = new HashSet<Path>();
            FileSystem fs = FileSystems.getDefault();
            WatchService ws = fs.newWatchService();
            for (FileDataSourceBuilder.SourceInfo s2 : sources) {
                Path p = s2.toFilePath();
                if (p == null) continue;
                Path absolutePath = p.toAbsolutePath();
                absoluteFilePaths.add(absolutePath);
                directoryPaths.add(absolutePath.getParent());
            }
            for (Path d : directoryPaths) {
                d.register(ws, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
            }
            return new FileWatcher(ws, absoluteFilePaths, logger);
        }

        private FileWatcher(WatchService watchService, Set<Path> watchedFilePaths, LDLogger logger) {
            this.watchService = watchService;
            this.watchedFilePaths = watchedFilePaths;
            this.logger = logger;
            this.thread = new Thread((Runnable)this, FileSynchronizer.class.getName());
            this.thread.setDaemon(true);
        }

        @Override
        public void run() {
            while (!this.stopped) {
                try {
                    WatchKey key = this.watchService.take();
                    boolean watchedFileWasChanged = false;
                    for (WatchEvent<?> event : key.pollEvents()) {
                        Path fileNamePath;
                        Path dirPath;
                        Path absolutePath;
                        Watchable w = key.watchable();
                        Object context = event.context();
                        if (!(w instanceof Path) || !(context instanceof Path) || !this.watchedFilePaths.contains(absolutePath = (dirPath = (Path)w).resolve(fileNamePath = (Path)context))) continue;
                        watchedFileWasChanged = true;
                        break;
                    }
                    if (watchedFileWasChanged) {
                        try {
                            this.fileModifiedAction.run();
                        }
                        catch (Exception e) {
                            this.logger.warn("Unexpected exception when reloading file data: {}", LogValues.exceptionSummary(e));
                        }
                    }
                    key.reset();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void start(Runnable fileModifiedAction) {
            this.fileModifiedAction = fileModifiedAction;
            this.thread.start();
        }

        public void stop() {
            this.stopped = true;
            this.thread.interrupt();
        }
    }
}

