/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.datasources.FDv2SourceResult;
import com.launchdarkly.sdk.server.datasources.Initializer;
import com.launchdarkly.sdk.server.integrations.FileData;
import com.launchdarkly.sdk.server.integrations.FileDataSourceBuilder;
import com.launchdarkly.sdk.server.integrations.FileSynchronizer;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;

final class FileInitializer
implements Initializer {
    private final FileSynchronizer synchronizer;

    FileInitializer(List<FileDataSourceBuilder.SourceInfo> sources, FileData.DuplicateKeysHandling duplicateKeysHandling, LDLogger logger, boolean persist) {
        this.synchronizer = new FileSynchronizer(sources, false, duplicateKeysHandling, logger, persist);
    }

    @Override
    public CompletableFuture<FDv2SourceResult> run() {
        return this.synchronizer.next().thenApply(result -> {
            if (result.getResultType() == FDv2SourceResult.ResultType.STATUS && result.getStatus().getState() == FDv2SourceResult.State.INTERRUPTED) {
                return FDv2SourceResult.terminalError(result.getStatus().getErrorInfo(), result.isFdv1Fallback());
            }
            return result;
        });
    }

    @Override
    public void close() throws IOException {
        this.synchronizer.close();
    }
}

