/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.LogValues;
import com.launchdarkly.sdk.server.datasources.FDv2SourceResult;
import com.launchdarkly.sdk.server.integrations.FileData;
import com.launchdarkly.sdk.server.integrations.FileDataSourceBuilder;
import com.launchdarkly.sdk.server.integrations.FileSynchronizer;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.subsystems.DataSource;
import com.launchdarkly.sdk.server.subsystems.DataSourceUpdateSink;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

final class FileDataSourceImpl
implements DataSource {
    private final DataSourceUpdateSink dataSourceUpdates;
    private final FileSynchronizer synchronizer;
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final LDLogger logger;
    private Thread updateThread;

    FileDataSourceImpl(DataSourceUpdateSink dataSourceUpdates, List<FileDataSourceBuilder.SourceInfo> sources, boolean autoUpdate, FileData.DuplicateKeysHandling duplicateKeysHandling, LDLogger logger, boolean persist) {
        this.dataSourceUpdates = dataSourceUpdates;
        this.logger = logger;
        this.synchronizer = new FileSynchronizer(sources, autoUpdate, duplicateKeysHandling, logger, persist);
    }

    @Override
    public Future<Void> start() {
        FDv2SourceResult initialResult;
        CompletableFuture<Object> initFuture = CompletableFuture.completedFuture(null);
        try {
            initialResult = this.synchronizer.next().get();
        }
        catch (Exception e) {
            this.logger.error("Error getting initial file data: {}", LogValues.exceptionSummary(e));
            this.dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.INTERRUPTED, null);
            return initFuture;
        }
        this.processResult(initialResult);
        this.updateThread = new Thread(this::runUpdateLoop, FileDataSourceImpl.class.getName());
        this.updateThread.setDaemon(true);
        this.updateThread.start();
        return initFuture;
    }

    private void runUpdateLoop() {
        while (!this.closed.get()) {
            try {
                FDv2SourceResult result = this.synchronizer.next().get();
                if (this.closed.get() || result.getResultType() == FDv2SourceResult.ResultType.STATUS && result.getStatus().getState() == FDv2SourceResult.State.SHUTDOWN) break;
                this.processResult(result);
            }
            catch (Exception e) {
                if (this.closed.get()) continue;
                this.logger.warn("Unexpected exception in file data update loop: {}", LogValues.exceptionSummary(e));
            }
        }
    }

    private void processResult(FDv2SourceResult result) {
        if (result.getResultType() == FDv2SourceResult.ResultType.CHANGE_SET) {
            DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> fullData = new DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>(result.getChangeSet().getData(), result.getChangeSet().shouldPersist());
            this.dataSourceUpdates.init(fullData);
            this.dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.VALID, null);
            this.inited.set(true);
        } else if (result.getResultType() == FDv2SourceResult.ResultType.STATUS && result.getStatus().getState() != FDv2SourceResult.State.SHUTDOWN) {
            this.dataSourceUpdates.updateStatus(DataSourceStatusProvider.State.INTERRUPTED, result.getStatus().getErrorInfo());
        }
    }

    @Override
    public boolean isInitialized() {
        return this.inited.get();
    }

    @Override
    public void close() throws IOException {
        this.closed.set(true);
        this.synchronizer.close();
        if (this.updateThread != null) {
            this.updateThread.interrupt();
        }
    }
}

