/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.datasources.Initializer;
import com.launchdarkly.sdk.server.datasources.Synchronizer;
import com.launchdarkly.sdk.server.integrations.FileData;
import com.launchdarkly.sdk.server.integrations.FileDataSourceImpl;
import com.launchdarkly.sdk.server.integrations.FileInitializer;
import com.launchdarkly.sdk.server.integrations.FileSynchronizer;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.DataSource;
import com.launchdarkly.sdk.server.subsystems.DataSourceBuildInputs;
import com.launchdarkly.shaded.com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public final class FileDataSourceBuilder
implements ComponentConfigurer<DataSource> {
    final List<SourceInfo> sources = new ArrayList<SourceInfo>();
    private boolean autoUpdate = false;
    private FileData.DuplicateKeysHandling duplicateKeysHandling = FileData.DuplicateKeysHandling.FAIL;
    private boolean shouldPersist = true;

    public FileDataSourceBuilder filePaths(String ... filePaths) throws InvalidPathException {
        for (String p : filePaths) {
            this.sources.add(new FilePathSourceInfo(Paths.get(p, new String[0])));
        }
        return this;
    }

    public FileDataSourceBuilder filePaths(Path ... filePaths) {
        for (Path p : filePaths) {
            this.sources.add(new FilePathSourceInfo(p));
        }
        return this;
    }

    public FileDataSourceBuilder classpathResources(String ... resourceLocations) {
        for (String location : resourceLocations) {
            this.sources.add(new ClasspathResourceSourceInfo(location));
        }
        return this;
    }

    public FileDataSourceBuilder autoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
        return this;
    }

    public FileDataSourceBuilder duplicateKeysHandling(FileData.DuplicateKeysHandling duplicateKeysHandling) {
        this.duplicateKeysHandling = duplicateKeysHandling;
        return this;
    }

    @Override
    public DataSource build(ClientContext context) {
        LDLogger logger = context.getBaseLogger().subLogger("DataSource");
        return new FileDataSourceImpl(context.getDataSourceUpdateSink(), this.sources, this.autoUpdate, this.duplicateKeysHandling, logger, this.shouldPersist);
    }

    Initializer buildInitializer(DataSourceBuildInputs context) {
        LDLogger logger = context.getBaseLogger().subLogger("FileDataSource.Initializer");
        return new FileInitializer(this.sources, this.duplicateKeysHandling, logger, this.shouldPersist);
    }

    Synchronizer buildSynchronizer(DataSourceBuildInputs context) {
        LDLogger logger = context.getBaseLogger().subLogger("FileDataSource.Synchronizer");
        return new FileSynchronizer(this.sources, this.autoUpdate, this.duplicateKeysHandling, logger, this.shouldPersist);
    }

    public FileDataSourceBuilder shouldPersist(boolean shouldPersist) {
        this.shouldPersist = shouldPersist;
        return this;
    }

    static final class ClasspathResourceSourceInfo
    extends SourceInfo {
        String location;

        ClasspathResourceSourceInfo(String location) {
            this.location = location;
        }

        @Override
        byte[] readData() throws IOException {
            try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.location);){
                if (is == null) {
                    throw new IOException("classpath resource not found");
                }
                byte[] byArray = ByteStreams.toByteArray(is);
                return byArray;
            }
        }

        @Override
        Path toFilePath() {
            return null;
        }

        public String toString() {
            return "classpath:" + this.location;
        }
    }

    static final class FilePathSourceInfo
    extends SourceInfo {
        final Path path;

        FilePathSourceInfo(Path path) {
            this.path = path;
        }

        @Override
        byte[] readData() throws IOException {
            return Files.readAllBytes(this.path);
        }

        @Override
        Path toFilePath() {
            return this.path;
        }

        public String toString() {
            return this.path.toString();
        }
    }

    static abstract class SourceInfo {
        SourceInfo() {
        }

        abstract byte[] readData() throws IOException;

        abstract Path toFilePath();
    }
}

