/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.datasources.FDv2SourceResult;
import com.launchdarkly.sdk.server.integrations.FileData;
import com.launchdarkly.sdk.server.integrations.FileDataSourceBuilder;
import com.launchdarkly.sdk.server.integrations.FileDataSourceParsing;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableList;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.sources.Selector;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class FileDataSourceBase {
    protected final List<FileDataSourceBuilder.SourceInfo> sources;
    protected final FileData.DuplicateKeysHandling duplicateKeysHandling;
    protected final LDLogger logger;
    private final DataLoader dataLoader;
    private final boolean persist;

    protected FileDataSourceBase(List<FileDataSourceBuilder.SourceInfo> sources, FileData.DuplicateKeysHandling duplicateKeysHandling, LDLogger logger, boolean persist) {
        this.sources = new ArrayList<FileDataSourceBuilder.SourceInfo>(sources);
        this.duplicateKeysHandling = duplicateKeysHandling;
        this.logger = logger;
        this.dataLoader = new DataLoader(sources);
        this.persist = persist;
    }

    protected FDv2SourceResult loadData() {
        DataBuilder builder = new DataBuilder(this.duplicateKeysHandling);
        try {
            this.dataLoader.load(builder);
        }
        catch (FileDataSourceParsing.FileDataException e) {
            String description = this.getErrorDescription(e);
            this.logger.error(description);
            DataSourceStatusProvider.ErrorInfo errorInfo = new DataSourceStatusProvider.ErrorInfo(DataSourceStatusProvider.ErrorKind.INVALID_DATA, 0, description, Instant.now());
            return FDv2SourceResult.interrupted(errorInfo, false);
        }
        Iterable<Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>>> data = builder.build();
        DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> changeSet = this.buildChangeSet(data);
        return FDv2SourceResult.changeSet(changeSet, false);
    }

    private DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> buildChangeSet(Iterable<Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>>> data) {
        return new DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor>(DataStoreTypes.ChangeSetType.Full, Selector.EMPTY, data, null, this.persist);
    }

    Iterable<FileDataSourceBuilder.SourceInfo> getSources() {
        return this.sources;
    }

    private String getErrorDescription(FileDataSourceParsing.FileDataException e) {
        StringBuilder s2 = new StringBuilder();
        if (e.getMessage() != null) {
            s2.append(e.getMessage());
        }
        if (e.getCause() != null) {
            if (s2.length() > 0) {
                s2.append(" ");
            }
            s2.append("[").append(e.getCause().toString()).append("]");
        }
        return s2.toString();
    }

    static final class DataBuilder {
        private final Map<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> allData = new HashMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>>();
        private final FileData.DuplicateKeysHandling duplicateKeysHandling;

        public DataBuilder(FileData.DuplicateKeysHandling duplicateKeysHandling) {
            this.duplicateKeysHandling = duplicateKeysHandling;
        }

        public Iterable<Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>>> build() {
            ImmutableList.Builder allBuilder = ImmutableList.builder();
            for (Map.Entry<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> e0 : this.allData.entrySet()) {
                allBuilder.add(new AbstractMap.SimpleEntry(e0.getKey(), new DataStoreTypes.KeyedItems(e0.getValue().entrySet())));
            }
            return allBuilder.build();
        }

        public void add(DataStoreTypes.DataKind kind, String key, DataStoreTypes.ItemDescriptor item) throws FileDataSourceParsing.FileDataException {
            Map items = this.allData.computeIfAbsent(kind, k -> new HashMap());
            if (items.containsKey(key)) {
                if (this.duplicateKeysHandling == FileData.DuplicateKeysHandling.IGNORE) {
                    return;
                }
                throw new FileDataSourceParsing.FileDataException("in " + kind.getName() + ", key \"" + key + "\" was already defined", null, null);
            }
            items.put(key, item);
        }
    }

    static final class DataLoader {
        private final List<FileDataSourceBuilder.SourceInfo> sources;
        private final AtomicInteger lastVersion;

        public DataLoader(List<FileDataSourceBuilder.SourceInfo> sources) {
            this.sources = new ArrayList<FileDataSourceBuilder.SourceInfo>(sources);
            this.lastVersion = new AtomicInteger(0);
        }

        public int load(DataBuilder builder) throws FileDataSourceParsing.FileDataException {
            int version = this.lastVersion.incrementAndGet();
            for (FileDataSourceBuilder.SourceInfo s2 : this.sources) {
                try {
                    byte[] data = s2.readData();
                    FileDataSourceParsing.FlagFileParser parser = FileDataSourceParsing.FlagFileParser.selectForContent(data);
                    FileDataSourceParsing.FlagFileRep fileContents = parser.parse(new ByteArrayInputStream(data));
                    if (fileContents.flags != null) {
                        for (Map.Entry<String, LDValue> e : fileContents.flags.entrySet()) {
                            builder.add(DataModel.FEATURES, e.getKey(), FileDataSourceParsing.FlagFactory.flagFromJson(e.getValue(), version));
                        }
                    }
                    if (fileContents.flagValues != null) {
                        for (Map.Entry<String, LDValue> e : fileContents.flagValues.entrySet()) {
                            builder.add(DataModel.FEATURES, e.getKey(), FileDataSourceParsing.FlagFactory.flagWithValue(e.getKey(), e.getValue(), version));
                        }
                    }
                    if (fileContents.segments == null) continue;
                    for (Map.Entry<String, LDValue> e : fileContents.segments.entrySet()) {
                        builder.add(DataModel.SEGMENTS, e.getKey(), FileDataSourceParsing.FlagFactory.segmentFromJson(e.getValue(), version));
                    }
                }
                catch (FileDataSourceParsing.FileDataException e) {
                    throw new FileDataSourceParsing.FileDataException(e.getMessage(), e.getCause(), s2);
                }
                catch (IOException e) {
                    throw new FileDataSourceParsing.FileDataException(null, e, s2);
                }
            }
            return version;
        }
    }
}

