/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.server.datasources.Initializer;
import com.launchdarkly.sdk.server.datasources.Synchronizer;
import com.launchdarkly.sdk.server.integrations.FileDataSourceBuilder;
import com.launchdarkly.sdk.server.subsystems.DataSourceBuildInputs;
import com.launchdarkly.sdk.server.subsystems.DataSourceBuilder;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;

public abstract class FileData {
    public static FileDataSourceBuilder dataSource() {
        return new FileDataSourceBuilder();
    }

    public static FileInitializerBuilder initializer() {
        return new FileInitializerBuilder();
    }

    public static FileSynchronizerBuilder synchronizer() {
        return new FileSynchronizerBuilder();
    }

    private FileData() {
    }

    public static final class FileSynchronizerBuilder
    implements DataSourceBuilder<Synchronizer> {
        private final FileDataSourceBuilder delegate = new FileDataSourceBuilder();

        FileSynchronizerBuilder() {
            this.delegate.shouldPersist(false);
        }

        public FileSynchronizerBuilder shouldPersist(boolean shouldPersist) {
            this.delegate.shouldPersist(shouldPersist);
            return this;
        }

        public FileSynchronizerBuilder filePaths(String ... filePaths) throws InvalidPathException {
            this.delegate.filePaths(filePaths);
            return this;
        }

        public FileSynchronizerBuilder filePaths(Path ... filePaths) {
            this.delegate.filePaths(filePaths);
            return this;
        }

        public FileSynchronizerBuilder classpathResources(String ... resourceLocations) {
            this.delegate.classpathResources(resourceLocations);
            return this;
        }

        public FileSynchronizerBuilder autoUpdate(boolean autoUpdate) {
            this.delegate.autoUpdate(autoUpdate);
            return this;
        }

        public FileSynchronizerBuilder duplicateKeysHandling(DuplicateKeysHandling duplicateKeysHandling) {
            this.delegate.duplicateKeysHandling(duplicateKeysHandling);
            return this;
        }

        @Override
        public Synchronizer build(DataSourceBuildInputs context) {
            return this.delegate.buildSynchronizer(context);
        }
    }

    public static final class FileInitializerBuilder
    implements DataSourceBuilder<Initializer> {
        private final FileDataSourceBuilder delegate = new FileDataSourceBuilder();

        FileInitializerBuilder() {
            this.delegate.shouldPersist(false);
        }

        public FileInitializerBuilder filePaths(String ... filePaths) throws InvalidPathException {
            this.delegate.filePaths(filePaths);
            return this;
        }

        public FileInitializerBuilder filePaths(Path ... filePaths) {
            this.delegate.filePaths(filePaths);
            return this;
        }

        public FileInitializerBuilder classpathResources(String ... resourceLocations) {
            this.delegate.classpathResources(resourceLocations);
            return this;
        }

        public FileInitializerBuilder duplicateKeysHandling(DuplicateKeysHandling duplicateKeysHandling) {
            this.delegate.duplicateKeysHandling(duplicateKeysHandling);
            return this;
        }

        public FileInitializerBuilder shouldPersist(boolean shouldPersist) {
            this.delegate.shouldPersist(shouldPersist);
            return this;
        }

        @Override
        public Initializer build(DataSourceBuildInputs context) {
            return this.delegate.buildInitializer(context);
        }
    }

    public static enum DuplicateKeysHandling {
        FAIL,
        IGNORE;

    }
}

