/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.StandardEndpoints;
import com.launchdarkly.sdk.server.datasources.Synchronizer;
import com.launchdarkly.sdk.server.integrations.ServiceEndpointsBuilder;
import com.launchdarkly.sdk.server.interfaces.ServiceEndpoints;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.DataSourceBuilder;
import com.launchdarkly.sdk.server.subsystems.DiagnosticDescription;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.DiagnosticConfigProperty;
import java.time.Duration;

public abstract class FDv2StreamingSynchronizerBuilder
implements DataSourceBuilder<Synchronizer>,
DiagnosticDescription {
    public static final Duration DEFAULT_INITIAL_RECONNECT_DELAY = Duration.ofSeconds(1L);
    protected Duration initialReconnectDelay = DEFAULT_INITIAL_RECONNECT_DELAY;
    protected ServiceEndpoints serviceEndpointsOverride;
    protected String payloadFilter;

    public FDv2StreamingSynchronizerBuilder initialReconnectDelay(Duration initialReconnectDelay) {
        this.initialReconnectDelay = initialReconnectDelay != null ? initialReconnectDelay : DEFAULT_INITIAL_RECONNECT_DELAY;
        return this;
    }

    public FDv2StreamingSynchronizerBuilder serviceEndpointsOverride(ServiceEndpointsBuilder serviceEndpointsOverride) {
        this.serviceEndpointsOverride = serviceEndpointsOverride.createServiceEndpoints();
        return this;
    }

    public FDv2StreamingSynchronizerBuilder payloadFilter(String payloadFilter) {
        this.payloadFilter = payloadFilter;
        return this;
    }

    @Override
    public LDValue describeConfiguration(ClientContext context) {
        ServiceEndpoints endpoints = this.serviceEndpointsOverride != null ? this.serviceEndpointsOverride : context.getServiceEndpoints();
        boolean customStreamingBaseUri = StandardEndpoints.isCustomBaseUri(endpoints.getStreamingBaseUri(), StandardEndpoints.DEFAULT_STREAMING_BASE_URI);
        boolean customPollingBaseUri = StandardEndpoints.isCustomBaseUri(endpoints.getPollingBaseUri(), StandardEndpoints.DEFAULT_POLLING_BASE_URI);
        return LDValue.buildObject().put(DiagnosticConfigProperty.STREAMING_DISABLED.name, false).put(DiagnosticConfigProperty.CUSTOM_BASE_URI.name, customPollingBaseUri).put(DiagnosticConfigProperty.CUSTOM_STREAM_URI.name, customStreamingBaseUri).put(DiagnosticConfigProperty.RECONNECT_TIME_MILLIS.name, this.initialReconnectDelay.toMillis()).put(DiagnosticConfigProperty.USING_RELAY_DAEMON.name, false).build();
    }
}

