/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.StandardEndpoints;
import com.launchdarkly.sdk.server.datasources.Synchronizer;
import com.launchdarkly.sdk.server.integrations.ServiceEndpointsBuilder;
import com.launchdarkly.sdk.server.interfaces.ServiceEndpoints;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.DataSourceBuilder;
import com.launchdarkly.sdk.server.subsystems.DiagnosticDescription;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.DiagnosticConfigProperty;
import java.time.Duration;

public abstract class FDv2PollingSynchronizerBuilder
implements DataSourceBuilder<Synchronizer>,
DiagnosticDescription {
    public static final Duration DEFAULT_POLL_INTERVAL = Duration.ofSeconds(30L);
    protected Duration pollInterval = DEFAULT_POLL_INTERVAL;
    protected ServiceEndpoints serviceEndpointsOverride;
    protected String payloadFilter;

    public FDv2PollingSynchronizerBuilder pollInterval(Duration pollInterval) {
        this.pollInterval = pollInterval != null && pollInterval.compareTo(DEFAULT_POLL_INTERVAL) >= 0 ? pollInterval : DEFAULT_POLL_INTERVAL;
        return this;
    }

    FDv2PollingSynchronizerBuilder pollIntervalNoMinimum(Duration pollInterval) {
        this.pollInterval = pollInterval;
        return this;
    }

    public FDv2PollingSynchronizerBuilder serviceEndpointsOverride(ServiceEndpointsBuilder serviceEndpointsOverride) {
        this.serviceEndpointsOverride = serviceEndpointsOverride.createServiceEndpoints();
        return this;
    }

    public FDv2PollingSynchronizerBuilder payloadFilter(String payloadFilter) {
        this.payloadFilter = payloadFilter;
        return this;
    }

    @Override
    public LDValue describeConfiguration(ClientContext context) {
        ServiceEndpoints endpoints = this.serviceEndpointsOverride != null ? this.serviceEndpointsOverride : context.getServiceEndpoints();
        boolean customPollingBaseUri = StandardEndpoints.isCustomBaseUri(endpoints.getPollingBaseUri(), StandardEndpoints.DEFAULT_POLLING_BASE_URI);
        return LDValue.buildObject().put(DiagnosticConfigProperty.STREAMING_DISABLED.name, true).put(DiagnosticConfigProperty.CUSTOM_BASE_URI.name, customPollingBaseUri).put(DiagnosticConfigProperty.POLLING_INTERVAL_MILLIS.name, this.pollInterval.toMillis()).put(DiagnosticConfigProperty.USING_RELAY_DAEMON.name, false).build();
    }
}

