/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.StandardEndpoints;
import com.launchdarkly.sdk.server.datasources.Initializer;
import com.launchdarkly.sdk.server.integrations.ServiceEndpointsBuilder;
import com.launchdarkly.sdk.server.interfaces.ServiceEndpoints;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.DataSourceBuilder;
import com.launchdarkly.sdk.server.subsystems.DiagnosticDescription;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.events.DiagnosticConfigProperty;

public abstract class FDv2PollingInitializerBuilder
implements DataSourceBuilder<Initializer>,
DiagnosticDescription {
    protected ServiceEndpoints serviceEndpointsOverride;
    protected String payloadFilter;

    public FDv2PollingInitializerBuilder serviceEndpointsOverride(ServiceEndpointsBuilder serviceEndpointsOverride) {
        this.serviceEndpointsOverride = serviceEndpointsOverride.createServiceEndpoints();
        return this;
    }

    public FDv2PollingInitializerBuilder payloadFilter(String payloadFilter) {
        this.payloadFilter = payloadFilter;
        return this;
    }

    @Override
    public LDValue describeConfiguration(ClientContext context) {
        ServiceEndpoints endpoints = this.serviceEndpointsOverride != null ? this.serviceEndpointsOverride : context.getServiceEndpoints();
        boolean customPollingBaseUri = StandardEndpoints.isCustomBaseUri(endpoints.getPollingBaseUri(), StandardEndpoints.DEFAULT_POLLING_BASE_URI);
        return LDValue.buildObject().put(DiagnosticConfigProperty.STREAMING_DISABLED.name, true).put(DiagnosticConfigProperty.CUSTOM_BASE_URI.name, customPollingBaseUri).put(DiagnosticConfigProperty.USING_RELAY_DAEMON.name, false).build();
    }
}

