/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.server.DataSystemComponents;
import com.launchdarkly.sdk.server.integrations.DataSystemBuilder;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.DataSystemConfiguration;

public final class DataSystemModes {
    public DataSystemBuilder defaultMode() {
        return this.custom().initializers(DataSystemComponents.pollingInitializer()).synchronizers(DataSystemComponents.streamingSynchronizer(), DataSystemComponents.pollingSynchronizer()).fDv1FallbackSynchronizer(DataSystemComponents.fDv1Polling());
    }

    public DataSystemBuilder streaming() {
        return this.custom().synchronizers(DataSystemComponents.streamingSynchronizer()).fDv1FallbackSynchronizer(DataSystemComponents.fDv1Polling());
    }

    public DataSystemBuilder polling() {
        return this.custom().synchronizers(DataSystemComponents.pollingSynchronizer()).fDv1FallbackSynchronizer(DataSystemComponents.fDv1Polling());
    }

    public DataSystemBuilder daemon(ComponentConfigurer<DataStore> persistentStore) {
        return this.custom().persistentStore(persistentStore, DataSystemConfiguration.DataStoreMode.READ_ONLY);
    }

    public DataSystemBuilder persistentStore(ComponentConfigurer<DataStore> persistentStore) {
        return this.defaultMode().persistentStore(persistentStore, DataSystemConfiguration.DataStoreMode.READ_WRITE);
    }

    public DataSystemBuilder custom() {
        return new DataSystemBuilder();
    }
}

