/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.server.datasources.Initializer;
import com.launchdarkly.sdk.server.datasources.Synchronizer;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.DataSource;
import com.launchdarkly.sdk.server.subsystems.DataSourceBuilder;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.DataSystemConfiguration;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class DataSystemBuilder {
    private final List<DataSourceBuilder<Initializer>> initializers = new ArrayList<DataSourceBuilder<Initializer>>();
    private final List<DataSourceBuilder<Synchronizer>> synchronizers = new ArrayList<DataSourceBuilder<Synchronizer>>();
    private ComponentConfigurer<DataSource> fDv1FallbackSynchronizer;
    private ComponentConfigurer<DataStore> persistentStore;
    private DataSystemConfiguration.DataStoreMode persistentDataStoreMode;

    @SafeVarargs
    public final DataSystemBuilder initializers(DataSourceBuilder<Initializer> ... initializers) {
        this.initializers.addAll(Arrays.asList(initializers));
        return this;
    }

    @SafeVarargs
    public final DataSystemBuilder replaceInitializers(DataSourceBuilder<Initializer> ... initializers) {
        this.initializers.clear();
        this.initializers.addAll(Arrays.asList(initializers));
        return this;
    }

    @SafeVarargs
    public final DataSystemBuilder synchronizers(DataSourceBuilder<Synchronizer> ... synchronizers) {
        this.synchronizers.addAll(Arrays.asList(synchronizers));
        return this;
    }

    @SafeVarargs
    public final DataSystemBuilder replaceSynchronizers(DataSourceBuilder<Synchronizer> ... synchronizers) {
        this.synchronizers.clear();
        this.synchronizers.addAll(Arrays.asList(synchronizers));
        return this;
    }

    public DataSystemBuilder fDv1FallbackSynchronizer(ComponentConfigurer<DataSource> fDv1FallbackSynchronizer) {
        this.fDv1FallbackSynchronizer = fDv1FallbackSynchronizer;
        return this;
    }

    public DataSystemBuilder persistentStore(ComponentConfigurer<DataStore> persistentStore, DataSystemConfiguration.DataStoreMode mode) {
        this.persistentStore = persistentStore;
        this.persistentDataStoreMode = mode;
        return this;
    }

    public DataSystemConfiguration build() {
        return new DataSystemConfiguration(ImmutableList.copyOf(this.initializers), ImmutableList.copyOf(this.synchronizers), this.fDv1FallbackSynchronizer, this.persistentStore, this.persistentDataStoreMode);
    }
}

