/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.datasources;

import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import java.io.Closeable;
import java.util.function.Function;

public class FDv2SourceResult
implements Closeable {
    private final DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> changeSet;
    private final Status status;
    private final ResultType resultType;
    private final boolean fdv1Fallback;
    private final Function<Void, Void> completionCallback;

    private FDv2SourceResult(DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> changeSet, Status status, ResultType resultType, boolean fdv1Fallback, Function<Void, Void> completionCallback) {
        this.changeSet = changeSet;
        this.status = status;
        this.resultType = resultType;
        this.fdv1Fallback = fdv1Fallback;
        this.completionCallback = completionCallback;
    }

    public static FDv2SourceResult interrupted(DataSourceStatusProvider.ErrorInfo errorInfo, boolean fdv1Fallback) {
        return FDv2SourceResult.interrupted(errorInfo, fdv1Fallback, null);
    }

    public static FDv2SourceResult interrupted(DataSourceStatusProvider.ErrorInfo errorInfo, boolean fdv1Fallback, Function<Void, Void> completionCallback) {
        return new FDv2SourceResult(null, Status.interrupted(errorInfo), ResultType.STATUS, fdv1Fallback, completionCallback);
    }

    public static FDv2SourceResult shutdown() {
        return FDv2SourceResult.shutdown(null);
    }

    public static FDv2SourceResult shutdown(Function<Void, Void> completionCallback) {
        return new FDv2SourceResult(null, Status.shutdown(), ResultType.STATUS, false, completionCallback);
    }

    public static FDv2SourceResult terminalError(DataSourceStatusProvider.ErrorInfo errorInfo, boolean fdv1Fallback) {
        return FDv2SourceResult.terminalError(errorInfo, fdv1Fallback, null);
    }

    public static FDv2SourceResult terminalError(DataSourceStatusProvider.ErrorInfo errorInfo, boolean fdv1Fallback, Function<Void, Void> completionCallback) {
        return new FDv2SourceResult(null, Status.terminalError(errorInfo), ResultType.STATUS, fdv1Fallback, completionCallback);
    }

    public static FDv2SourceResult changeSet(DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> changeSet, boolean fdv1Fallback) {
        return FDv2SourceResult.changeSet(changeSet, fdv1Fallback, null);
    }

    public static FDv2SourceResult changeSet(DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> changeSet, boolean fdv1Fallback, Function<Void, Void> completionCallback) {
        return new FDv2SourceResult(changeSet, null, ResultType.CHANGE_SET, fdv1Fallback, completionCallback);
    }

    public static FDv2SourceResult goodbye(String reason, boolean fdv1Fallback) {
        return FDv2SourceResult.goodbye(reason, fdv1Fallback, null);
    }

    public static FDv2SourceResult goodbye(String reason, boolean fdv1Fallback, Function<Void, Void> completionCallback) {
        return new FDv2SourceResult(null, Status.goodbye(reason), ResultType.STATUS, fdv1Fallback, completionCallback);
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public Status getStatus() {
        return this.status;
    }

    public DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> getChangeSet() {
        return this.changeSet;
    }

    public boolean isFdv1Fallback() {
        return this.fdv1Fallback;
    }

    public FDv2SourceResult withCompletion(Function<Void, Void> newCallback) {
        Function<Void, Void> combinedCallback = v -> {
            newCallback.apply(null);
            if (this.completionCallback != null) {
                this.completionCallback.apply(null);
            }
            return null;
        };
        return new FDv2SourceResult(this.changeSet, this.status, this.resultType, this.fdv1Fallback, combinedCallback);
    }

    @Override
    public void close() {
        if (this.completionCallback != null) {
            this.completionCallback.apply(null);
        }
    }

    public static class Status {
        private final State state;
        private final DataSourceStatusProvider.ErrorInfo errorInfo;
        private final String reason;

        public State getState() {
            return this.state;
        }

        public DataSourceStatusProvider.ErrorInfo getErrorInfo() {
            return this.errorInfo;
        }

        Status(State state, DataSourceStatusProvider.ErrorInfo errorInfo, String reason) {
            this.state = state;
            this.errorInfo = errorInfo;
            this.reason = reason;
        }

        public static Status goodbye(String reason) {
            return new Status(State.GOODBYE, null, reason);
        }

        public static Status interrupted(DataSourceStatusProvider.ErrorInfo errorInfo) {
            return new Status(State.INTERRUPTED, errorInfo, null);
        }

        public static Status terminalError(DataSourceStatusProvider.ErrorInfo errorInfo) {
            return new Status(State.TERMINAL_ERROR, errorInfo, null);
        }

        public static Status shutdown() {
            return new Status(State.SHUTDOWN, null, null);
        }

        public String getReason() {
            return this.reason;
        }
    }

    public static enum ResultType {
        CHANGE_SET,
        STATUS;

    }

    public static enum State {
        INTERRUPTED,
        SHUTDOWN,
        TERMINAL_ERROR,
        GOODBYE;

    }
}

