/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.sdk.server.subsystems.DataSystemConfiguration;
import com.launchdarkly.sdk.server.subsystems.TransactionalDataStore;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.sources.Selector;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

final class WriteThroughStore
implements DataStore,
TransactionalDataStore {
    private final DataStore memoryStore;
    private final TransactionalDataStore txMemoryStore;
    private final DataStore persistentStore;
    private final boolean hasPersistence;
    private final DataSystemConfiguration.DataStoreMode persistenceMode;
    private final AtomicBoolean hasReceivedAnInitializingPayload = new AtomicBoolean(false);
    private final Object activeStoreLock = new Object();
    private volatile DataStore activeReadStore;

    WriteThroughStore(DataStore memoryStore, DataStore persistentStore, DataSystemConfiguration.DataStoreMode persistenceMode) {
        this.memoryStore = memoryStore;
        this.txMemoryStore = (TransactionalDataStore)((Object)memoryStore);
        this.persistentStore = persistentStore;
        this.hasPersistence = persistentStore != null;
        this.activeReadStore = this.hasPersistence ? persistentStore : memoryStore;
        this.persistenceMode = persistenceMode;
    }

    @Override
    public void init(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData) {
        this.memoryStore.init(allData);
        this.maybeSwitchStore();
        if (this.hasPersistence && this.persistenceMode == DataSystemConfiguration.DataStoreMode.READ_WRITE && allData.shouldPersist()) {
            this.persistentStore.init(allData);
        }
    }

    @Override
    public DataStoreTypes.ItemDescriptor get(DataStoreTypes.DataKind kind, String key) {
        return this.activeReadStore.get(kind, key);
    }

    @Override
    public DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> getAll(DataStoreTypes.DataKind kind) {
        return this.activeReadStore.getAll(kind);
    }

    @Override
    public boolean upsert(DataStoreTypes.DataKind kind, String key, DataStoreTypes.ItemDescriptor item) {
        boolean result = this.memoryStore.upsert(kind, key, item);
        if (this.hasPersistence && this.persistenceMode == DataSystemConfiguration.DataStoreMode.READ_WRITE) {
            result = result && this.persistentStore.upsert(kind, key, item);
        }
        return result;
    }

    @Override
    public boolean isInitialized() {
        return this.activeReadStore.isInitialized();
    }

    @Override
    public boolean isStatusMonitoringEnabled() {
        return this.hasPersistence ? this.persistentStore.isStatusMonitoringEnabled() : false;
    }

    @Override
    public DataStoreStatusProvider.CacheStats getCacheStats() {
        return this.hasPersistence ? this.persistentStore.getCacheStats() : null;
    }

    @Override
    public void apply(DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> changeSet) {
        this.txMemoryStore.apply(changeSet);
        this.maybeSwitchStore();
        if (!this.hasPersistence || this.persistenceMode != DataSystemConfiguration.DataStoreMode.READ_WRITE || !changeSet.shouldPersist()) {
            return;
        }
        if (this.persistentStore instanceof TransactionalDataStore) {
            ((TransactionalDataStore)((Object)this.persistentStore)).apply(changeSet);
        } else if (!this.applyToLegacyPersistence(changeSet)) {
            throw new RuntimeException("Failure to apply data set to persistent store.");
        }
    }

    @Override
    public Selector getSelector() {
        return this.txMemoryStore.getSelector();
    }

    @Override
    public void close() throws IOException {
        this.memoryStore.close();
        if (this.hasPersistence) {
            this.persistentStore.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeSwitchStore() {
        if (this.hasReceivedAnInitializingPayload.getAndSet(true)) {
            return;
        }
        Object object = this.activeStoreLock;
        synchronized (object) {
            this.activeReadStore = this.memoryStore;
        }
    }

    private boolean applyToLegacyPersistence(DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> sortedChangeSet) {
        switch (sortedChangeSet.getType()) {
            case Full: {
                this.applyFullChangeSetToLegacyStore(sortedChangeSet);
                break;
            }
            case Partial: {
                return this.applyPartialChangeSetToLegacyStore(sortedChangeSet);
            }
        }
        return true;
    }

    private void applyFullChangeSetToLegacyStore(DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> sortedChangeSet) {
        this.persistentStore.init(new DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>(sortedChangeSet.getData(), sortedChangeSet.shouldPersist()));
    }

    private boolean applyPartialChangeSetToLegacyStore(DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> sortedChangeSet) {
        for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> kindItemsPair : sortedChangeSet.getData()) {
            for (Map.Entry<String, DataStoreTypes.ItemDescriptor> item : kindItemsPair.getValue().getItems()) {
                boolean applySuccess = this.persistentStore.upsert(kindItemsPair.getKey(), item.getKey(), item.getValue());
                if (applySuccess) continue;
                return false;
            }
        }
        return true;
    }
}

