/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.FDv2DataSource;
import com.launchdarkly.sdk.server.SynchronizerFactoryWithState;
import com.launchdarkly.sdk.server.datasources.Initializer;
import com.launchdarkly.sdk.server.datasources.Synchronizer;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;

class SourceManager
implements Closeable {
    private final List<SynchronizerFactoryWithState> synchronizers;
    private final List<FDv2DataSource.DataSourceFactory<Initializer>> initializers;
    private final Object activeSourceLock = new Object();
    private Closeable activeSource;
    private boolean isShutdown = false;
    private int synchronizerIndex = -1;
    private int initializerIndex = -1;
    private SynchronizerFactoryWithState currentSynchronizerFactory;

    public SourceManager(List<SynchronizerFactoryWithState> synchronizers, List<FDv2DataSource.DataSourceFactory<Initializer>> initializers) {
        this.synchronizers = synchronizers;
        this.initializers = initializers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSourceIndex() {
        Object object = this.activeSourceLock;
        synchronized (object) {
            this.synchronizerIndex = -1;
        }
    }

    public boolean hasFDv1Fallback() {
        for (SynchronizerFactoryWithState factory2 : this.synchronizers) {
            if (!factory2.isFDv1Fallback()) continue;
            return true;
        }
        return false;
    }

    public void fdv1Fallback() {
        for (SynchronizerFactoryWithState factory2 : this.synchronizers) {
            if (factory2.isFDv1Fallback()) {
                factory2.unblock();
                continue;
            }
            factory2.block();
        }
    }

    private SynchronizerFactoryWithState getNextAvailableSynchronizer() {
        SynchronizerFactoryWithState factory2 = null;
        for (int visited = 0; visited < this.synchronizers.size(); ++visited) {
            SynchronizerFactoryWithState candidate;
            ++this.synchronizerIndex;
            if (this.synchronizerIndex >= this.synchronizers.size()) {
                this.synchronizerIndex = 0;
            }
            if ((candidate = this.synchronizers.get(this.synchronizerIndex)).getState() != SynchronizerFactoryWithState.State.Available) continue;
            factory2 = candidate;
            break;
        }
        return factory2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Synchronizer getNextAvailableSynchronizerAndSetActive() {
        Object object = this.activeSourceLock;
        synchronized (object) {
            if (this.isShutdown) {
                this.currentSynchronizerFactory = null;
                return null;
            }
            SynchronizerFactoryWithState factory2 = this.getNextAvailableSynchronizer();
            if (factory2 == null) {
                this.currentSynchronizerFactory = null;
                return null;
            }
            this.currentSynchronizerFactory = factory2;
            Synchronizer synchronizer = factory2.build();
            if (this.activeSource != null) {
                this.safeClose(this.activeSource);
            }
            this.activeSource = synchronizer;
            return synchronizer;
        }
    }

    public boolean hasAvailableSources() {
        return this.hasInitializers() || this.getAvailableSynchronizerCount() > 0;
    }

    public boolean hasInitializers() {
        return !this.initializers.isEmpty();
    }

    public boolean hasAvailableSynchronizers() {
        return this.getAvailableSynchronizerCount() > 0;
    }

    private FDv2DataSource.DataSourceFactory<Initializer> getNextInitializer() {
        ++this.initializerIndex;
        if (this.initializerIndex >= this.initializers.size()) {
            return null;
        }
        return this.initializers.get(this.initializerIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockCurrentSynchronizer() {
        Object object = this.activeSourceLock;
        synchronized (object) {
            if (this.currentSynchronizerFactory != null) {
                this.currentSynchronizerFactory.block();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCurrentSynchronizerFDv1Fallback() {
        Object object = this.activeSourceLock;
        synchronized (object) {
            return this.currentSynchronizerFactory != null && this.currentSynchronizerFactory.isFDv1Fallback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Initializer getNextInitializerAndSetActive() {
        Object object = this.activeSourceLock;
        synchronized (object) {
            if (this.isShutdown) {
                return null;
            }
            FDv2DataSource.DataSourceFactory<Initializer> factory2 = this.getNextInitializer();
            if (factory2 == null) {
                return null;
            }
            Initializer initializer = factory2.build();
            if (this.activeSource != null) {
                this.safeClose(this.activeSource);
            }
            this.activeSource = initializer;
            return initializer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPrimeSynchronizer() {
        Object object = this.activeSourceLock;
        synchronized (object) {
            for (int index = 0; index < this.synchronizers.size(); ++index) {
                if (this.synchronizers.get(index).getState() != SynchronizerFactoryWithState.State.Available) continue;
                if (this.synchronizerIndex != index) break;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailableSynchronizerCount() {
        Object object = this.activeSourceLock;
        synchronized (object) {
            int count = 0;
            for (int index = 0; index < this.synchronizers.size(); ++index) {
                if (this.synchronizers.get(index).getState() != SynchronizerFactoryWithState.State.Available) continue;
                ++count;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.activeSourceLock;
        synchronized (object) {
            this.isShutdown = true;
            if (this.activeSource != null) {
                try {
                    this.activeSource.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.activeSource = null;
            }
        }
    }

    private void safeClose(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

