/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.FDv2Requestor;
import com.launchdarkly.sdk.server.PollingBase;
import com.launchdarkly.sdk.server.datasources.FDv2SourceResult;
import com.launchdarkly.sdk.server.datasources.SelectorSource;
import com.launchdarkly.sdk.server.datasources.Synchronizer;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.collections.IterableAsyncQueue;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class PollingSynchronizerImpl
extends PollingBase
implements Synchronizer {
    private final CompletableFuture<FDv2SourceResult> shutdownFuture = new CompletableFuture();
    private final SelectorSource selectorSource;
    private final ScheduledFuture<?> task;
    private final IterableAsyncQueue<FDv2SourceResult> resultQueue = new IterableAsyncQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PollingSynchronizerImpl(FDv2Requestor requestor, LDLogger logger, SelectorSource selectorSource, ScheduledExecutorService sharedExecutor, Duration pollInterval) {
        super(requestor, logger.subLogger("PollingSynchronizer"));
        this.selectorSource = selectorSource;
        PollingSynchronizerImpl pollingSynchronizerImpl = this;
        synchronized (pollingSynchronizerImpl) {
            this.task = sharedExecutor.scheduleAtFixedRate(this::doPoll, 0L, pollInterval.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPoll() {
        try {
            FDv2SourceResult res = this.poll(this.selectorSource.getSelector(), false).get();
            boolean shouldShutdown = false;
            block3 : switch (res.getResultType()) {
                case CHANGE_SET: {
                    break;
                }
                case STATUS: {
                    switch (res.getStatus().getState()) {
                        case INTERRUPTED: {
                            break block3;
                        }
                        case SHUTDOWN: {
                            break block3;
                        }
                        case TERMINAL_ERROR: {
                            PollingSynchronizerImpl pollingSynchronizerImpl = this;
                            synchronized (pollingSynchronizerImpl) {
                                this.task.cancel(true);
                            }
                            this.internalShutdown();
                            shouldShutdown = true;
                            break block3;
                        }
                    }
                }
            }
            if (shouldShutdown) {
                this.shutdownFuture.complete(res);
            } else {
                this.resultQueue.put(res);
            }
        }
        catch (InterruptedException e) {
            this.logger.debug("Polling thread interrupted: {}", (Object)e.toString());
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            this.logger.debug("Polling thread execution exception: {}", (Object)e.toString());
        }
    }

    @Override
    public CompletableFuture<FDv2SourceResult> next() {
        return CompletableFuture.anyOf(this.shutdownFuture, this.resultQueue.take()).thenApply(result -> (FDv2SourceResult)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.shutdownFuture.complete(FDv2SourceResult.shutdown());
        PollingSynchronizerImpl pollingSynchronizerImpl = this;
        synchronized (pollingSynchronizerImpl) {
            this.task.cancel(true);
        }
        this.internalShutdown();
    }
}

