/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.json.SerializationException;
import com.launchdarkly.sdk.server.FDv2ChangeSetTranslator;
import com.launchdarkly.sdk.server.FDv2Requestor;
import com.launchdarkly.sdk.server.HeaderConstants;
import com.launchdarkly.sdk.server.datasources.FDv2SourceResult;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.payloads.FDv2Event;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.sources.FDv2ProtocolHandler;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.sources.Selector;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.http.HttpErrors;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.CompletableFuture;

class PollingBase {
    private final FDv2Requestor requestor;
    protected final LDLogger logger;

    public PollingBase(FDv2Requestor requestor, LDLogger logger) {
        this.requestor = requestor;
        this.logger = logger;
    }

    protected void internalShutdown() {
        this.requestor.close();
    }

    private static boolean getFallback(FDv2Requestor.FDv2PayloadResponse response) {
        if (response != null && response.getHeaders() != null) {
            String headerValue = response.getHeaders().get(HeaderConstants.FDV1_FALLBACK.getHeaderName());
            return headerValue != null && headerValue.equalsIgnoreCase("true");
        }
        return false;
    }

    private static String getEnvironmentId(FDv2Requestor.FDv2PayloadResponse response) {
        if (response != null && response.getHeaders() != null) {
            return response.getHeaders().get(HeaderConstants.ENVIRONMENT_ID.getHeaderName());
        }
        return null;
    }

    protected CompletableFuture<FDv2SourceResult> poll(Selector selector, boolean oneShot) {
        return this.requestor.Poll(selector).handle((pollingResponse, ex) -> {
            boolean fdv1Fallback = PollingBase.getFallback(pollingResponse);
            String environmentId = PollingBase.getEnvironmentId(pollingResponse);
            if (ex != null) {
                if (ex instanceof IOException) {
                    IOException e = (IOException)ex;
                    this.logger.error("Polling request failed with network error: {}", (Object)e.toString());
                    DataSourceStatusProvider.ErrorInfo info = new DataSourceStatusProvider.ErrorInfo(DataSourceStatusProvider.ErrorKind.NETWORK_ERROR, 0, e.toString(), new Date().toInstant());
                    return oneShot ? FDv2SourceResult.terminalError(info, fdv1Fallback) : FDv2SourceResult.interrupted(info, fdv1Fallback);
                }
                if (ex instanceof SerializationException) {
                    SerializationException e = (SerializationException)ex;
                    this.logger.error("Polling request received malformed data: {}", (Object)e.toString());
                    DataSourceStatusProvider.ErrorInfo info = new DataSourceStatusProvider.ErrorInfo(DataSourceStatusProvider.ErrorKind.INVALID_DATA, 0, e.toString(), new Date().toInstant());
                    return oneShot ? FDv2SourceResult.terminalError(info, fdv1Fallback) : FDv2SourceResult.interrupted(info, fdv1Fallback);
                }
                String msg = ex.toString();
                this.logger.error("Polling request failed with an unknown error: {}", (Object)msg);
                DataSourceStatusProvider.ErrorInfo info = new DataSourceStatusProvider.ErrorInfo(DataSourceStatusProvider.ErrorKind.UNKNOWN, 0, msg, new Date().toInstant());
                return oneShot ? FDv2SourceResult.terminalError(info, fdv1Fallback) : FDv2SourceResult.interrupted(info, fdv1Fallback);
            }
            if (pollingResponse.getStatusCode() == 304) {
                return FDv2SourceResult.changeSet(new DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor>(DataStoreTypes.ChangeSetType.None, Selector.EMPTY, null, null, true), false);
            }
            if (!pollingResponse.isSuccess()) {
                int statusCode = pollingResponse.getStatusCode();
                boolean recoverable = statusCode <= 0 || HttpErrors.isHttpErrorRecoverable(statusCode);
                DataSourceStatusProvider.ErrorInfo errorInfo = DataSourceStatusProvider.ErrorInfo.fromHttpError(statusCode);
                this.logger.error("Polling request failed with HTTP error: {}", (Object)statusCode);
                if (oneShot) {
                    return FDv2SourceResult.terminalError(errorInfo, fdv1Fallback);
                }
                return recoverable ? FDv2SourceResult.interrupted(errorInfo, fdv1Fallback) : FDv2SourceResult.terminalError(errorInfo, fdv1Fallback);
            }
            FDv2ProtocolHandler handler = new FDv2ProtocolHandler();
            for (FDv2Event event : pollingResponse.getEvents()) {
                FDv2ProtocolHandler.IFDv2ProtocolAction res = handler.handleEvent(event);
                switch (res.getAction()) {
                    case CHANGESET: {
                        try {
                            DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> converted = FDv2ChangeSetTranslator.toChangeSet(((FDv2ProtocolHandler.FDv2ActionChangeset)res).getChangeset(), this.logger, environmentId, true);
                            return FDv2SourceResult.changeSet(converted, fdv1Fallback);
                        }
                        catch (Exception e) {
                            DataSourceStatusProvider.ErrorInfo info = new DataSourceStatusProvider.ErrorInfo(DataSourceStatusProvider.ErrorKind.INVALID_DATA, 0, e.toString(), new Date().toInstant());
                            return oneShot ? FDv2SourceResult.terminalError(info, fdv1Fallback) : FDv2SourceResult.interrupted(info, fdv1Fallback);
                        }
                    }
                    case ERROR: {
                        FDv2ProtocolHandler.FDv2ActionError error = (FDv2ProtocolHandler.FDv2ActionError)res;
                        DataSourceStatusProvider.ErrorInfo info = new DataSourceStatusProvider.ErrorInfo(DataSourceStatusProvider.ErrorKind.UNKNOWN, 0, error.getReason(), new Date().toInstant());
                        return oneShot ? FDv2SourceResult.terminalError(info, fdv1Fallback) : FDv2SourceResult.interrupted(info, fdv1Fallback);
                    }
                    case GOODBYE: {
                        String reason = ((FDv2ProtocolHandler.FDv2ActionGoodbye)res).getReason();
                        this.logger.info("Goodbye was received from the LaunchDarkly connection with reason: '{}'.", (Object)reason);
                        return FDv2SourceResult.goodbye(reason, fdv1Fallback);
                    }
                    case NONE: {
                        break;
                    }
                    case INTERNAL_ERROR: {
                        FDv2ProtocolHandler.FDv2ActionInternalError internalErrorAction = (FDv2ProtocolHandler.FDv2ActionInternalError)res;
                        DataSourceStatusProvider.ErrorKind kind = DataSourceStatusProvider.ErrorKind.UNKNOWN;
                        switch (internalErrorAction.getErrorType()) {
                            case MISSING_PAYLOAD: 
                            case JSON_ERROR: {
                                kind = DataSourceStatusProvider.ErrorKind.INVALID_DATA;
                                break;
                            }
                        }
                        DataSourceStatusProvider.ErrorInfo info = new DataSourceStatusProvider.ErrorInfo(kind, 0, "Internal error occurred during polling", new Date().toInstant());
                        return oneShot ? FDv2SourceResult.terminalError(info, fdv1Fallback) : FDv2SourceResult.interrupted(info, fdv1Fallback);
                    }
                }
            }
            DataSourceStatusProvider.ErrorInfo info = new DataSourceStatusProvider.ErrorInfo(DataSourceStatusProvider.ErrorKind.UNKNOWN, 0, "Unexpected end of polling response", new Date().toInstant());
            return oneShot ? FDv2SourceResult.terminalError(info, fdv1Fallback) : FDv2SourceResult.interrupted(info, fdv1Fallback);
        });
    }
}

