/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.LogValues;
import com.launchdarkly.sdk.server.CacheExporter;
import com.launchdarkly.sdk.server.PersistentDataStoreConverter;
import com.launchdarkly.sdk.server.PersistentDataStoreStatusManager;
import com.launchdarkly.sdk.server.SettableCache;
import com.launchdarkly.sdk.server.integrations.PersistentDataStoreBuilder;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.sdk.server.subsystems.DataStoreUpdateSink;
import com.launchdarkly.sdk.server.subsystems.PersistentDataStore;
import com.launchdarkly.shaded.com.google.common.base.Optional;
import com.launchdarkly.shaded.com.google.common.cache.CacheBuilder;
import com.launchdarkly.shaded.com.google.common.cache.CacheLoader;
import com.launchdarkly.shaded.com.google.common.cache.CacheStats;
import com.launchdarkly.shaded.com.google.common.cache.LoadingCache;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableList;
import com.launchdarkly.shaded.com.google.common.collect.Iterables;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import com.launchdarkly.shaded.com.google.common.util.concurrent.MoreExecutors;
import com.launchdarkly.shaded.com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.IOException;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

final class PersistentDataStoreWrapper
implements DataStore,
SettableCache {
    private final PersistentDataStore core;
    private final LoadingCache<CacheKey, Optional<DataStoreTypes.ItemDescriptor>> itemCache;
    private final LoadingCache<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> allCache;
    private final LoadingCache<String, Boolean> initCache;
    private final PersistentDataStoreStatusManager statusManager;
    private final boolean cacheIndefinitely;
    private final Set<DataStoreTypes.DataKind> cachedDataKinds = new HashSet<DataStoreTypes.DataKind>();
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private final ListeningExecutorService cacheExecutor;
    private final LDLogger logger;
    private final Object externalStoreLock = new Object();
    private volatile CacheExporter externalCache;

    PersistentDataStoreWrapper(final PersistentDataStore core, Duration cacheTtl, PersistentDataStoreBuilder.StaleValuesPolicy staleValuesPolicy, boolean recordCacheStats, DataStoreUpdateSink dataStoreUpdates, ScheduledExecutorService sharedExecutor, LDLogger logger) {
        this.core = core;
        this.logger = logger;
        if (cacheTtl.isZero()) {
            this.itemCache = null;
            this.allCache = null;
            this.initCache = null;
            this.cacheExecutor = null;
            this.cacheIndefinitely = false;
        } else {
            this.cacheIndefinitely = cacheTtl.isNegative();
            CacheLoader<CacheKey, Optional<DataStoreTypes.ItemDescriptor>> itemLoader = new CacheLoader<CacheKey, Optional<DataStoreTypes.ItemDescriptor>>(){

                @Override
                public Optional<DataStoreTypes.ItemDescriptor> load(CacheKey key) throws Exception {
                    return Optional.fromNullable(PersistentDataStoreWrapper.this.getAndDeserializeItem(key.kind, key.key));
                }
            };
            CacheLoader<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> allLoader = new CacheLoader<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>>(){

                @Override
                public DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> load(DataStoreTypes.DataKind kind) throws Exception {
                    return PersistentDataStoreWrapper.this.getAllAndDeserialize(kind);
                }
            };
            CacheLoader<String, Boolean> initLoader = new CacheLoader<String, Boolean>(){

                @Override
                public Boolean load(String key) throws Exception {
                    return core.isInitialized();
                }
            };
            if (staleValuesPolicy == PersistentDataStoreBuilder.StaleValuesPolicy.REFRESH_ASYNC) {
                this.cacheExecutor = MoreExecutors.listeningDecorator(sharedExecutor);
                itemLoader = CacheLoader.asyncReloading(itemLoader, this.cacheExecutor);
            } else {
                this.cacheExecutor = null;
            }
            this.itemCache = PersistentDataStoreWrapper.newCacheBuilder(cacheTtl, staleValuesPolicy, recordCacheStats).build(itemLoader);
            this.allCache = PersistentDataStoreWrapper.newCacheBuilder(cacheTtl, staleValuesPolicy, recordCacheStats).build(allLoader);
            this.initCache = PersistentDataStoreWrapper.newCacheBuilder(cacheTtl, staleValuesPolicy, recordCacheStats).build(initLoader);
        }
        this.statusManager = new PersistentDataStoreStatusManager(!this.cacheIndefinitely, true, this::pollAvailabilityAfterOutage, dataStoreUpdates::updateStatus, sharedExecutor, logger);
    }

    private static CacheBuilder<Object, Object> newCacheBuilder(Duration cacheTtl, PersistentDataStoreBuilder.StaleValuesPolicy staleValuesPolicy, boolean recordCacheStats) {
        CacheBuilder<Object, Object> builder = CacheBuilder.newBuilder();
        boolean isInfiniteTtl = cacheTtl.isNegative();
        if (!isInfiniteTtl) {
            builder = staleValuesPolicy == PersistentDataStoreBuilder.StaleValuesPolicy.EVICT ? builder.expireAfterWrite(cacheTtl) : builder.refreshAfterWrite(cacheTtl);
        }
        if (recordCacheStats) {
            builder = builder.recordStats();
        }
        return builder;
    }

    @Override
    public void close() throws IOException {
        this.statusManager.close();
        this.core.close();
    }

    @Override
    public boolean isInitialized() {
        boolean result;
        if (this.inited.get()) {
            return true;
        }
        try {
            result = this.initCache != null ? this.initCache.get("").booleanValue() : this.core.isInitialized();
        }
        catch (Exception e) {
            result = false;
        }
        if (result) {
            this.inited.set(true);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData) {
        Set<DataStoreTypes.DataKind> set = this.cachedDataKinds;
        synchronized (set) {
            this.cachedDataKinds.clear();
            for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> e : allData.getData()) {
                this.cachedDataKinds.add(e.getKey());
            }
        }
        ImmutableList.Builder allBuilder = ImmutableList.builder();
        for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> e0 : allData.getData()) {
            DataStoreTypes.DataKind kind = e0.getKey();
            DataStoreTypes.KeyedItems<DataStoreTypes.SerializedItemDescriptor> items = PersistentDataStoreConverter.serializeAll(kind, e0.getValue());
            allBuilder.add(new AbstractMap.SimpleEntry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.SerializedItemDescriptor>>(kind, items));
        }
        RuntimeException failure = this.initCore(new DataStoreTypes.FullDataSet<DataStoreTypes.SerializedItemDescriptor>(allBuilder.build(), allData.shouldPersist()));
        if (this.itemCache != null && this.allCache != null) {
            this.itemCache.invalidateAll();
            this.allCache.invalidateAll();
            if (failure != null && !this.cacheIndefinitely) {
                throw failure;
            }
            for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> e0 : allData.getData()) {
                DataStoreTypes.DataKind kind = e0.getKey();
                DataStoreTypes.KeyedItems immutableItems = new DataStoreTypes.KeyedItems(ImmutableList.copyOf(e0.getValue().getItems()));
                this.allCache.put(kind, immutableItems);
                for (Map.Entry<String, DataStoreTypes.ItemDescriptor> e1 : e0.getValue().getItems()) {
                    this.itemCache.put(CacheKey.forItem(kind, e1.getKey()), Optional.of(e1.getValue()));
                }
            }
        }
        if (failure == null || this.cacheIndefinitely) {
            this.inited.set(true);
        }
        if (failure != null) {
            throw failure;
        }
    }

    private RuntimeException initCore(DataStoreTypes.FullDataSet<DataStoreTypes.SerializedItemDescriptor> allData) {
        try {
            this.core.init(allData);
            this.processError(null);
            return null;
        }
        catch (RuntimeException e) {
            this.processError(e);
            return e;
        }
    }

    @Override
    public DataStoreTypes.ItemDescriptor get(DataStoreTypes.DataKind kind, String key) {
        try {
            DataStoreTypes.ItemDescriptor ret = this.itemCache != null ? this.itemCache.get(CacheKey.forItem(kind, key)).orNull() : this.getAndDeserializeItem(kind, key);
            this.processError(null);
            return ret;
        }
        catch (Exception e) {
            this.processError(e);
            throw PersistentDataStoreWrapper.getAsRuntimeException(e);
        }
    }

    @Override
    public DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> getAll(DataStoreTypes.DataKind kind) {
        try {
            DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> ret = this.allCache != null ? this.allCache.get(kind) : this.getAllAndDeserialize(kind);
            this.processError(null);
            return ret;
        }
        catch (Exception e) {
            this.processError(e);
            throw PersistentDataStoreWrapper.getAsRuntimeException(e);
        }
    }

    private static RuntimeException getAsRuntimeException(Exception e) {
        Throwable t2 = e instanceof ExecutionException || e instanceof UncheckedExecutionException ? e.getCause() : e;
        return t2 instanceof RuntimeException ? (RuntimeException)t2 : new RuntimeException(t2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean upsert(DataStoreTypes.DataKind kind, String key, DataStoreTypes.ItemDescriptor item) {
        Set<DataStoreTypes.DataKind> set = this.cachedDataKinds;
        synchronized (set) {
            this.cachedDataKinds.add(kind);
        }
        DataStoreTypes.SerializedItemDescriptor serializedItem = PersistentDataStoreConverter.serialize(kind, item);
        boolean updated = false;
        RuntimeException failure = null;
        try {
            updated = this.core.upsert(kind, key, serializedItem);
            this.processError(null);
        }
        catch (RuntimeException e) {
            this.processError(e);
            if (!this.cacheIndefinitely) {
                throw e;
            }
            failure = e;
        }
        if (this.itemCache != null) {
            CacheKey cacheKey = CacheKey.forItem(kind, key);
            if (failure == null) {
                if (updated) {
                    this.itemCache.put(cacheKey, Optional.of(item));
                } else {
                    this.itemCache.refresh(cacheKey);
                }
            } else {
                Optional oldItem = (Optional)this.itemCache.getIfPresent(cacheKey);
                if (oldItem == null || !oldItem.isPresent() || ((DataStoreTypes.ItemDescriptor)oldItem.get()).getVersion() < item.getVersion()) {
                    this.itemCache.put(cacheKey, Optional.of(item));
                }
            }
        }
        if (this.allCache != null) {
            if (this.cacheIndefinitely) {
                DataStoreTypes.KeyedItems cachedAll = (DataStoreTypes.KeyedItems)this.allCache.getIfPresent(kind);
                this.allCache.put(kind, this.updateSingleItem(cachedAll, key, item));
            } else {
                this.allCache.invalidate(kind);
            }
        }
        if (failure != null) {
            throw failure;
        }
        return updated;
    }

    @Override
    public boolean isStatusMonitoringEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCacheExporter(CacheExporter externalDataSource) {
        Object object = this.externalStoreLock;
        synchronized (object) {
            this.externalCache = externalDataSource;
        }
    }

    @Override
    public DataStoreStatusProvider.CacheStats getCacheStats() {
        if (this.itemCache == null || this.allCache == null) {
            return null;
        }
        CacheStats itemStats = this.itemCache.stats();
        CacheStats allStats = this.allCache.stats();
        return new DataStoreStatusProvider.CacheStats(itemStats.hitCount() + allStats.hitCount(), itemStats.missCount() + allStats.missCount(), itemStats.loadSuccessCount() + allStats.loadSuccessCount(), itemStats.loadExceptionCount() + allStats.loadExceptionCount(), itemStats.totalLoadTime() + allStats.totalLoadTime(), itemStats.evictionCount() + allStats.evictionCount());
    }

    private DataStoreTypes.ItemDescriptor getAndDeserializeItem(DataStoreTypes.DataKind kind, String key) {
        DataStoreTypes.SerializedItemDescriptor maybeSerializedItem = this.core.get(kind, key);
        return maybeSerializedItem == null ? null : PersistentDataStoreConverter.deserialize(kind, maybeSerializedItem);
    }

    private DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> getAllAndDeserialize(DataStoreTypes.DataKind kind) {
        DataStoreTypes.KeyedItems<DataStoreTypes.SerializedItemDescriptor> allItems = this.core.getAll(kind);
        if (Iterables.isEmpty(allItems.getItems())) {
            return new DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>(null);
        }
        ImmutableList.Builder b = ImmutableList.builder();
        for (Map.Entry<String, DataStoreTypes.SerializedItemDescriptor> e : allItems.getItems()) {
            b.add(new AbstractMap.SimpleEntry<String, DataStoreTypes.ItemDescriptor>(e.getKey(), PersistentDataStoreConverter.deserialize(kind, e.getValue())));
        }
        return new DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>(b.build());
    }

    private DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> updateSingleItem(DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> items, String key, DataStoreTypes.ItemDescriptor item) {
        return new DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>(ImmutableList.copyOf(Iterables.concat(items == null ? ImmutableList.of() : Iterables.filter(items.getItems(), e -> !((String)e.getKey()).equals(key)), ImmutableList.of(new AbstractMap.SimpleEntry<String, DataStoreTypes.ItemDescriptor>(key, item)))));
    }

    private void processError(Throwable error) {
        if (error == null) {
            return;
        }
        this.statusManager.updateAvailability(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pollAvailabilityAfterOutage() {
        CacheExporter externalCacheSnapshot;
        if (!this.core.isStoreAvailable()) {
            return false;
        }
        Object object = this.externalStoreLock;
        synchronized (object) {
            externalCacheSnapshot = this.externalCache;
        }
        if (externalCacheSnapshot != null && externalCacheSnapshot.isInitialized()) {
            try {
                DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> externalData = externalCacheSnapshot.exportAll();
                if (!externalData.shouldPersist()) {
                    this.logger.debug("Skipping persistence of non-authoritative data (shouldPersist=false) during recovery");
                    return true;
                }
                DataStoreTypes.FullDataSet<DataStoreTypes.SerializedItemDescriptor> serializedData = PersistentDataStoreConverter.toSerializedFormat(externalData);
                RuntimeException runtimeException = this.initCore(serializedData);
                if (runtimeException != null) {
                    this.logger.error("Tried to write external data to persistent store after outage, but failed: {}", LogValues.exceptionSummary(runtimeException));
                    this.logger.debug(LogValues.exceptionTrace(runtimeException));
                    return false;
                }
                this.logger.warn("Successfully updated persistent store from external data source");
            }
            catch (Exception ex) {
                this.logger.error("Failed to export data from external source during persistent store recovery: {}", LogValues.exceptionSummary(ex));
                this.logger.debug(LogValues.exceptionTrace(ex));
                return false;
            }
            return true;
        }
        if (this.cacheIndefinitely && this.allCache != null) {
            DataStoreTypes.DataKind[] allKinds;
            Set<DataStoreTypes.DataKind> serializedData = this.cachedDataKinds;
            synchronized (serializedData) {
                allKinds = this.cachedDataKinds.toArray(new DataStoreTypes.DataKind[this.cachedDataKinds.size()]);
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            for (DataStoreTypes.DataKind kind : allKinds) {
                DataStoreTypes.KeyedItems items = (DataStoreTypes.KeyedItems)this.allCache.getIfPresent(kind);
                if (items == null) continue;
                builder.add(new AbstractMap.SimpleEntry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.SerializedItemDescriptor>>(kind, PersistentDataStoreConverter.serializeAll(kind, items)));
            }
            RuntimeException runtimeException = this.initCore(new DataStoreTypes.FullDataSet<DataStoreTypes.SerializedItemDescriptor>(builder.build(), true));
            if (runtimeException == null) {
                this.logger.warn("Successfully updated persistent store from cached data");
            } else {
                this.logger.error("Tried to write cached data to persistent store after a store outage, but failed: {}", LogValues.exceptionSummary(runtimeException));
                this.logger.debug(LogValues.exceptionTrace(runtimeException));
                return false;
            }
        }
        return true;
    }

    static final class CacheKey {
        final DataStoreTypes.DataKind kind;
        final String key;

        public static CacheKey forItem(DataStoreTypes.DataKind kind, String key) {
            return new CacheKey(kind, key);
        }

        private CacheKey(DataStoreTypes.DataKind kind, String key) {
            this.kind = kind;
            this.key = key;
        }

        public boolean equals(Object other) {
            if (other instanceof CacheKey) {
                CacheKey o = (CacheKey)other;
                return o.kind.getName().equals(this.kind.getName()) && o.key.equals(this.key);
            }
            return false;
        }

        public int hashCode() {
            return this.kind.getName().hashCode() * 31 + this.key.hashCode();
        }
    }
}

