/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableList;
import java.util.AbstractMap;
import java.util.Map;

final class PersistentDataStoreConverter {
    private PersistentDataStoreConverter() {
    }

    static DataStoreTypes.FullDataSet<DataStoreTypes.SerializedItemDescriptor> toSerializedFormat(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> inMemoryData) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> kindEntry : inMemoryData.getData()) {
            DataStoreTypes.DataKind kind = kindEntry.getKey();
            DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> items = kindEntry.getValue();
            builder.add(new AbstractMap.SimpleEntry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.SerializedItemDescriptor>>(kind, PersistentDataStoreConverter.serializeAll(kind, items)));
        }
        return new DataStoreTypes.FullDataSet<DataStoreTypes.SerializedItemDescriptor>(builder.build(), inMemoryData.shouldPersist());
    }

    static DataStoreTypes.SerializedItemDescriptor serialize(DataStoreTypes.DataKind kind, DataStoreTypes.ItemDescriptor itemDesc) {
        boolean isDeleted = itemDesc.getItem() == null;
        return new DataStoreTypes.SerializedItemDescriptor(itemDesc.getVersion(), isDeleted, kind.serialize(itemDesc));
    }

    static DataStoreTypes.KeyedItems<DataStoreTypes.SerializedItemDescriptor> serializeAll(DataStoreTypes.DataKind kind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> items) {
        ImmutableList.Builder itemsBuilder = ImmutableList.builder();
        for (Map.Entry<String, DataStoreTypes.ItemDescriptor> e : items.getItems()) {
            itemsBuilder.add(new AbstractMap.SimpleEntry<String, DataStoreTypes.SerializedItemDescriptor>(e.getKey(), PersistentDataStoreConverter.serialize(kind, e.getValue())));
        }
        return new DataStoreTypes.KeyedItems<DataStoreTypes.SerializedItemDescriptor>(itemsBuilder.build());
    }

    static DataStoreTypes.ItemDescriptor deserialize(DataStoreTypes.DataKind kind, DataStoreTypes.SerializedItemDescriptor serializedItemDesc) {
        if (serializedItemDesc.isDeleted() || serializedItemDesc.getSerializedItem() == null) {
            return DataStoreTypes.ItemDescriptor.deletedItem(serializedItemDesc.getVersion());
        }
        DataStoreTypes.ItemDescriptor deserializedItem = kind.deserialize(serializedItemDesc.getSerializedItem());
        if (serializedItemDesc.getVersion() == 0 || serializedItemDesc.getVersion() == deserializedItem.getVersion() || deserializedItem.getItem() == null) {
            return deserializedItem;
        }
        return new DataStoreTypes.ItemDescriptor(serializedItemDesc.getVersion(), deserializedItem.getItem());
    }
}

