/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.logging.LogValues;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.LDValueType;
import com.launchdarkly.sdk.server.BigSegmentStoreWrapper;
import com.launchdarkly.sdk.server.DataModel;
import com.launchdarkly.sdk.server.EvalResult;
import com.launchdarkly.sdk.server.EvalResultAndFlag;
import com.launchdarkly.sdk.server.EvaluationOptions;
import com.launchdarkly.sdk.server.EvaluationRecorder;
import com.launchdarkly.sdk.server.Evaluator;
import com.launchdarkly.sdk.server.EvaluatorInterface;
import com.launchdarkly.sdk.server.FeatureFlagsState;
import com.launchdarkly.sdk.server.FlagsStateOption;
import com.launchdarkly.sdk.server.ReadOnlyStore;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.sdk.server.subsystems.EventProcessor;
import com.launchdarkly.shaded.javax.annotation.Nonnull;
import com.launchdarkly.shaded.javax.annotation.Nullable;
import java.util.Map;

class InputValidatingEvaluator
implements EvaluatorInterface {
    private final Evaluator evaluator;
    private final ReadOnlyStore store;
    private final LDLogger logger;
    private final EvaluationRecorder evaluationEventRecorderWithDetails;
    private final EvaluationRecorder evaluationEventRecorderWithoutDetails;
    static final EvaluationRecorder NO_OP_EVALUATION_EVENT_RECORDER = new EvaluationRecorder(){};

    InputValidatingEvaluator(final ReadOnlyStore store, final BigSegmentStoreWrapper segmentStore, @Nonnull EventProcessor eventProcessor, LDLogger logger) {
        this.evaluator = new Evaluator(new Evaluator.Getters(){

            @Override
            public DataModel.FeatureFlag getFlag(String key) {
                return InputValidatingEvaluator.getFlag(store, key);
            }

            @Override
            public DataModel.Segment getSegment(String key) {
                return InputValidatingEvaluator.getSegment(store, key);
            }

            @Override
            public BigSegmentStoreWrapper.BigSegmentsQueryResult getBigSegments(String key) {
                return segmentStore == null ? null : segmentStore.getUserMembership(key);
            }
        }, logger);
        this.store = store;
        this.logger = logger;
        this.evaluationEventRecorderWithDetails = InputValidatingEvaluator.makeEvaluationRecorder(eventProcessor, true);
        this.evaluationEventRecorderWithoutDetails = InputValidatingEvaluator.makeEvaluationRecorder(eventProcessor, false);
    }

    @Override
    public EvalResultAndFlag evalAndFlag(String method, String flagKey, LDContext context, LDValue defaultValue, @Nullable LDValueType requireType, EvaluationOptions options) {
        EvaluationRecorder sink2 = options == EvaluationOptions.EVENTS_WITH_REASONS ? this.evaluationEventRecorderWithDetails : (options == EvaluationOptions.EVENTS_WITHOUT_REASONS ? this.evaluationEventRecorderWithoutDetails : NO_OP_EVALUATION_EVENT_RECORDER);
        return this.evaluate(flagKey, context, defaultValue, requireType, sink2);
    }

    EvalResultAndFlag evaluate(String flagKey, LDContext context, LDValue defaultValue, @Nullable LDValueType requireType, EvaluationRecorder recorder) {
        if (!this.store.isInitialized()) {
            this.logger.warn("Evaluation called before client initialized for feature flag \"{}\"; data store unavailable, returning default value", (Object)flagKey);
            recorder.recordEvaluationUnknownFlagError(flagKey, context, defaultValue, EvaluationReason.ErrorKind.CLIENT_NOT_READY);
            return new EvalResultAndFlag(EvalResult.error(EvaluationReason.ErrorKind.CLIENT_NOT_READY, defaultValue), null);
        }
        if (context == null) {
            this.logger.warn("Null context when evaluating flag \"{}\"; returning default value", (Object)flagKey);
            return new EvalResultAndFlag(EvalResult.error(EvaluationReason.ErrorKind.USER_NOT_SPECIFIED, defaultValue), null);
        }
        if (!context.isValid()) {
            this.logger.warn("Invalid context when evaluating flag \"{}\"; returning default value: " + context.getError(), (Object)flagKey);
            return new EvalResultAndFlag(EvalResult.error(EvaluationReason.ErrorKind.USER_NOT_SPECIFIED, defaultValue), null);
        }
        DataModel.FeatureFlag featureFlag = null;
        try {
            featureFlag = InputValidatingEvaluator.getFlag(this.store, flagKey);
            if (featureFlag == null) {
                this.logger.info("Unknown feature flag \"{}\"; returning default value", (Object)flagKey);
                recorder.recordEvaluationUnknownFlagError(flagKey, context, defaultValue, EvaluationReason.ErrorKind.FLAG_NOT_FOUND);
                return new EvalResultAndFlag(EvalResult.error(EvaluationReason.ErrorKind.FLAG_NOT_FOUND, defaultValue), null);
            }
            EvalResult result = this.evaluator.evaluate(featureFlag, context, recorder);
            if (result.isNoVariation()) {
                result = EvalResult.of(defaultValue, result.getVariationIndex(), result.getReason());
            } else {
                LDValue value = result.getValue();
                if (requireType != null && !value.isNull() && value.getType() != requireType) {
                    this.logger.error("Feature flag \"{}\"; evaluation expected result as {}, but got {}", new Object[]{flagKey, defaultValue.getType(), value.getType()});
                    recorder.recordEvaluationError(featureFlag, context, defaultValue, EvaluationReason.ErrorKind.WRONG_TYPE);
                    return new EvalResultAndFlag(EvalResult.error(EvaluationReason.ErrorKind.WRONG_TYPE, defaultValue), featureFlag);
                }
            }
            recorder.recordEvaluation(featureFlag, context, result, defaultValue);
            return new EvalResultAndFlag(result, featureFlag);
        }
        catch (Exception e) {
            this.logger.error("Encountered exception while evaluating feature flag \"{}\": {}", (Object)flagKey, LogValues.exceptionSummary(e));
            this.logger.debug("{}", LogValues.exceptionTrace(e));
            if (featureFlag == null) {
                recorder.recordEvaluationUnknownFlagError(flagKey, context, defaultValue, EvaluationReason.ErrorKind.EXCEPTION);
            } else {
                recorder.recordEvaluationError(featureFlag, context, defaultValue, EvaluationReason.ErrorKind.EXCEPTION);
            }
            return new EvalResultAndFlag(EvalResult.of(defaultValue, -1, EvaluationReason.exception(e)), null);
        }
    }

    @Override
    public FeatureFlagsState allFlagsState(LDContext context, FlagsStateOption ... options) {
        DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> flags;
        FeatureFlagsState.Builder builder = FeatureFlagsState.builder(options);
        if (!this.store.isInitialized()) {
            this.logger.warn("allFlagsState() was called before client initialized; data store unavailable, returning no data");
            return builder.valid(false).build();
        }
        if (context == null) {
            this.logger.warn("allFlagsState() was called with null context! returning no data");
            return builder.valid(false).build();
        }
        if (!context.isValid()) {
            this.logger.warn("allFlagsState() was called with invalid context: " + context.getError());
            return builder.valid(false).build();
        }
        boolean clientSideOnly = FlagsStateOption.hasOption(options, FlagsStateOption.CLIENT_SIDE_ONLY);
        try {
            flags = this.store.getAll(DataModel.FEATURES);
        }
        catch (Exception e) {
            this.logger.error("Exception from data store when evaluating all flags: {}", LogValues.exceptionSummary(e));
            this.logger.debug(e.toString(), LogValues.exceptionTrace(e));
            return builder.valid(false).build();
        }
        for (Map.Entry<String, DataStoreTypes.ItemDescriptor> entry : flags.getItems()) {
            if (entry.getValue().getItem() == null) continue;
            DataModel.FeatureFlag flag = (DataModel.FeatureFlag)entry.getValue().getItem();
            if (clientSideOnly && !flag.isClientSide()) continue;
            try {
                EvalResult result = this.evaluator.evaluate(flag, context, NO_OP_EVALUATION_EVENT_RECORDER);
                builder.addFlag(flag, result);
            }
            catch (Exception e) {
                this.logger.error("Exception caught for feature flag \"{}\" when evaluating all flags: {}", (Object)flag.getKey(), LogValues.exceptionSummary(e));
                this.logger.debug(e.toString(), LogValues.exceptionTrace(e));
                builder.addFlag(flag, EvalResult.of(LDValue.ofNull(), -1, EvaluationReason.exception(e)));
            }
        }
        return builder.build();
    }

    private static DataModel.FeatureFlag getFlag(ReadOnlyStore store, String key) {
        DataStoreTypes.ItemDescriptor item = store.get(DataModel.FEATURES, key);
        return item == null ? null : (DataModel.FeatureFlag)item.getItem();
    }

    private static DataModel.Segment getSegment(ReadOnlyStore store, String key) {
        DataStoreTypes.ItemDescriptor item = store.get(DataModel.SEGMENTS, key);
        return item == null ? null : (DataModel.Segment)item.getItem();
    }

    private static EvaluationRecorder makeEvaluationRecorder(final EventProcessor processor, final boolean withReasons) {
        return new EvaluationRecorder(){

            @Override
            public void recordEvaluation(DataModel.FeatureFlag flag, LDContext context, EvalResult result, LDValue defaultValue) {
                processor.recordEvaluationEvent(context, flag.getKey(), flag.getVersion(), result.getVariationIndex(), result.getValue(), withReasons || result.isForceReasonTracking() ? result.getReason() : null, defaultValue, null, flag.isTrackEvents() || result.isForceReasonTracking(), flag.getDebugEventsUntilDate(), flag.isExcludeFromSummaries(), flag.getSamplingRatio());
            }

            @Override
            public void recordPrerequisiteEvaluation(DataModel.FeatureFlag flag, DataModel.FeatureFlag prereqOfFlag, LDContext context, EvalResult result) {
                processor.recordEvaluationEvent(context, flag.getKey(), flag.getVersion(), result.getVariationIndex(), result.getValue(), withReasons || result.isForceReasonTracking() ? result.getReason() : null, LDValue.ofNull(), prereqOfFlag.getKey(), flag.isTrackEvents() || result.isForceReasonTracking(), flag.getDebugEventsUntilDate(), flag.isExcludeFromSummaries(), flag.getSamplingRatio());
            }

            @Override
            public void recordEvaluationError(DataModel.FeatureFlag flag, LDContext context, LDValue defaultValue, EvaluationReason.ErrorKind errorKind) {
                processor.recordEvaluationEvent(context, flag.getKey(), flag.getVersion(), -1, defaultValue, withReasons ? EvaluationReason.error(errorKind) : null, defaultValue, null, flag.isTrackEvents(), flag.getDebugEventsUntilDate(), flag.isExcludeFromSummaries(), flag.getSamplingRatio());
            }

            @Override
            public void recordEvaluationUnknownFlagError(String flagKey, LDContext context, LDValue defaultValue, EvaluationReason.ErrorKind errorKind) {
                processor.recordEvaluationEvent(context, flagKey, -1, -1, defaultValue, withReasons ? EvaluationReason.error(errorKind) : null, defaultValue, null, false, null, false, null);
            }
        };
    }
}

