/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.CacheExporter;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.sdk.server.subsystems.TransactionalDataStore;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableList;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableMap;
import com.launchdarkly.shaded.com.launchdarkly.sdk.internal.fdv2.sources.Selector;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

class InMemoryDataStore
implements DataStore,
TransactionalDataStore,
CacheExporter {
    private volatile ImmutableMap<DataStoreTypes.DataKind, Map<String, DataStoreTypes.ItemDescriptor>> allData = ImmutableMap.of();
    private volatile boolean initialized = false;
    private Object writeLock = new Object();
    private final Object selectorLock = new Object();
    private volatile Selector selector = Selector.EMPTY;
    private volatile boolean shouldPersist = false;

    InMemoryDataStore() {
    }

    @Override
    public void init(DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> allData) {
        this.applyFullPayload(allData.getData(), null, Selector.EMPTY, allData.shouldPersist());
    }

    @Override
    public DataStoreTypes.ItemDescriptor get(DataStoreTypes.DataKind kind, String key) {
        Map<String, DataStoreTypes.ItemDescriptor> items = this.allData.get(kind);
        if (items == null) {
            return null;
        }
        return items.get(key);
    }

    @Override
    public DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor> getAll(DataStoreTypes.DataKind kind) {
        Map<String, DataStoreTypes.ItemDescriptor> items = this.allData.get(kind);
        if (items == null) {
            return new DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>(null);
        }
        return new DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>(ImmutableList.copyOf(items.entrySet()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean upsert(DataStoreTypes.DataKind kind, String key, DataStoreTypes.ItemDescriptor item) {
        Object object = this.writeLock;
        synchronized (object) {
            Map<String, DataStoreTypes.ItemDescriptor> existingItems = this.allData.get(kind);
            DataStoreTypes.ItemDescriptor oldItem = null;
            if (existingItems != null && (oldItem = existingItems.get(key)) != null && oldItem.getVersion() >= item.getVersion()) {
                return false;
            }
            ImmutableMap.Builder newData = ImmutableMap.builder();
            for (Map.Entry e : this.allData.entrySet()) {
                if (((DataStoreTypes.DataKind)e.getKey()).equals(kind)) continue;
                newData.put(e.getKey(), e.getValue());
            }
            if (existingItems == null) {
                newData.put(kind, ImmutableMap.of(key, item));
            } else {
                ImmutableMap.Builder<String, DataStoreTypes.ItemDescriptor> itemsBuilder = ImmutableMap.builder();
                if (oldItem == null) {
                    itemsBuilder.putAll(existingItems);
                } else {
                    for (Map.Entry<String, DataStoreTypes.ItemDescriptor> e : existingItems.entrySet()) {
                        if (e.getKey().equals(key)) continue;
                        itemsBuilder.put(e.getKey(), e.getValue());
                    }
                }
                itemsBuilder.put(key, item);
                newData.put(kind, itemsBuilder.build());
            }
            this.allData = newData.build();
            return true;
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isStatusMonitoringEnabled() {
        return false;
    }

    @Override
    public DataStoreStatusProvider.CacheStats getCacheStats() {
        return null;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void apply(DataStoreTypes.ChangeSet<DataStoreTypes.ItemDescriptor> changeSet) {
        switch (changeSet.getType()) {
            case Full: {
                this.applyFullPayload(changeSet.getData(), changeSet.getEnvironmentId(), changeSet.getSelector(), changeSet.shouldPersist());
                break;
            }
            case Partial: {
                this.applyPartialData(changeSet.getData(), changeSet.getSelector(), changeSet.shouldPersist());
                break;
            }
            case None: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown ChangeSetType: " + (Object)((Object)changeSet.getType()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Selector getSelector() {
        Object object = this.selectorLock;
        synchronized (object) {
            return this.selector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSelector(Selector newSelector) {
        Object object = this.selectorLock;
        synchronized (object) {
            this.selector = newSelector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyPartialData(Iterable<Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>>> data, Selector selector, boolean shouldPersist) {
        Object object = this.writeLock;
        synchronized (object) {
            ImmutableMap.Builder itemsBuilder = ImmutableMap.builder();
            HashSet<DataStoreTypes.DataKind> updatedKinds = new HashSet<DataStoreTypes.DataKind>();
            for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> kindItemsPair : data) {
                updatedKinds.add(kindItemsPair.getKey());
            }
            for (Map.Entry existingEntry : this.allData.entrySet()) {
                if (updatedKinds.contains(existingEntry.getKey())) continue;
                itemsBuilder.put(existingEntry.getKey(), existingEntry.getValue());
            }
            for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> kindItemsPair : data) {
                DataStoreTypes.DataKind kind = kindItemsPair.getKey();
                HashMap<String, DataStoreTypes.ItemDescriptor> kindMap = new HashMap<String, DataStoreTypes.ItemDescriptor>();
                Map<String, DataStoreTypes.ItemDescriptor> itemsOfKind = this.allData.get(kind);
                if (itemsOfKind != null) {
                    kindMap.putAll(itemsOfKind);
                }
                for (Map.Entry<String, DataStoreTypes.ItemDescriptor> keyValuePair : kindItemsPair.getValue().getItems()) {
                    kindMap.put(keyValuePair.getKey(), keyValuePair.getValue());
                }
                itemsBuilder.put(kind, ImmutableMap.copyOf(kindMap));
            }
            this.allData = itemsBuilder.build();
            this.shouldPersist = shouldPersist;
            this.setSelector(selector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyFullPayload(Iterable<Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>>> data, String environmentId, Selector selector, boolean shouldPersist) {
        ImmutableMap.Builder itemsBuilder = ImmutableMap.builder();
        for (Map.Entry<DataStoreTypes.DataKind, DataStoreTypes.KeyedItems<DataStoreTypes.ItemDescriptor>> kindEntry : data) {
            ImmutableMap.Builder<String, DataStoreTypes.ItemDescriptor> kindItemsBuilder = ImmutableMap.builder();
            for (Map.Entry<String, DataStoreTypes.ItemDescriptor> e1 : kindEntry.getValue().getItems()) {
                kindItemsBuilder.put(e1.getKey(), e1.getValue());
            }
            itemsBuilder.put(kindEntry.getKey(), kindItemsBuilder.build());
        }
        ImmutableMap newItems = itemsBuilder.build();
        Object object = this.writeLock;
        synchronized (object) {
            this.allData = newItems;
            this.initialized = true;
            this.shouldPersist = shouldPersist;
            this.setSelector(selector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor> exportAll() {
        Object object = this.writeLock;
        synchronized (object) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (Map.Entry kindEntry : this.allData.entrySet()) {
                builder.add(new AbstractMap.SimpleEntry(kindEntry.getKey(), new DataStoreTypes.KeyedItems(ImmutableList.copyOf(((Map)kindEntry.getValue()).entrySet()))));
            }
            return new DataStoreTypes.FullDataSet<DataStoreTypes.ItemDescriptor>(builder.build(), this.shouldPersist);
        }
    }
}

