/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.ClientContextImpl;
import com.launchdarkly.sdk.server.Components;
import com.launchdarkly.sdk.server.DataSourceStatusProviderImpl;
import com.launchdarkly.sdk.server.DataSourceSynchronizerAdapter;
import com.launchdarkly.sdk.server.DataSourceUpdatesImpl;
import com.launchdarkly.sdk.server.DataStoreStatusProviderImpl;
import com.launchdarkly.sdk.server.DataStoreUpdatesImpl;
import com.launchdarkly.sdk.server.DataSystem;
import com.launchdarkly.sdk.server.EventBroadcasterImpl;
import com.launchdarkly.sdk.server.FDv2DataSource;
import com.launchdarkly.sdk.server.FlagChangeNotifier;
import com.launchdarkly.sdk.server.FlagChangedFacade;
import com.launchdarkly.sdk.server.InMemoryDataStore;
import com.launchdarkly.sdk.server.LDConfig;
import com.launchdarkly.sdk.server.ReadOnlyStore;
import com.launchdarkly.sdk.server.ReadonlyStoreFacade;
import com.launchdarkly.sdk.server.SelectorSourceFacade;
import com.launchdarkly.sdk.server.SettableCache;
import com.launchdarkly.sdk.server.WriteThroughStore;
import com.launchdarkly.sdk.server.datasources.Initializer;
import com.launchdarkly.sdk.server.datasources.Synchronizer;
import com.launchdarkly.sdk.server.interfaces.DataSourceStatusProvider;
import com.launchdarkly.sdk.server.interfaces.DataStoreStatusProvider;
import com.launchdarkly.sdk.server.interfaces.FlagChangeEvent;
import com.launchdarkly.sdk.server.interfaces.FlagChangeListener;
import com.launchdarkly.sdk.server.subsystems.DataSource;
import com.launchdarkly.sdk.server.subsystems.DataSourceBuildInputs;
import com.launchdarkly.sdk.server.subsystems.DataSourceBuilder;
import com.launchdarkly.sdk.server.subsystems.DataStore;
import com.launchdarkly.sdk.server.subsystems.DataSystemConfiguration;
import com.launchdarkly.sdk.server.subsystems.LoggingConfiguration;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Future;

final class FDv2DataSystem
implements DataSystem,
Closeable {
    private final DataSource dataSource;
    private final DataStore store;
    private final ReadOnlyStore readOnlyStore;
    private final FlagChangeNotifier flagChanged;
    private final DataSourceStatusProvider dataSourceStatusProvider;
    private final DataStoreStatusProvider dataStoreStatusProvider;
    private boolean disposed = false;

    private FDv2DataSystem(DataStore store, DataSource dataSource, DataSourceStatusProvider dataSourceStatusProvider, DataStoreStatusProvider dataStoreStatusProvider, FlagChangeNotifier flagChanged) {
        this.store = store;
        this.dataSource = dataSource;
        this.dataStoreStatusProvider = dataStoreStatusProvider;
        this.dataSourceStatusProvider = dataSourceStatusProvider;
        this.flagChanged = flagChanged;
        this.readOnlyStore = new ReadonlyStoreFacade(store);
    }

    static FDv2DataSystem create(LDLogger logger, LDConfig config, ClientContextImpl clientContext, LoggingConfiguration logConfig) {
        if (config.dataSystem == null) {
            throw new IllegalArgumentException("DataSystem configuration is required for FDv2DataSystem");
        }
        DataStoreUpdatesImpl dataStoreUpdates = new DataStoreUpdatesImpl(EventBroadcasterImpl.forDataStoreStatus(clientContext.sharedExecutor, logger));
        DataSystemConfiguration dataSystemConfiguration = config.dataSystem.build();
        InMemoryDataStore memoryStore = new InMemoryDataStore();
        DataStore persistentStore = null;
        if (dataSystemConfiguration.getPersistentStore() != null && (persistentStore = dataSystemConfiguration.getPersistentStore().build(clientContext.withDataStoreUpdateSink(dataStoreUpdates))) != null && dataSystemConfiguration.getPersistentDataStoreMode() == DataSystemConfiguration.DataStoreMode.READ_WRITE && persistentStore instanceof SettableCache) {
            ((SettableCache)((Object)persistentStore)).setCacheExporter(memoryStore);
        }
        WriteThroughStore store = new WriteThroughStore(memoryStore, persistentStore, dataSystemConfiguration.getPersistentDataStoreMode());
        DataStoreStatusProviderImpl dataStoreStatusProvider = new DataStoreStatusProviderImpl(store, dataStoreUpdates);
        EventBroadcasterImpl<FlagChangeListener, FlagChangeEvent> flagChangeBroadcaster = EventBroadcasterImpl.forFlagChangeEvents(clientContext.sharedExecutor, logger);
        EventBroadcasterImpl<DataSourceStatusProvider.StatusListener, DataSourceStatusProvider.Status> dataSourceStatusBroadcaster = EventBroadcasterImpl.forDataSourceStatus(clientContext.sharedExecutor, logger);
        DataSourceUpdatesImpl dataSourceUpdates = new DataSourceUpdatesImpl(store, dataStoreStatusProvider, flagChangeBroadcaster, dataSourceStatusBroadcaster, clientContext.sharedExecutor, logConfig.getLogDataSourceOutageAsErrorAfter(), logger);
        SelectorSourceFacade selectorSource = new SelectorSourceFacade(store);
        DataSourceBuildInputs builderContext = new DataSourceBuildInputs(clientContext.getBaseLogger(), clientContext.getThreadPriority(), dataSourceUpdates, clientContext.getServiceEndpoints(), clientContext.getHttp(), clientContext.sharedExecutor, clientContext.diagnosticStore, selectorSource);
        ImmutableList<FDv2DataSource.DataSourceFactory<Initializer>> initializerFactories = dataSystemConfiguration.getInitializers().stream().map(initializer -> new FactoryWrapper(initializer, builderContext)).collect(ImmutableList.toImmutableList());
        ImmutableList<FDv2DataSource.DataSourceFactory<Synchronizer>> synchronizerFactories = dataSystemConfiguration.getSynchronizers().stream().map(synchronizer -> new FactoryWrapper(synchronizer, builderContext)).collect(ImmutableList.toImmutableList());
        FDv2DataSource.DataSourceFactory<Synchronizer> fdv1FallbackFactory = null;
        if (dataSystemConfiguration.getFDv1FallbackSynchronizer() != null) {
            fdv1FallbackFactory = () -> new DataSourceSynchronizerAdapter(updateSink -> dataSystemConfiguration.getFDv1FallbackSynchronizer().build(clientContext.withDataSourceUpdateSink(updateSink)));
        }
        DataSource dataSource = config.offline ? Components.externalUpdatesOnly().build(clientContext.withDataSourceUpdateSink(dataSourceUpdates)) : new FDv2DataSource(initializerFactories, synchronizerFactories, fdv1FallbackFactory, dataSourceUpdates, config.threadPriority, clientContext.getBaseLogger().subLogger("DataSource"), clientContext.sharedExecutor);
        DataSourceStatusProviderImpl dataSourceStatusProvider = new DataSourceStatusProviderImpl(dataSourceStatusBroadcaster, dataSourceUpdates);
        FlagChangedFacade flagChanged = new FlagChangedFacade(dataSourceUpdates);
        return new FDv2DataSystem(store, dataSource, dataSourceStatusProvider, dataStoreStatusProvider, flagChanged);
    }

    @Override
    public ReadOnlyStore getStore() {
        return this.readOnlyStore;
    }

    @Override
    public Future<Void> start() {
        return this.dataSource.start();
    }

    @Override
    public boolean isInitialized() {
        return this.dataSource.isInitialized();
    }

    @Override
    public FlagChangeNotifier getFlagChanged() {
        return this.flagChanged;
    }

    @Override
    public DataSourceStatusProvider getDataSourceStatusProvider() {
        return this.dataSourceStatusProvider;
    }

    @Override
    public DataStoreStatusProvider getDataStoreStatusProvider() {
        return this.dataStoreStatusProvider;
    }

    @Override
    public void close() throws IOException {
        if (this.disposed) {
            return;
        }
        try {
            this.dataSource.close();
            this.store.close();
        }
        finally {
            this.disposed = true;
        }
    }

    private static class FactoryWrapper<TDataSource>
    implements FDv2DataSource.DataSourceFactory<TDataSource> {
        private final DataSourceBuilder<TDataSource> builder;
        private final DataSourceBuildInputs context;

        public FactoryWrapper(DataSourceBuilder<TDataSource> builder, DataSourceBuildInputs context) {
            this.builder = builder;
            this.context = context;
        }

        @Override
        public TDataSource build() {
            return this.builder.build(this.context);
        }
    }
}

