/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server;

import com.launchdarkly.sdk.server.datasources.FDv2SourceResult;
import java.io.Closeable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class FDv2DataSourceConditions {
    private FDv2DataSourceConditions() {
    }

    static class RecoveryCondition
    extends TimedCondition {
        public RecoveryCondition(ScheduledExecutorService sharedExecutor, long timeoutSeconds) {
            super(sharedExecutor, timeoutSeconds);
            this.timerFuture = sharedExecutor.schedule(() -> {
                this.resultFuture.complete(this);
                return null;
            }, timeoutSeconds, TimeUnit.SECONDS);
        }

        @Override
        public void inform(FDv2SourceResult sourceResult) {
        }

        @Override
        public Condition.ConditionType getType() {
            return Condition.ConditionType.RECOVERY;
        }

        static class Factory
        extends TimedCondition.Factory {
            public Factory(ScheduledExecutorService sharedExecutor, long timeout2) {
                super(sharedExecutor, timeout2);
            }

            @Override
            public Condition build() {
                return new RecoveryCondition(this.sharedExecutor, this.timeoutSeconds);
            }

            @Override
            public Condition.ConditionType getType() {
                return Condition.ConditionType.RECOVERY;
            }
        }
    }

    static class FallbackCondition
    extends TimedCondition {
        public FallbackCondition(ScheduledExecutorService sharedExecutor, long timeoutSeconds) {
            super(sharedExecutor, timeoutSeconds);
        }

        @Override
        public void inform(FDv2SourceResult sourceResult) {
            if (sourceResult.getResultType() == FDv2SourceResult.ResultType.CHANGE_SET && this.timerFuture != null) {
                this.timerFuture.cancel(false);
                this.timerFuture = null;
            }
            if (sourceResult.getResultType() == FDv2SourceResult.ResultType.STATUS && sourceResult.getStatus().getState() == FDv2SourceResult.State.INTERRUPTED && this.timerFuture == null) {
                this.timerFuture = this.sharedExecutor.schedule(() -> {
                    this.resultFuture.complete(this);
                    return null;
                }, this.timeoutSeconds, TimeUnit.SECONDS);
            }
        }

        @Override
        public Condition.ConditionType getType() {
            return Condition.ConditionType.FALLBACK;
        }

        static class Factory
        extends TimedCondition.Factory {
            public Factory(ScheduledExecutorService sharedExecutor, long timeout2) {
                super(sharedExecutor, timeout2);
            }

            @Override
            public Condition build() {
                return new FallbackCondition(this.sharedExecutor, this.timeoutSeconds);
            }

            @Override
            public Condition.ConditionType getType() {
                return Condition.ConditionType.FALLBACK;
            }
        }
    }

    static abstract class TimedCondition
    implements Condition {
        protected final CompletableFuture<Condition> resultFuture = new CompletableFuture();
        protected final ScheduledExecutorService sharedExecutor;
        protected ScheduledFuture<Void> timerFuture;
        protected final long timeoutSeconds;

        public TimedCondition(ScheduledExecutorService sharedExecutor, long timeoutSeconds) {
            this.sharedExecutor = sharedExecutor;
            this.timeoutSeconds = timeoutSeconds;
        }

        @Override
        public CompletableFuture<Condition> execute() {
            return this.resultFuture;
        }

        @Override
        public void close() {
            if (this.timerFuture != null) {
                this.timerFuture.cancel(false);
                this.timerFuture = null;
            }
        }

        static abstract class Factory
        implements ConditionFactory {
            protected final ScheduledExecutorService sharedExecutor;
            protected final long timeoutSeconds;

            public Factory(ScheduledExecutorService sharedExecutor, long timeout2) {
                this.sharedExecutor = sharedExecutor;
                this.timeoutSeconds = timeout2;
            }
        }
    }

    static interface ConditionFactory {
        public Condition build();

        public Condition.ConditionType getType();
    }

    static interface Condition
    extends Closeable {
        public CompletableFuture<Condition> execute();

        public void inform(FDv2SourceResult var1);

        @Override
        public void close();

        public ConditionType getType();

        public static enum ConditionType {
            FALLBACK,
            RECOVERY;

        }
    }
}

